/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.function.BiConsumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OptionalChainInliner
implements CallInliner {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1), CallMatcher.instanceCall("com.google.common.base.Optional", "or").parameterTypes("T"));
    private static final CallMatcher OPTIONAL_OR_NULL = CallMatcher.instanceCall("com.google.common.base.Optional", "orNull").parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1), CallMatcher.instanceCall("com.google.common.base.Optional", "or").parameterTypes("com.google.common.base.Supplier"));
    private static final CallMatcher OPTIONAL_OR = CallMatcher.instanceCall("java.util.Optional", "or").parameterCount(1);
    private static final CallMatcher OPTIONAL_IF_PRESENT = CallMatcher.instanceCall("java.util.Optional", "ifPresent").parameterCount(1);
    private static final CallMatcher OPTIONAL_FILTER = CallMatcher.instanceCall("java.util.Optional", "filter").parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);
    private static final CallMatcher GUAVA_TRANSFORM = CallMatcher.instanceCall("com.google.common.base.Optional", "transform").parameterCount(1);
    private static final CallMatcher OPTIONAL_FLAT_MAP = CallMatcher.instanceCall("java.util.Optional", "flatMap").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Optional", "of", "ofNullable").parameterCount(1), CallMatcher.staticCall("com.google.common.base.Optional", "of", "fromNullable").parameterCount(1));
    private static final CallMatcher OPTIONAL_EMPTY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Optional", "empty").parameterCount(0), CallMatcher.staticCall("com.google.common.base.Optional", "absent").parameterCount(0));
    private static final CallMatcher GUAVA_TO_JAVA = CallMatcher.instanceCall("com.google.common.base.Optional", "toJavaUtil").parameterCount(0);
    private static final CallMapper<BiConsumer<CFGBuilder, PsiMethodCallExpression>> TERMINAL_MAPPER = new CallMapper<BiConsumer<CFGBuilder, PsiMethodCallExpression>>().register(OPTIONAL_OR_ELSE, (builder, call) -> {
        PsiExpression argument = call.getArgumentList().getExpressions()[0];
        builder.pushExpression(argument).boxUnbox(argument, call.getType()).splice(2, 0, 1, 1).ifNotNull().swap().endIf().pop();
    }).register(OPTIONAL_OR_NULL, (builder, call) -> {}).register(OPTIONAL_OR_ELSE_GET, (builder, call) -> {
        PsiExpression fn = call.getArgumentList().getExpressions()[0];
        builder.evaluateFunction(fn).dup().ifNull().pop().invokeFunction(0, fn).endIf();
    }).register(OPTIONAL_IF_PRESENT, (builder, call) -> {
        PsiExpression fn = call.getArgumentList().getExpressions()[0];
        builder.evaluateFunction(fn).dup().ifNotNull().invokeFunction(0, fn).elseBranch().pop().pushUnknown().endIf();
    });
    private static final CallMapper<BiConsumer<CFGBuilder, PsiExpression>> INTERMEDIATE_MAPPER = new CallMapper<BiConsumer<CFGBuilder, PsiExpression>>().register(OPTIONAL_MAP, (builder, function) -> OptionalChainInliner.inlineMap(builder, function, Nullness.NULLABLE)).register(GUAVA_TRANSFORM, (builder, function) -> OptionalChainInliner.inlineMap(builder, function, Nullness.NOT_NULL)).register(OPTIONAL_FILTER, (builder, function) -> builder.evaluateFunction((PsiExpression)function).dup().ifNotNull().dup().invokeFunction(1, (PsiExpression)function).ifConditionIs(false).pop().pushNull().endIf().endIf()).register(OPTIONAL_FLAT_MAP, (builder, function) -> builder.dup().ifNotNull().chain(b -> OptionalChainInliner.invokeAndUnwrapOptional(b, 1, function)).endIf()).register(OPTIONAL_OR, (builder, function) -> builder.dup().ifNull().pop().chain(b -> OptionalChainInliner.invokeAndUnwrapOptional(b, 0, function)).endIf()).register(GUAVA_TO_JAVA, (builder, stub) -> {});

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        BiConsumer<CFGBuilder, PsiMethodCallExpression> terminalInliner;
        if (builder == null) {
            OptionalChainInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            OptionalChainInliner.$$$reportNull$$$0(1);
        }
        if ((terminalInliner = TERMINAL_MAPPER.mapFirst(call)) != null) {
            PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
            if (!OptionalChainInliner.pushOptionalValue(builder, PsiUtil.skipParenthesizedExprDown(qualifierExpression), call, NullabilityProblem.callNPE)) {
                return false;
            }
            terminalInliner.accept(builder, call);
            return true;
        }
        DfaOptionalValue.Factory optionalFactory = builder.getFactory().getOptionalFactory();
        if (OptionalChainInliner.pushIntermediateOperationValue(builder, call)) {
            builder.ifNotNull().push(optionalFactory.getOptional(true)).elseBranch().push(optionalFactory.getOptional(false)).endIf();
            return true;
        }
        if (OPTIONAL_EMPTY.test(call)) {
            builder.push(optionalFactory.getOptional(false));
            return true;
        }
        return false;
    }

    @Contract(value="null -> null")
    private static PsiType getOptionalElementType(PsiExpression expression) {
        if (expression == null) {
            return null;
        }
        PsiClassType type = ObjectUtils.tryCast(expression.getType(), PsiClassType.class);
        if (type == null) {
            return null;
        }
        String rawName = type.rawType().getCanonicalText();
        if (!rawName.equals("java.util.Optional") && !rawName.equals("com.google.common.base.Optional")) {
            return null;
        }
        PsiType[] parameters = type.getParameters();
        if (parameters.length != 1) {
            return null;
        }
        return parameters[0];
    }

    private static boolean pushOptionalValue(CFGBuilder builder, PsiExpression expression, PsiExpression dereferenceContext, NullabilityProblem problem) {
        PsiType optionalElementType = OptionalChainInliner.getOptionalElementType(expression);
        if (optionalElementType == null) {
            return false;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)expression;
            if (OPTIONAL_EMPTY.test(qualifierCall)) {
                builder.pushNull();
                return true;
            }
            if (OptionalChainInliner.pushIntermediateOperationValue(builder, qualifierCall)) {
                builder.assignTo(builder.createTempVariable(optionalElementType));
                return true;
            }
        }
        DfaOptionalValue presentOptional = builder.getFactory().getOptionalFactory().getOptional(true);
        builder.pushExpression(expression).checkNotNull(dereferenceContext, problem).push(presentOptional).ifCondition(JavaTokenType.INSTANCEOF_KEYWORD).push(builder.getFactory().createTypeValue(optionalElementType, Nullness.NOT_NULL)).elseBranch().pushNull().endIf().assignTo(builder.createTempVariable(optionalElementType));
        return true;
    }

    private static boolean pushIntermediateOperationValue(CFGBuilder builder, PsiMethodCallExpression call) {
        if (OPTIONAL_OF.test(call)) {
            PsiType optionalElementType = OptionalChainInliner.getOptionalElementType(call);
            OptionalChainInliner.inlineOf(builder, optionalElementType, call);
            return true;
        }
        BiConsumer<CFGBuilder, PsiExpression> intermediateInliner = INTERMEDIATE_MAPPER.mapFirst(call);
        if (intermediateInliner == null) {
            return false;
        }
        PsiExpression argument = ArrayUtil.getFirstElement(call.getArgumentList().getExpressions());
        PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
        if (!OptionalChainInliner.pushOptionalValue(builder, PsiUtil.skipParenthesizedExprDown(qualifierExpression), call, NullabilityProblem.callNPE)) {
            return false;
        }
        intermediateInliner.accept(builder, argument);
        return true;
    }

    private static void invokeAndUnwrapOptional(CFGBuilder builder, int argCount, PsiExpression function) {
        PsiLambdaExpression lambda2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(function), PsiLambdaExpression.class);
        if (lambda2 != null) {
            Object[] parameters = lambda2.getParameterList().getParameters();
            PsiExpression lambdaBody = LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody());
            if (parameters.length == argCount && lambdaBody != null) {
                StreamEx.ofReversed((Object[])parameters).forEach(p -> builder.assignTo((PsiVariable)p).pop());
                if (OptionalChainInliner.pushOptionalValue(builder, lambdaBody, lambdaBody, NullabilityProblem.nullableFunctionReturn)) {
                    return;
                }
                StreamEx.of((Object[])parameters).forEach(p -> builder.push(builder.getFactory().getVarFactory().createVariableValue((PsiVariable)p, false)));
            }
        }
        builder.evaluateFunction(function).invokeFunction(argCount, function, Nullness.NOT_NULL).pop().pushUnknown();
    }

    private static void inlineMap(CFGBuilder builder, PsiExpression function, Nullness resultNullness) {
        builder.evaluateFunction(function).dup().ifNotNull().invokeFunction(1, function, resultNullness).endIf();
    }

    private static void inlineOf(CFGBuilder builder, PsiType optionalElementType, PsiMethodCallExpression qualifierCall) {
        PsiExpression argument = qualifierCall.getArgumentList().getExpressions()[0];
        builder.pushExpression(argument).boxUnbox(argument, optionalElementType).pushUnknown().splice(2, 1, 0, 1).invoke(qualifierCall).pop();
        if ("of".equals(qualifierCall.getMethodExpression().getReferenceName())) {
            builder.checkNotNull(argument, NullabilityProblem.passingNullableToNotNullParameter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/inliner/OptionalChainInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

