/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNode<T>
extends PresentableNodeDescriptor<AbstractTreeNode<T>>
implements NavigationItem,
Queryable.Contributor {
    private static final Logger LOG = Logger.getInstance(AbstractTreeNode.class);
    private AbstractTreeNode myParent;
    private Object myValue;
    private boolean myNullValueSet;
    private final boolean myNodeWrapper;
    private NodeDescriptor myParentDescriptor;

    protected AbstractTreeNode(Project project, T value) {
        super(project, null);
        this.myNodeWrapper = this.setInternalValue(value);
    }

    @NotNull
    public abstract Collection<? extends AbstractTreeNode> getChildren();

    protected boolean hasProblemFileBeneath() {
        return false;
    }

    protected boolean valueIsCut() {
        return CopyPasteManager.getInstance().isCutElement(this.getValue());
    }

    @Override
    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        Collection<AbstractTreeNode> kids = this.getChildren();
        int i2 = 0;
        for (AbstractTreeNode kid : kids) {
            if (i2 == index) {
                return kid;
            }
            ++i2;
        }
        return null;
    }

    @Override
    protected void postprocess(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(0);
        }
        if (this.hasProblemFileBeneath()) {
            presentation.setAttributesKey(CodeInsightColors.ERRORS_ATTRIBUTES);
        }
        this.setForcedForeground(presentation);
    }

    protected void setForcedForeground(@NotNull PresentationData presentation) {
        FileStatus status;
        Color fgColor;
        if (presentation == null) {
            AbstractTreeNode.$$$reportNull$$$0(1);
        }
        Color color = fgColor = (fgColor = this.getFileStatusColor(status = this.getFileStatus())) == null ? status.getColor() : fgColor;
        if (this.valueIsCut()) {
            fgColor = CopyPasteManager.CUT_COLOR;
        }
        if (presentation.getForcedTextForeground() == null) {
            presentation.setForcedTextForeground(fgColor);
        }
    }

    @Override
    protected boolean shouldUpdateData() {
        return !this.myProject.isDisposed() && this.getEqualityObject() != null;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAlwaysLeaf() {
        return false;
    }

    public boolean isAlwaysExpand() {
        return false;
    }

    @Override
    @Nullable
    public final AbstractTreeNode<T> getElement() {
        return this.getEqualityObject() != null ? this : null;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractTreeNode && Comparing.equal(this.myValue, ((AbstractTreeNode)object).myValue);
    }

    public int hashCode() {
        Object value = this.myValue;
        return value == null ? 0 : value.hashCode();
    }

    public final AbstractTreeNode getParent() {
        return this.myParent;
    }

    public final void setParent(AbstractTreeNode parent) {
        this.myParent = parent;
        this.myParentDescriptor = parent;
    }

    @Override
    public final NodeDescriptor getParentDescriptor() {
        return this.myParentDescriptor;
    }

    public final T getValue() {
        Object value = this.getEqualityObject();
        return (T)(value == null ? null : TreeAnchorizer.getService().retrieveElement(value));
    }

    public final void setValue(T value) {
        boolean debug = !this.myNodeWrapper && LOG.isDebugEnabled();
        int hash = !debug ? 0 : this.hashCode();
        this.myNullValueSet = this.setInternalValue(value);
        if (debug && hash != this.hashCode()) {
            LOG.warn("hash code changed: " + this.myValue);
        }
    }

    private boolean setInternalValue(T value) {
        if (value == null) {
            return true;
        }
        this.myValue = TreeAnchorizer.getService().createAnchor(value);
        return false;
    }

    public final Object getEqualityObject() {
        return this.myNullValueSet ? null : this.myValue;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        String text2;
        if (this.getValue() instanceof Queryable && (text2 = Queryable.Util.print((Queryable)this.getValue(), printInfo, this)) != null) {
            return text2;
        }
        return this.getTestPresentation();
    }

    @Override
    public void apply(@NotNull Map<String, String> info) {
        if (info == null) {
            AbstractTreeNode.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    @NonNls
    public String getTestPresentation() {
        if (this.myName != null) {
            return this.myName;
        }
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    public Color getFileStatusColor(FileStatus status) {
        VirtualFile vf;
        if (FileStatus.NOT_CHANGED.equals(status) && (vf = this.getVirtualFile()) != null && vf.isDirectory()) {
            return FileStatusManager.getInstance(this.myProject).getNotChangedDirectoryColor(vf);
        }
        return status.getColor();
    }

    protected VirtualFile getVirtualFile() {
        return null;
    }

    public FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void navigate(boolean requestFocus) {
    }

    @Override
    public boolean canNavigate() {
        return false;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    protected final Object getParentValue() {
        AbstractTreeNode parent = this.getParent();
        return parent == null ? null : parent.getValue();
    }

    public boolean canRepresent(Object element) {
        return Comparing.equal(this.getValue(), element);
    }

    protected String getToolTip() {
        return ((PresentationData)this.getPresentation()).getTooltip();
    }

    @Nullable
    public TextAttributesKey getAttributesKey() {
        return ((PresentationData)this.getPresentation()).getTextAttributesKey();
    }

    @Nullable
    public String getLocationString() {
        return ((PresentationData)this.getPresentation()).getLocationString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "postprocess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setForcedForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

