/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowSearchUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.ThrowSearchUtil");

    private ThrowSearchUtil() {
    }

    private static boolean processExn(@NotNull PsiParameter aCatch, @NotNull Processor<UsageInfo> processor, @NotNull Root root) {
        PsiType type;
        if (aCatch == null) {
            ThrowSearchUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ThrowSearchUtil.$$$reportNull$$$0(1);
        }
        if (root == null) {
            ThrowSearchUtil.$$$reportNull$$$0(2);
        }
        if ((type = aCatch.getType()).isAssignableFrom(root.myType)) {
            processor.process(new UsageInfo(aCatch));
            return false;
        }
        if (!root.isExact && root.myType.isAssignableFrom(type)) {
            processor.process(new UsageInfo(aCatch));
            return true;
        }
        return true;
    }

    private static boolean scanCatches(@NotNull PsiElement elem, @NotNull Processor<UsageInfo> processor, @NotNull Root root, @NotNull FindUsagesOptions options, @NotNull Set<PsiMethod> processed2) {
        if (elem == null) {
            ThrowSearchUtil.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ThrowSearchUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            ThrowSearchUtil.$$$reportNull$$$0(5);
        }
        if (options == null) {
            ThrowSearchUtil.$$$reportNull$$$0(6);
        }
        if (processed2 == null) {
            ThrowSearchUtil.$$$reportNull$$$0(7);
        }
        while (elem != null) {
            PsiTryStatement tryStmt;
            PsiElement parent = elem.getParent();
            if (elem instanceof PsiMethod) {
                PsiMethod method;
                PsiMethod deepestSuperMethod = ((PsiMethod)elem).findDeepestSuperMethod();
                PsiMethod psiMethod = method = deepestSuperMethod != null ? deepestSuperMethod : (PsiMethod)elem;
                if (!processed2.contains(method)) {
                    processed2.add(method);
                    PsiReference[] refs = MethodReferencesSearch.search(method, options.searchScope, true).toArray((PsiReference[])PsiReference.EMPTY_ARRAY);
                    for (int i2 = 0; i2 != refs.length; ++i2) {
                        if (ThrowSearchUtil.scanCatches(refs[i2].getElement(), processor, root, options, processed2)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (elem instanceof PsiTryStatement) {
                PsiTryStatement aTry = (PsiTryStatement)elem;
                PsiParameter[] catches = aTry.getCatchBlockParameters();
                for (int i3 = 0; i3 != catches.length; ++i3) {
                    if (ThrowSearchUtil.processExn(catches[i3], processor, root)) continue;
                    return false;
                }
            } else if (parent instanceof PsiTryStatement && elem != (tryStmt = (PsiTryStatement)parent).getTryBlock()) {
                elem = parent.getParent();
                continue;
            }
            elem = parent;
        }
        return true;
    }

    public static boolean addThrowUsages(@NotNull Processor<UsageInfo> processor, @NotNull Root root, @NotNull FindUsagesOptions options) {
        if (processor == null) {
            ThrowSearchUtil.$$$reportNull$$$0(8);
        }
        if (root == null) {
            ThrowSearchUtil.$$$reportNull$$$0(9);
        }
        if (options == null) {
            ThrowSearchUtil.$$$reportNull$$$0(10);
        }
        HashSet<PsiMethod> processed2 = new HashSet<PsiMethod>();
        return ThrowSearchUtil.scanCatches(root.myElement, processor, root, options, processed2);
    }

    private static boolean isExactExnType(PsiExpression exn) {
        return exn instanceof PsiNewExpression;
    }

    @Nullable
    public static Root[] getSearchRoots(PsiElement element) {
        PsiElement parent;
        PsiKeyword kwd;
        if (element instanceof PsiThrowStatement) {
            PsiThrowStatement aThrow = (PsiThrowStatement)element;
            PsiExpression exn = aThrow.getException();
            return new Root[]{new Root(aThrow.getParent(), exn.getType(), ThrowSearchUtil.isExactExnType(exn))};
        }
        if (element instanceof PsiKeyword && "throws".equals((kwd = (PsiKeyword)element).getText()) && (parent = kwd.getParent()) != null && parent.getParent() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent.getParent();
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] exns = throwsList.getReferencedTypes();
            Root[] roots = new Root[exns.length];
            for (int i2 = 0; i2 != roots.length; ++i2) {
                PsiClassType exn = exns[i2];
                roots[i2] = new Root(method, exn, false);
            }
            return roots;
        }
        return null;
    }

    public static boolean isSearchable(PsiElement element) {
        return ThrowSearchUtil.getSearchRoots(element) != null;
    }

    public static String getSearchableTypeName(PsiElement e) {
        if (e instanceof PsiThrowStatement) {
            PsiThrowStatement aThrow = (PsiThrowStatement)e;
            PsiType type = aThrow.getException().getType();
            return PsiFormatUtil.formatType(type, 8192, PsiSubstitutor.EMPTY);
        }
        if (e instanceof PsiKeyword && "throws".equals(e.getText())) {
            return e.getParent().getText();
        }
        LOG.error("invalid searchable element");
        return e.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aCatch";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/ThrowSearchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processExn";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "scanCatches";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addThrowUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Root {
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final PsiType myType;
        private final boolean isExact;

        public Root(@NotNull PsiElement root, @NotNull PsiType type, boolean exact) {
            if (root == null) {
                Root.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Root.$$$reportNull$$$0(1);
            }
            this.myElement = root;
            this.myType = type;
            this.isExact = exact;
        }

        public String toString() {
            return PsiFormatUtil.formatType(this.myType, 8192, PsiSubstitutor.EMPTY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/search/ThrowSearchUtil$Root";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

