/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stub;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.util.ArrayUtil;

public class JavaStubImplUtil {
    public static int getMethodStubIndex(PsiMethod method) {
        if (!(method instanceof PsiMethodImpl)) {
            return -1;
        }
        PsiFileImpl file = (PsiFileImpl)method.getContainingFile();
        if (file.getElementTypeForStubBuilder() == null) {
            return -1;
        }
        StubTree stubTree = file.getStubTree();
        if (stubTree == null) {
            stubTree = file.calcStubTree();
        }
        Object[] stubs = (PsiElement[])stubTree.getPlainList().stream().filter(e -> e.getStubType() == JavaElementType.METHOD).map(StubElement::getPsi).toArray(PsiElement[]::new);
        return ArrayUtil.indexOf(stubs, method);
    }
}

