/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface CachedValueProvider<T> {
    @Nullable
    public Result<T> compute();

    public static class Result<T> {
        private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.CachedValueProvider.Result");
        private final T myValue;
        private final Object[] myDependencyItems;

        public Result(@Nullable T value, Object ... dependencyItems) {
            if (dependencyItems == null) {
                Result.$$$reportNull$$$0(0);
            }
            this.myValue = value;
            this.myDependencyItems = dependencyItems;
            if (dependencyItems.length == 0) {
                LOG.error("No dependencies provided which causes CachedValue to be never recalculated again. If this is intentional, please use ModificationTracker.NEVER_CHANGED");
            }
            for (int i2 = 0; i2 < dependencyItems.length; ++i2) {
                if (dependencyItems[i2] != null) continue;
                LOG.error("Null dependencies are not allowed, index=" + i2);
            }
        }

        public T getValue() {
            return this.myValue;
        }

        @NotNull
        public Object[] getDependencyItems() {
            if (this.myDependencyItems == null) {
                Result.$$$reportNull$$$0(1);
            }
            return this.myDependencyItems;
        }

        public static <T> Result<T> createSingleDependency(@Nullable T value, @NotNull Object dependency) {
            if (dependency == null) {
                Result.$$$reportNull$$$0(2);
            }
            return Result.create(value, dependency);
        }

        public static <T> Result<T> create(@Nullable T value, Object ... dependencies) {
            if (dependencies == null) {
                Result.$$$reportNull$$$0(3);
            }
            return new Result<T>(value, dependencies);
        }

        public static <T> Result<T> create(@Nullable T value, @NotNull Collection<?> dependencies) {
            if (dependencies == null) {
                Result.$$$reportNull$$$0(4);
            }
            return new Result<T>(value, ArrayUtil.toObjectArray(dependencies));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyItems";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/util/CachedValueProvider$Result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/util/CachedValueProvider$Result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencyItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createSingleDependency";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

