/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BidirectionalMultiMap<K, V> {
    private final Map<K, Set<V>> myKey2Values;
    private final Map<V, Set<K>> myValue2Keys;

    public BidirectionalMultiMap() {
        this(new HashMap(), new HashMap());
    }

    public BidirectionalMultiMap(Map<K, Set<V>> key2Values, Map<V, Set<K>> value2Keys) {
        this.myKey2Values = key2Values;
        this.myValue2Keys = value2Keys;
    }

    @NotNull
    public Set<V> getValues(K key) {
        Set<V> set = this.myKey2Values.get(key);
        Set<Object> set2 = set != null ? set : Collections.emptySet();
        if (set2 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(0);
        }
        return set2;
    }

    @NotNull
    public Set<K> getKeys(V value) {
        Set<K> set = this.myValue2Keys.get(value);
        Set<Object> set2 = set != null ? set : Collections.emptySet();
        if (set2 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(1);
        }
        return set2;
    }

    public boolean containsKey(K key) {
        return this.myKey2Values.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.myValue2Keys.containsKey(value);
    }

    public boolean put(K key, V value) {
        Set<K> ks = this.myValue2Keys.get(value);
        if (ks == null) {
            ks = this.createKeysSet();
            this.myValue2Keys.put((Set<K>)value, (Set<V>)ks);
        }
        ks.add(key);
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            vs = this.createValuesSet();
            this.myKey2Values.put(key, vs);
        }
        return vs.add(value);
    }

    @NotNull
    protected Set<V> createValuesSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    protected Set<K> createKeysSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public boolean removeKey(K key) {
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            return false;
        }
        for (V v : vs) {
            Set<K> ks = this.myValue2Keys.get(v);
            ks.remove(key);
            if (!ks.isEmpty()) continue;
            this.myValue2Keys.remove(v);
        }
        this.myKey2Values.remove(key);
        return true;
    }

    public void remove(K key, V value) {
        Set<V> vs = this.myKey2Values.get(key);
        Set<K> ks = this.myValue2Keys.get(value);
        if (ks != null && vs != null) {
            ks.remove(key);
            vs.remove(value);
            if (ks.isEmpty()) {
                this.myValue2Keys.remove(value);
            }
            if (vs.isEmpty()) {
                this.myKey2Values.remove(key);
            }
        }
    }

    public boolean isEmpty() {
        return this.myKey2Values.isEmpty() && this.myValue2Keys.isEmpty();
    }

    public boolean removeValue(V value) {
        Set<K> ks = this.myValue2Keys.get(value);
        if (ks == null) {
            return false;
        }
        for (K k : ks) {
            Set<V> vs = this.myKey2Values.get(k);
            vs.remove(value);
            if (!vs.isEmpty()) continue;
            this.myKey2Values.remove(k);
        }
        this.myValue2Keys.remove(value);
        return true;
    }

    public void clear() {
        this.myKey2Values.clear();
        this.myValue2Keys.clear();
    }

    public Set<K> getKeys() {
        return this.myKey2Values.keySet();
    }

    public Set<V> getValues() {
        return this.myValue2Keys.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/containers/BidirectionalMultiMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createValuesSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeysSet";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

