/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PointlessBitwiseExpressionInspection
extends BaseInspection {
    public boolean m_ignoreExpressionsContainingConstants = false;
    static final Set<IElementType> bitwiseTokens = new HashSet<IElementType>(6);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.display.name", new Object[0]);
        if (string == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[0];
        String replacementExpression = this.calculateReplacementExpression(polyadicExpression);
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", replacementExpression);
        if (string == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), this, "m_ignoreExpressionsContainingConstants");
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression) {
        IElementType tokenType = expression.getOperationTokenType();
        PsiExpression[] operands = expression.getOperands();
        PsiExpression previousOperand = null;
        int length = operands.length;
        for (int i2 = 0; i2 < length; ++i2) {
            PsiExpression operand = operands[i2];
            if (this.isZero(operand)) {
                if (tokenType.equals(JavaTokenType.AND) || (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT)) && previousOperand == null) {
                    return PointlessBitwiseExpressionInspection.getText(expression, operands[0], operands[length - 1], PsiType.LONG.equals(expression.getType()) ? "0L" : "0");
                }
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.XOR) || (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT)) && previousOperand != null) {
                    return PointlessBitwiseExpressionInspection.getText(expression, i2 == length - 1 ? expression.getTokenBeforeOperand(operand) : operand);
                }
            } else if (this.isAllOnes(operand)) {
                if (tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression, i2 == length - 1 ? expression.getTokenBeforeOperand(operand) : operand);
                }
                if (tokenType.equals(JavaTokenType.OR)) {
                    return operand.getText();
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    if (previousOperand != null) {
                        return PointlessBitwiseExpressionInspection.getText(expression, previousOperand, operand, "~" + previousOperand.getText());
                    }
                    PsiExpression nextOperand = operands[i2 + 1];
                    return PointlessBitwiseExpressionInspection.getText(expression, operand, nextOperand, "~" + nextOperand.getText());
                }
            } else if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(previousOperand, operand)) {
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression, previousOperand, operand, operand.getText());
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    return PointlessBitwiseExpressionInspection.getText(expression, previousOperand, operand, PsiType.LONG.equals(expression.getType()) ? "0L" : "0");
                }
            }
            previousOperand = operand;
        }
        return "";
    }

    public static String getText(PsiPolyadicExpression expression, PsiElement fromTarget, PsiElement untilTarget, @NotNull @NonNls String replacement) {
        if (replacement == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        boolean stop = false;
        for (PsiElement child : expression.getChildren()) {
            if (child == fromTarget) {
                stop = true;
                result.append(replacement);
                continue;
            }
            if (child == untilTarget) {
                stop = false;
                continue;
            }
            if (child instanceof PsiComment || !stop) {
                result.append(child.getText());
                continue;
            }
            if (!(child instanceof PsiJavaToken) || untilTarget != null) continue;
            stop = false;
        }
        return result.toString();
    }

    private static String getText(PsiPolyadicExpression expression, PsiElement exclude) {
        return PointlessBitwiseExpressionInspection.getText(expression, exclude, null, "").trim();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessBitwiseFix();
    }

    private boolean isZero(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression);
    }

    private boolean isAllOnes(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiType expressionType = expression.getType();
        Object value = ConstantExpressionUtil.computeCastTo(expression, expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Integer && (Integer)value == -1) {
            return true;
        }
        if (value instanceof Long && (Long)value == -1L) {
            return true;
        }
        if (value instanceof Short && (Short)value == -1) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\uffff') {
            return true;
        }
        return value instanceof Byte && (Byte)value == -1;
    }

    static {
        bitwiseTokens.add(JavaTokenType.AND);
        bitwiseTokens.add(JavaTokenType.OR);
        bitwiseTokens.add(JavaTokenType.XOR);
        bitwiseTokens.add(JavaTokenType.LTLT);
        bitwiseTokens.add(JavaTokenType.GTGT);
        bitwiseTokens.add(JavaTokenType.GTGTGT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private PointlessBitwiseVisitor() {
        }

        @Override
        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            PsiExpression[] operands;
            if (expression == null) {
                PointlessBitwiseVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType sign = expression.getOperationTokenType();
            if (!bitwiseTokens.contains(sign)) {
                return;
            }
            if (PsiUtilCore.hasErrorElementChild(expression)) {
                return;
            }
            for (PsiExpression operand : operands = expression.getOperands()) {
                if (operand == null) {
                    return;
                }
                PsiType type = operand.getType();
                if (type != null && !type.equals(PsiType.BOOLEAN) && !type.equalsToText("java.lang.Boolean")) continue;
                return;
            }
            boolean isPointless = sign.equals(JavaTokenType.AND) || sign.equals(JavaTokenType.OR) || sign.equals(JavaTokenType.XOR) ? this.booleanExpressionIsPointless(operands) : (sign.equals(JavaTokenType.LTLT) || sign.equals(JavaTokenType.GTGT) || sign.equals(JavaTokenType.GTGTGT) ? this.shiftExpressionIsPointless(operands) : false);
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean booleanExpressionIsPointless(PsiExpression[] operands) {
            PsiExpression previousExpression = null;
            for (PsiExpression operand : operands) {
                if (PointlessBitwiseExpressionInspection.this.isZero(operand) || PointlessBitwiseExpressionInspection.this.isAllOnes(operand) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(previousExpression, operand) && !SideEffectChecker.mayHaveSideEffects(operand)) {
                    return true;
                }
                previousExpression = operand;
            }
            return false;
        }

        private boolean shiftExpressionIsPointless(PsiExpression[] operands) {
            for (PsiExpression operand : operands) {
                if (!PointlessBitwiseExpressionInspection.this.isZero(operand)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseVisitor", "visitPolyadicExpression"));
        }
    }

    private class PointlessBitwiseFix
    extends InspectionGadgetsFix {
        private PointlessBitwiseFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessBitwiseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiPolyadicExpression expression = (PsiPolyadicExpression)descriptor.getPsiElement();
            String newExpression = PointlessBitwiseExpressionInspection.this.calculateReplacementExpression(expression);
            PsiReplacementUtil.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix", "getFamilyName"));
        }
    }
}

