/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class OverlyComplexBooleanExpressionInspectionBase
extends BaseInspection {
    protected static final Set<IElementType> s_booleanOperators = new HashSet<IElementType>(5);
    public int m_limit = 3;
    public boolean m_ignorePureConjunctionsDisjunctions = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.complex.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            OverlyComplexBooleanExpressionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer termCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("overly.complex.boolean.expression.problem.descriptor", termCount);
        if (string == null) {
            OverlyComplexBooleanExpressionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        CheckBox ignoreConjunctionsDisjunctionsCheckBox = new CheckBox(InspectionGadgetsBundle.message("overly.complex.boolean.expression.ignore.option", new Object[0]), this, "m_ignorePureConjunctionsDisjunctions");
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        JFormattedTextField termLimitTextField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = new JLabel(InspectionGadgetsBundle.message("overly.complex.boolean.expression.max.terms.option", new Object[0]));
        constraints.anchor = 512;
        constraints.fill = 2;
        panel.add((Component)label, constraints);
        constraints.fill = 0;
        constraints.gridx = 1;
        panel.add((Component)termLimitTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)ignoreConjunctionsDisjunctionsCheckBox, constraints);
        return panel;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyComplexBooleanExpressionVisitor();
    }

    static {
        s_booleanOperators.add(JavaTokenType.ANDAND);
        s_booleanOperators.add(JavaTokenType.OROR);
        s_booleanOperators.add(JavaTokenType.XOR);
        s_booleanOperators.add(JavaTokenType.AND);
        s_booleanOperators.add(JavaTokenType.OR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OverlyComplexBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private OverlyComplexBooleanExpressionVisitor() {
        }

        @Override
        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                OverlyComplexBooleanExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                OverlyComplexBooleanExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitPrefixExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            if (expression == null) {
                OverlyComplexBooleanExpressionVisitor.$$$reportNull$$$0(2);
            }
            super.visitParenthesizedExpression(expression);
            this.checkExpression(expression);
        }

        private void checkExpression(PsiExpression expression) {
            if (!this.isBoolean(expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpression && this.isBoolean((PsiExpression)parent)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= OverlyComplexBooleanExpressionInspectionBase.this.m_limit) {
                return;
            }
            if (OverlyComplexBooleanExpressionInspectionBase.this.m_ignorePureConjunctionsDisjunctions && this.isPureConjunctionDisjunction(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, numTerms);
        }

        private int countTerms(PsiExpression expression) {
            if (!this.isBoolean(expression)) {
                return 1;
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = polyadicExpression.getOperands();
                return Arrays.stream(operands).mapToInt(this::countTerms).sum();
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                return this.countTerms(prefixExpression.getOperand());
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return this.countTerms(parenthesizedExpression.getExpression());
            }
            return 1;
        }

        private boolean isBoolean(PsiExpression expression) {
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                return s_booleanOperators.contains(polyadicExpression.getOperationTokenType());
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                return JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType());
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return this.isBoolean(parenthesizedExpression.getExpression());
            }
            return false;
        }

        private boolean isPureConjunctionDisjunction(PsiExpression expression) {
            PsiExpression[] operands;
            if (!(expression instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            IElementType sign = polyadicExpression.getOperationTokenType();
            if (!s_booleanOperators.contains(sign)) {
                return false;
            }
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (operand instanceof PsiReferenceExpression || operand instanceof PsiMethodCallExpression || operand instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/controlflow/OverlyComplexBooleanExpressionInspectionBase$OverlyComplexBooleanExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

