/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementDensityInspection
extends BaseInspection {
    private static final int DEFAULT_DENSITY_LIMIT = 20;
    public int m_limit = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.density.display.name", new Object[0]);
        if (string == null) {
            SwitchStatementDensityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.density.min.option", new Object[0]), this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer intDensity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("switch.statement.density.problem.descriptor", intDensity);
        if (string == null) {
            SwitchStatementDensityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementDensityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementDensityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StatementCountVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int statementCount;

        private StatementCountVisitor() {
        }

        @Override
        public void visitStatement(@NotNull PsiStatement statement) {
            if (statement == null) {
                StatementCountVisitor.$$$reportNull$$$0(0);
            }
            super.visitStatement(statement);
            if (statement instanceof PsiSwitchLabelStatement || statement instanceof PsiBreakStatement) {
                return;
            }
            ++this.statementCount;
        }

        int getStatementCount() {
            return this.statementCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$StatementCountVisitor", "visitStatement"));
        }
    }

    private class SwitchStatementDensityVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementDensityVisitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            PsiCodeBlock body;
            if (statement == null) {
                SwitchStatementDensityVisitor.$$$reportNull$$$0(0);
            }
            if ((body = statement.getBody()) == null) {
                return;
            }
            int branchCount = SwitchUtils.calculateBranchCount(statement);
            if (branchCount == 0) {
                return;
            }
            double density = this.calculateDensity(body, branchCount);
            int intDensity = (int)(density * 100.0);
            if (intDensity > SwitchStatementDensityInspection.this.m_limit) {
                return;
            }
            this.registerStatementError(statement, intDensity);
        }

        private double calculateDensity(@NotNull PsiCodeBlock body, int branchCount) {
            if (body == null) {
                SwitchStatementDensityVisitor.$$$reportNull$$$0(1);
            }
            StatementCountVisitor visitor = new StatementCountVisitor();
            body.accept(visitor);
            return (double)branchCount / (double)visitor.getStatementCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$SwitchStatementDensityVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateDensity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

