/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

class MethodReferenceVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean m_referencesStaticallyAccessible = true;
    private final PsiMember m_method;

    MethodReferenceVisitor(PsiMember method) {
        this.m_method = method;
    }

    public boolean areReferencesStaticallyAccessible() {
        return this.m_referencesStaticallyAccessible;
    }

    @Override
    public void visitElement(PsiElement element) {
        if (!this.m_referencesStaticallyAccessible) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        PsiElement resolvedElement = reference.resolve();
        if (!(resolvedElement instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)resolvedElement;
        PsiElement scope = aClass.getScope();
        if (!(scope instanceof PsiClass)) {
            return;
        }
        if (aClass.hasModifierProperty("static")) {
            return;
        }
        this.m_referencesStaticallyAccessible = false;
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        PsiMember member;
        if (expression == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(0);
        }
        super.visitReferenceExpression(expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return;
        }
        PsiElement element = expression.resolve();
        if (element instanceof PsiMember ? this.isMemberStaticallyAccessible(member = (PsiMember)element) : element != null) {
            return;
        }
        this.m_referencesStaticallyAccessible = false;
    }

    @Override
    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(1);
        }
        super.visitThisExpression(expression);
        this.m_referencesStaticallyAccessible = false;
    }

    private boolean isMemberStaticallyAccessible(PsiMember member) {
        PsiClass containingClass;
        if (this.m_method.equals(member)) {
            return true;
        }
        if (member.hasModifierProperty("static")) {
            return true;
        }
        PsiClass referenceContainingClass = this.m_method.getContainingClass();
        return !InheritanceUtil.isInheritorOrSelf(referenceContainingClass, containingClass = member.getContainingClass(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/siyeh/ig/performance/MethodReferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThisExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

