/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InnerClassVariableHidesOuterClassVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @Override
    @NotNull
    public String getID() {
        if ("InnerClassFieldHidesOuterClassField" == null) {
            InnerClassVariableHidesOuterClassVariableInspectionBase.$$$reportNull$$$0(0);
        }
        return "InnerClassFieldHidesOuterClassField";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.field.hides.outer.display.name", new Object[0]);
        if (string == null) {
            InnerClassVariableHidesOuterClassVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inner.class.field.hides.outer.problem.descriptor", new Object[0]);
        if (string == null) {
            InnerClassVariableHidesOuterClassVariableInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inner.class.field.hides.outer.ignore.option", new Object[0]), this, "m_ignoreInvisibleFields");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassVariableHidesOuterClassVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InnerClassVariableHidesOuterClassVariableVisitor
    extends BaseInspectionVisitor {
        private InnerClassVariableHidesOuterClassVariableVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            PsiClass aClass;
            if (field == null) {
                InnerClassVariableHidesOuterClassVariableVisitor.$$$reportNull$$$0(0);
            }
            if ((aClass = field.getContainingClass()) == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            boolean reportStaticsOnly = aClass.hasModifierProperty("static");
            PsiClass ancestorClass = ClassUtils.getContainingClass(aClass);
            while (ancestorClass != null) {
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (!(ancestorField == null || InnerClassVariableHidesOuterClassVariableInspectionBase.this.m_ignoreInvisibleFields && reportStaticsOnly && !ancestorField.hasModifierProperty("static"))) {
                    this.registerFieldError(field, new Object[0]);
                }
                if (ancestorClass.hasModifierProperty("static")) {
                    reportStaticsOnly = true;
                }
                ancestorClass = ClassUtils.getContainingClass(ancestorClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspectionBase$InnerClassVariableHidesOuterClassVariableVisitor", "visitField"));
        }
    }
}

