/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFilePointerContainerImpl
extends TraceableDisposable
implements VirtualFilePointerContainer,
Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer");
    @NotNull
    private final List<VirtualFilePointer> myList;
    @NotNull
    private final VirtualFilePointerManager myVirtualFilePointerManager;
    @NotNull
    private final Disposable myParent;
    private final VirtualFilePointerListener myListener;
    private volatile Trinity<String[], VirtualFile[], VirtualFile[]> myCachedThings;
    private volatile long myTimeStampOfCachedThings;
    @NonNls
    private static final String URL_ATTR = "url";
    private boolean myDisposed;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    private static final Trinity<String[], VirtualFile[], VirtualFile[]> EMPTY = Trinity.create(ArrayUtil.EMPTY_STRING_ARRAY, VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY);

    VirtualFilePointerContainerImpl(@NotNull VirtualFilePointerManager manager, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener) {
        if (manager == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(1);
        }
        super(TRACE_CREATION && !ApplicationInfoImpl.isInStressTest());
        this.myList = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTimeStampOfCachedThings = -1L;
        this.myVirtualFilePointerManager = manager;
        this.myParent = parentDisposable;
        this.myListener = listener;
    }

    @Override
    public void readExternal(@NotNull Element rootChild, @NotNull String childElements) throws InvalidDataException {
        if (rootChild == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(2);
        }
        if (childElements == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(3);
        }
        List urls = rootChild.getChildren(childElements);
        for (Element url : urls) {
            String urlAttribute = url.getAttributeValue(URL_ATTR);
            if (urlAttribute == null) {
                throw new InvalidDataException("path element without url");
            }
            this.add(urlAttribute);
        }
    }

    @Override
    public void writeExternal(@NotNull Element element, @NotNull String childElementName) {
        if (element == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(4);
        }
        if (childElementName == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(5);
        }
        for (VirtualFilePointer pointer : this.myList) {
            String url = pointer.getUrl();
            Element rootPathElement = new Element(childElementName);
            rootPathElement.setAttribute(URL_ATTR, url);
            element.addContent(rootPathElement);
        }
    }

    @Override
    public void moveUp(@NotNull String url) {
        int index;
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(6);
        }
        if ((index = this.indexOf(url)) <= 0) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, index - 1, index);
    }

    @Override
    public void moveDown(@NotNull String url) {
        int index;
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(7);
        }
        if ((index = this.indexOf(url)) < 0 || index + 1 >= this.myList.size()) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, index, index + 1);
    }

    private int indexOf(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < this.myList.size(); ++i) {
            VirtualFilePointer pointer = this.myList.get(i);
            if (!url.equals(pointer.getUrl())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void killAll() {
        this.myList.clear();
    }

    @Override
    public void add(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(9);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(file);
        this.myList.add(pointer);
    }

    @Override
    public void add(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(10);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(url);
        this.myList.add(pointer);
    }

    @Override
    public void remove(@NotNull VirtualFilePointer pointer) {
        if (pointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(11);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        boolean result = this.myList.remove(pointer);
        LOG.assertTrue(result);
    }

    @Override
    @NotNull
    public List<VirtualFilePointer> getList() {
        assert (!this.myDisposed);
        List<VirtualFilePointer> list = Collections.unmodifiableList(this.myList);
        if (list == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public void addAll(@NotNull VirtualFilePointerContainer that) {
        if (that == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(13);
        }
        assert (!this.myDisposed);
        this.dropCaches();
        for (VirtualFilePointer pointer : that.getList()) {
            this.myList.add(this.duplicate(pointer));
        }
    }

    private void dropCaches() {
        this.myTimeStampOfCachedThings = -1L;
        this.myCachedThings = EMPTY;
    }

    @Override
    @NotNull
    public String[] getUrls() {
        String[] stringArray = (String[])this.getOrCache().first;
        if (stringArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> getOrCache() {
        assert (!this.myDisposed);
        long timeStamp = this.myTimeStampOfCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> cached = this.myCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> trinity = timeStamp == this.myVirtualFilePointerManager.getModificationCount() ? cached : this.cacheThings();
        if (trinity == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(15);
        }
        return trinity;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> cacheThings() {
        Trinity<String[], VirtualFile[], VirtualFile[]> result;
        if (this.myList.isEmpty()) {
            result = EMPTY;
        } else {
            ArrayList<VirtualFile> cachedFiles = new ArrayList<VirtualFile>(this.myList.size());
            ArrayList<String> cachedUrls = new ArrayList<String>(this.myList.size());
            ArrayList<VirtualFile> cachedDirectories = new ArrayList<VirtualFile>(this.myList.size() / 3);
            boolean allFilesAreDirs = true;
            for (VirtualFilePointer v : this.myList) {
                VirtualFile file = v.getFile();
                String url = v.getUrl();
                cachedUrls.add(url);
                if (file == null) continue;
                cachedFiles.add(file);
                if (file.isDirectory()) {
                    cachedDirectories.add(file);
                    continue;
                }
                allFilesAreDirs = false;
            }
            VirtualFile[] directories = VfsUtilCore.toVirtualFileArray(cachedDirectories);
            VirtualFile[] files = allFilesAreDirs ? directories : VfsUtilCore.toVirtualFileArray(cachedFiles);
            String[] urlsArray = ArrayUtil.toStringArray(cachedUrls);
            result = Trinity.create(urlsArray, files, directories);
        }
        this.myCachedThings = result;
        this.myTimeStampOfCachedThings = this.myVirtualFilePointerManager.getModificationCount();
        Trinity<String[], VirtualFile[], VirtualFile[]> trinity = result;
        if (trinity == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(16);
        }
        return trinity;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().second;
        if (virtualFileArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(17);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getDirectories() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().third;
        if (virtualFileArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(18);
        }
        return virtualFileArray;
    }

    @Override
    @Nullable
    public VirtualFilePointer findByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(19);
        }
        assert (!this.myDisposed);
        for (VirtualFilePointer pointer : this.myList) {
            if (!url.equals(pointer.getUrl())) continue;
            return pointer;
        }
        return null;
    }

    @Override
    public void clear() {
        this.dropCaches();
        this.killAll();
    }

    @Override
    public int size() {
        return this.myList.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFilePointerContainerImpl)) {
            return false;
        }
        VirtualFilePointerContainerImpl virtualFilePointerContainer = (VirtualFilePointerContainerImpl)o;
        return this.myList.equals(virtualFilePointerContainer.myList);
    }

    public int hashCode() {
        return this.myList.hashCode();
    }

    @NotNull
    protected VirtualFilePointer create(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(20);
        }
        VirtualFilePointer virtualFilePointer = this.myVirtualFilePointerManager.create(file, this.myParent, this.myListener);
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(21);
        }
        return virtualFilePointer;
    }

    @NotNull
    protected VirtualFilePointer create(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(22);
        }
        VirtualFilePointer virtualFilePointer = this.myVirtualFilePointerManager.create(url, this.myParent, this.myListener);
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(23);
        }
        return virtualFilePointer;
    }

    @NotNull
    protected VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(24);
        }
        VirtualFilePointer virtualFilePointer2 = this.myVirtualFilePointerManager.duplicate(virtualFilePointer, this.myParent, this.myListener);
        if (virtualFilePointer2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(25);
        }
        return virtualFilePointer2;
    }

    @NotNull
    @NonNls
    public String toString() {
        String string = "VFPContainer: " + this.myList;
        if (string == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent) {
        if (parent == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(27);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.clone(parent, null);
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(28);
        }
        return virtualFilePointerContainer;
    }

    @Override
    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (parent == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(29);
        }
        assert (!this.myDisposed);
        VirtualFilePointerContainer clone = this.myVirtualFilePointerManager.createContainer(parent, listener);
        for (VirtualFilePointer pointer : this.myList) {
            clone.add(pointer.getUrl());
        }
        VirtualFilePointerContainer virtualFilePointerContainer = clone;
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(30);
        }
        return virtualFilePointerContainer;
    }

    @Override
    public void dispose() {
        assert (!this.myDisposed);
        this.myDisposed = true;
        this.kill(null);
        this.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChild";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElementName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTR;
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFilePointer";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCache";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheThings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "duplicate";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findByUrl";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "duplicate";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

