/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VFileMoveEvent(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) {
        if (file == null) {
            VFileMoveEvent.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            VFileMoveEvent.$$$reportNull$$$0(1);
        }
        super(requestor, false);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myOldParent = file.getParent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            VFileMoveEvent.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile = this.myNewParent;
        if (virtualFile == null) {
            VFileMoveEvent.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.computePath();
        if (string == null) {
            VFileMoveEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected String computePath() {
        String string = this.myFile.getPath();
        if (string == null) {
            VFileMoveEvent.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFileMoveEvent.$$$reportNull$$$0(6);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && Comparing.equal(this.myFile.getParent(), this.myOldParent) && this.myOldParent.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myOldParent.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        return result;
    }

    public String getOldPath() {
        return this.myOldParent.getPath() + "/" + this.myFile.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

