/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeArgumentsFix
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(ChangeTypeArgumentsFix.class);
    private final PsiMethod myTargetMethod;
    private final PsiClass myPsiClass;
    private final PsiExpression[] myExpressions;
    private final PsiNewExpression myNewExpression;

    ChangeTypeArgumentsFix(@NotNull PsiMethod targetMethod, PsiClass psiClass, @NotNull PsiExpression[] expressions, @NotNull PsiElement context) {
        if (targetMethod == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(0);
        }
        if (expressions == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(2);
        }
        this.myTargetMethod = targetMethod;
        this.myPsiClass = psiClass;
        this.myExpressions = expressions;
        this.myNewExpression = PsiTreeUtil.getParentOfType(context, PsiNewExpression.class);
    }

    @Override
    @NotNull
    public String getText() {
        PsiSubstitutor substitutor = this.inferTypeArguments();
        String string = "Change type arguments to <" + StringUtil.join(this.myPsiClass.getTypeParameters(), typeParameter -> {
            PsiType substituted = substitutor.substitute((PsiTypeParameter)typeParameter);
            return substituted != null ? substituted.getPresentableText() : "java.lang.Object";
        }, ", ") + ">";
        if (string == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Change type arguments" == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(4);
        }
        return "Change type arguments";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement reference;
        if (project == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(5);
        }
        if (!this.myPsiClass.isValid() || !this.myTargetMethod.isValid()) {
            return false;
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        if (typeParameters.length > 0 && this.myNewExpression != null && this.myNewExpression.isValid() && this.myNewExpression.getArgumentList() != null && (reference = this.myNewExpression.getClassOrAnonymousClassReference()) != null && (parameterList = reference.getParameterList()) != null) {
            PsiSubstitutor substitutor = this.inferTypeArguments();
            PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
            if (parameters.length != this.myExpressions.length) {
                return false;
            }
            int length = parameters.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiParameter parameter = parameters[i2];
                PsiType expectedType = substitutor.substitute(parameter.getType());
                if (!this.myExpressions[i2].isValid()) {
                    return false;
                }
                PsiType actualType = this.myExpressions[i2].getType();
                if (expectedType != null && actualType != null && TypeConversionUtil.isAssignable(expectedType, actualType)) continue;
                return false;
            }
            for (PsiTypeParameter parameter : typeParameters) {
                if (substitutor.substitute(parameter) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(6);
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments();
        PsiJavaCodeReferenceElement reference = this.myNewExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(reference != null, this.myNewExpression);
        PsiReferenceParameterList parameterList = reference.getParameterList();
        LOG.assertTrue(parameterList != null, this.myNewExpression);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        for (int i2 = elements.length - 1; i2 >= 0; --i2) {
            PsiType typeArg = ObjectUtils.assertNotNull(psiSubstitutor.substitute(typeParameters[i2]));
            PsiElement replaced = elements[i2].replace(factory.createTypeElement(typeArg));
            JavaCodeStyleManager.getInstance(file.getProject()).shortenClassReferences(replaced);
        }
    }

    private PsiSubstitutor inferTypeArguments() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.myNewExpression.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
        LOG.assertTrue(argumentList != null);
        PsiExpression[] expressions = argumentList.getExpressions();
        return resolveHelper.inferTypeArguments(this.myPsiClass.getTypeParameters(), parameters, expressions, PsiSubstitutor.EMPTY, this.myNewExpression.getParent(), DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, PsiClass psiClass) {
        if (candidates == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(7);
        }
        if (list == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(8);
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ChangeTypeArgumentsFix.registerIntention(expressions, highlightInfo, psiClass, candidate, list);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions, @Nullable HighlightInfo highlightInfo, PsiClass psiClass, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (expressions == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(9);
        }
        if (candidate == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(11);
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        if (method != null && context.getManager().isInProject(method)) {
            ChangeTypeArgumentsFix fix = new ChangeTypeArgumentsFix(method, psiClass, expressions, context);
            QuickFixAction.registerQuickFixAction(highlightInfo, null, fix);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

