/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

interface CombinedData {
    public static final BasicValue ThisValue = new BasicValue(Type.getObjectType((String)"java/lang/Object"));

    public static final class TrackableValue
    extends BasicValue
    implements Trackable {
        private final int originInsnIndex;

        public TrackableValue(int originInsnIndex, Type type) {
            super(type);
            this.originInsnIndex = originInsnIndex;
        }

        @Override
        public int getOriginInsnIndex() {
            return this.originInsnIndex;
        }
    }

    public static final class TrackableNullValue
    extends BasicValue
    implements Trackable {
        static final Type NullType = Type.getObjectType((String)"null");
        private final int originInsnIndex;

        public TrackableNullValue(int originInsnIndex) {
            super(NullType);
            this.originInsnIndex = originInsnIndex;
        }

        @Override
        public int getOriginInsnIndex() {
            return this.originInsnIndex;
        }
    }

    public static final class TrackableCallValue
    extends BasicValue
    implements Trackable {
        private final int originInsnIndex;
        final Method method;
        final List<? extends BasicValue> args;
        final boolean stableCall;
        final boolean thisCall;

        TrackableCallValue(int originInsnIndex, Type tp, Method method, List<? extends BasicValue> args, boolean stableCall, boolean thisCall) {
            super(tp);
            this.originInsnIndex = originInsnIndex;
            this.method = method;
            this.args = args;
            this.stableCall = stableCall;
            this.thisCall = thisCall;
        }

        @Override
        public int getOriginInsnIndex() {
            return this.originInsnIndex;
        }

        @NotNull
        Set<EKey> getKeysForParameter(int idx, Direction.ParamValueBasedDirection direction) {
            HashSet<EKey> keys = new HashSet<EKey>();
            for (int argI = 0; argI < this.args.size(); ++argI) {
                BasicValue arg = this.args.get(argI);
                if (!(arg instanceof AbstractValues.NthParamValue)) continue;
                AbstractValues.NthParamValue npv = (AbstractValues.NthParamValue)arg;
                if (npv.n != idx) continue;
                keys.add(new EKey(this.method, direction.withIndex(argI), this.stableCall));
            }
            HashSet<EKey> hashSet = keys;
            if (hashSet == null) {
                TrackableCallValue.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/CombinedData$TrackableCallValue", "getKeysForParameter"));
        }
    }

    public static interface Trackable {
        public int getOriginInsnIndex();
    }

    public static final class ParamKey {
        final Method method;
        final int i;
        final boolean stable;

        ParamKey(Method method, int i2, boolean stable) {
            this.method = method;
            this.i = i2;
            this.stable = stable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamKey paramKey = (ParamKey)o;
            if (this.i != paramKey.i) {
                return false;
            }
            if (this.stable != paramKey.stable) {
                return false;
            }
            return this.method.equals(paramKey.method);
        }

        public int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + this.i;
            result = 31 * result + (this.stable ? 1 : 0);
            return result;
        }
    }
}

