/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.ReturnTransfer;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.inliner.CollectionFactoryInliner;
import com.intellij.codeInspection.dataFlow.inliner.LambdaInliner;
import com.intellij.codeInspection.dataFlow.inliner.OptionalChainInliner;
import com.intellij.codeInspection.dataFlow.inliner.StreamChainInliner;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyStackInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.numeric.UnnecessaryExplicitNumericCastInspection;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer");
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();
    static final String METHOD_REFERENCE_QUALIFIER_SYNTHETIC_FIELD = "Method reference qualifier";
    private final PsiElement myCodeFragment;
    private final boolean myIgnoreAssertions;
    private final boolean myInlining;
    private final Project myProject;
    private final DfaValueFactory myFactory;
    private ControlFlow myCurrentFlow;
    private FList<Trap> myTrapStack;
    private final ExceptionTransfer myRuntimeException;
    private final ExceptionTransfer myError;
    private final PsiType myAssertionError;
    private InlinedBlockContext myInlinedBlockContext;
    static final CallInliner[] INLINERS = new CallInliner[]{new OptionalChainInliner(), new LambdaInliner(), new CollectionFactoryInliner(), new StreamChainInliner()};

    ControlFlowAnalyzer(DfaValueFactory valueFactory, @NotNull PsiElement codeFragment, boolean ignoreAssertions, boolean inlining) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        this.myTrapStack = FList.emptyList();
        this.myInlining = inlining;
        this.myFactory = valueFactory;
        this.myCodeFragment = codeFragment;
        this.myProject = codeFragment.getProject();
        this.myIgnoreAssertions = ignoreAssertions;
        GlobalSearchScope scope = codeFragment.getResolveScope();
        this.myRuntimeException = new ExceptionTransfer(this.myFactory.createTypeValue(this.createClassType(scope, "java.lang.RuntimeException"), Nullness.NOT_NULL));
        this.myError = new ExceptionTransfer(this.myFactory.createTypeValue(this.createClassType(scope, "java.lang.Error"), Nullness.NOT_NULL));
        this.myAssertionError = this.createClassType(scope, "java.lang.AssertionError");
    }

    private void buildClassInitializerFlow(PsiClass psiClass, boolean isStatic) {
        this.pushUnknown();
        ConditionalGotoInstruction conditionalGoto = new ConditionalGotoInstruction(null, false, null);
        this.addInstruction(conditionalGoto);
        for (PsiElement element : psiClass.getChildren()) {
            if (!(element instanceof PsiField) && !(element instanceof PsiClassInitializer) || ((PsiModifierListOwner)element).hasModifier(JvmModifier.STATIC) != isStatic) continue;
            element.accept(this);
        }
        this.addInstruction(new FlushVariableInstruction(null));
        conditionalGoto.setOffset(this.getInstructionCount());
    }

    @Nullable
    public ControlFlow buildControlFlow() {
        this.myCurrentFlow = new ControlFlow(this.myFactory);
        try {
            if (this.myCodeFragment instanceof PsiClass) {
                this.buildClassInitializerFlow((PsiClass)this.myCodeFragment, true);
                this.buildClassInitializerFlow((PsiClass)this.myCodeFragment, false);
            } else {
                this.myCodeFragment.accept(this);
            }
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        PsiElement parent = this.myCodeFragment.getParent();
        if (parent instanceof PsiLambdaExpression && this.myCodeFragment instanceof PsiExpression) {
            this.generateBoxingUnboxingInstructionFor((PsiExpression)this.myCodeFragment, LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)parent));
            this.addInstruction(new CheckReturnValueInstruction(this.myCodeFragment));
        }
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, FList.emptyList()), null));
        if (Registry.is("idea.dfa.live.variables.analysis")) {
            new LiveVariablesAnalyzer(this.myCurrentFlow, this.myFactory).flushDeadVariablesOnStatementFinish();
        }
        return this.myCurrentFlow;
    }

    DfaValueFactory getFactory() {
        return this.myFactory;
    }

    PsiElement getContext() {
        return this.myCodeFragment;
    }

    private PsiClassType createClassType(GlobalSearchScope scope, String fqn) {
        PsiClass aClass = JavaPsiFacade.getInstance(this.myProject).findClass(fqn, scope);
        if (aClass != null) {
            return JavaPsiFacade.getElementFactory(this.myProject).createType(aClass);
        }
        return JavaPsiFacade.getElementFactory(this.myProject).createTypeByFQClassName(fqn, scope);
    }

    <T extends Instruction> T addInstruction(T i2) {
        this.myCurrentFlow.addInstruction(i2);
        return i2;
    }

    int getInstructionCount() {
        return this.myCurrentFlow.getInstructionCount();
    }

    private ControlFlow.ControlFlowOffset getEndOffset(PsiElement element) {
        return this.myCurrentFlow.getEndOffset(element);
    }

    private ControlFlow.ControlFlowOffset getStartOffset(PsiElement element) {
        return this.myCurrentFlow.getStartOffset(element);
    }

    private void startElement(PsiElement element) {
        this.myCurrentFlow.startElement(element);
    }

    private void finishElement(PsiElement element) {
        this.myCurrentFlow.finishElement(element);
        if (element instanceof PsiStatement && !(element instanceof PsiReturnStatement)) {
            this.addInstruction(new FinishElementInstruction(element));
        }
    }

    @Override
    public void visitErrorElement(PsiErrorElement element) {
        throw new CannotAnalyzeException();
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        PsiExpression lExpr = expression.getLExpression();
        PsiExpression rExpr = expression.getRExpression();
        this.startElement(expression);
        if (rExpr == null) {
            this.pushUnknown();
            this.finishElement(expression);
            return;
        }
        IElementType op = expression.getOperationTokenType();
        PsiType type = expression.getType();
        boolean isBoolean = PsiType.BOOLEAN.equals(type);
        if (op == JavaTokenType.EQ) {
            lExpr.accept(this);
            rExpr.accept(this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type);
        } else if (op == JavaTokenType.ANDEQ && isBoolean) {
            this.generateBooleanAssignmentExpression(true, lExpr, rExpr, type);
        } else if (op == JavaTokenType.OREQ && isBoolean) {
            this.generateBooleanAssignmentExpression(false, lExpr, rExpr, type);
        } else if (op == JavaTokenType.XOREQ && isBoolean) {
            this.generateXorExpression(expression, new PsiExpression[]{lExpr, rExpr}, type, true);
        } else if (op == JavaTokenType.PLUSEQ && type != null && type.equalsToText("java.lang.String")) {
            lExpr.accept(this);
            this.addInstruction(new DupInstruction());
            rExpr.accept(this);
            this.addInstruction(new BinopInstruction(JavaTokenType.PLUS, null, this.myProject));
        } else if (ControlFlowAnalyzer.isAssignmentDivision(op) && type != null && PsiType.LONG.isAssignableFrom(type)) {
            lExpr.accept(this);
            this.generateBoxingUnboxingInstructionFor(lExpr, type);
            rExpr.accept(this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type);
            this.checkZeroDivisor();
            this.addInstruction(new PopInstruction());
            this.pushUnknown();
        } else {
            this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
        }
        this.addInstruction(new AssignInstruction(rExpr, this.myFactory.createValue(lExpr)));
        this.flushArrayElementsOnUnknownIndexAssignment(lExpr);
        this.finishElement(expression);
    }

    private void flushArrayElementsOnUnknownIndexAssignment(PsiExpression lExpr) {
        DfaValue arrayVar;
        if (lExpr instanceof PsiArrayAccessExpression && !(this.myFactory.createValue(lExpr) instanceof DfaVariableValue) && (arrayVar = this.myFactory.createValue(((PsiArrayAccessExpression)lExpr).getArrayExpression())) instanceof DfaVariableValue) {
            this.addInstruction(new FlushVariableInstruction((DfaVariableValue)arrayVar, true));
        }
    }

    private void generateDefaultAssignmentBinOp(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept(this);
        this.addInstruction(new DupInstruction());
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        rExpr.accept(this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        this.addInstruction(new BinopInstruction(null, null, this.myProject));
    }

    @Override
    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myIgnoreAssertions) {
            return;
        }
        this.startElement(statement);
        PsiExpression condition = statement.getAssertCondition();
        PsiExpression description = statement.getAssertDescription();
        if (condition != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), false, condition));
            if (description != null) {
                description.accept(this);
            }
            this.throwException(this.myAssertionError, (PsiElement)statement);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement(statement);
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                this.addInstruction(new EmptyInstruction(element));
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.initializeVariable(field, initializer);
        } else if (!field.hasModifier(JvmModifier.FINAL)) {
            DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(field, false);
            this.addInstruction(new PushInstruction(dfaVariable, null, true));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(PsiTypesUtil.getDefaultValue(field.getType()), field.getType(), null), null));
            this.addInstruction(new AssignInstruction(null, dfaVariable));
            this.addInstruction(new PopInstruction());
        }
    }

    @Override
    public void visitClassInitializer(PsiClassInitializer initializer) {
        this.visitCodeBlock(initializer.getBody());
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(variable, false);
        this.addInstruction(new PushInstruction(dfaVariable, initializer, true));
        initializer.accept(this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction(new AssignInstruction(initializer, dfaVariable));
        this.addInstruction(new PopInstruction());
    }

    @Override
    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiExpression expression;
        this.startElement(codeFragment);
        if (codeFragment instanceof PsiExpressionCodeFragment && (expression = ((PsiExpressionCodeFragment)codeFragment).getExpression()) != null) {
            expression.accept(this);
        }
        this.finishElement(codeFragment);
    }

    @Override
    public void visitCodeBlock(PsiCodeBlock block) {
        this.startElement(block);
        for (PsiStatement statement : block.getStatements()) {
            statement.accept(this);
        }
        this.flushCodeBlockVariables(block);
        this.finishElement(block);
    }

    private void flushCodeBlockVariables(PsiCodeBlock block) {
        block6: {
            PsiResourceList list;
            PsiElement parent;
            block8: {
                block7: {
                    block5: {
                        for (PsiStatement statement : block.getStatements()) {
                            if (!(statement instanceof PsiDeclarationStatement)) continue;
                            for (PsiElement declaration : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                                if (!(declaration instanceof PsiVariable)) continue;
                                this.myCurrentFlow.removeVariable((PsiVariable)declaration);
                            }
                        }
                        parent = block.getParent();
                        if (!(parent instanceof PsiCatchSection)) break block5;
                        this.myCurrentFlow.removeVariable(((PsiCatchSection)parent).getParameter());
                        break block6;
                    }
                    if (!(parent instanceof PsiForeachStatement)) break block7;
                    this.myCurrentFlow.removeVariable(((PsiForeachStatement)parent).getIterationParameter());
                    break block6;
                }
                if (!(parent instanceof PsiForStatement)) break block8;
                PsiStatement statement = ((PsiForStatement)parent).getInitialization();
                if (!(statement instanceof PsiDeclarationStatement)) break block6;
                for (PsiElement declaration : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                    if (!(declaration instanceof PsiVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)declaration);
                }
                break block6;
            }
            if (parent instanceof PsiTryStatement && (list = ((PsiTryStatement)parent).getResourceList()) != null) {
                for (PsiResourceListElement resource : list) {
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)((Object)resource));
                }
            }
        }
    }

    @Override
    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement(statement);
        statement.getCodeBlock().accept(this);
        this.finishElement(statement);
    }

    @Override
    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement(statement);
        PsiStatement exitedStatement = statement.findExitedStatement();
        if (exitedStatement != null) {
            this.controlTransfer(new InstructionTransfer(this.getEndOffset(exitedStatement), this.getVariablesInside(exitedStatement)), this.getTrapsInsideStatement(exitedStatement));
        }
        this.finishElement(statement);
    }

    private void controlTransfer(InstructionTransfer target, FList<Trap> traps) {
        this.addInstruction(new ControlTransferInstruction(this.myFactory.controlTransfer(target, traps)));
    }

    @NotNull
    private FList<Trap> getTrapsInsideStatement(PsiStatement statement) {
        FList<Trap> fList = FList.createFromReversed(ContainerUtil.reverse(ContainerUtil.findAll(this.myTrapStack, cd -> PsiTreeUtil.isAncestor(statement, cd.getAnchor(), true))));
        if (fList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        return fList;
    }

    @NotNull
    private List<DfaVariableValue> getVariablesInside(PsiElement exitedStatement) {
        List<DfaVariableValue> list = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(exitedStatement, PsiVariable.class), var -> this.myFactory.getVarFactory().createVariableValue((PsiVariable)var, false));
        if (list == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement(statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement instanceof PsiLoopStatement) {
            PsiStatement body = ((PsiLoopStatement)continuedStatement).getBody();
            this.controlTransfer(new InstructionTransfer(this.getEndOffset(body), this.getVariablesInside(body)), this.getTrapsInsideStatement(body));
        } else {
            this.addInstruction(new EmptyInstruction(null));
        }
        this.finishElement(statement);
    }

    @Override
    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        this.startElement(statement);
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
            PsiExpression condition = statement.getCondition();
            if (condition != null) {
                condition.accept(this);
                this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
                this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset(statement), false, condition));
            }
        }
        this.finishElement(statement);
    }

    @Override
    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement(statement);
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement(statement);
        PsiExpression expr = statement.getExpression();
        expr.accept(this);
        this.addInstruction(new PopInstruction());
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions;
        this.startElement(statement);
        for (PsiExpression expr : expressions = statement.getExpressionList().getExpressions()) {
            expr.accept(this);
            this.addInstruction(new PopInstruction());
        }
        this.finishElement(statement);
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement) {
        PsiStatement body;
        this.startElement(statement);
        PsiParameter parameter = statement.getIterationParameter();
        PsiExpression iteratedValue = statement.getIteratedValue();
        ControlFlow.ControlFlowOffset loopEndOffset = this.getEndOffset(statement);
        boolean hasSizeCheck = false;
        if (iteratedValue != null) {
            iteratedValue.accept(this);
            this.addInstruction(new FieldReferenceInstruction(iteratedValue, "Collection iterator or array.length"));
            DfaValue qualifier = this.myFactory.createValue(iteratedValue);
            if (qualifier instanceof DfaVariableValue) {
                PsiType type = iteratedValue.getType();
                SpecialField length = null;
                if (type instanceof PsiArrayType) {
                    length = SpecialField.ARRAY_LENGTH;
                } else if (InheritanceUtil.isInheritor(type, "java.util.Collection")) {
                    length = SpecialField.COLLECTION_SIZE;
                }
                if (length != null) {
                    this.addInstruction(new PushInstruction(length.createValue(this.myFactory, qualifier), null));
                    this.addInstruction(new PushInstruction(this.myFactory.getInt(0), null));
                    this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, iteratedValue, this.myProject));
                    this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, false, null));
                    hasSizeCheck = true;
                }
            }
        }
        ControlFlow.ControlFlowOffset offset = this.myCurrentFlow.getNextOffset();
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(parameter, false);
        this.addInstruction(new FlushVariableInstruction(dfaVariable));
        if (!hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, true, null));
        }
        if ((body = statement.getBody()) != null) {
            body.accept(this);
        }
        if (hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, true, null));
        }
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement(statement);
        this.myCurrentFlow.removeVariable(parameter);
    }

    @Override
    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update;
        this.startElement(statement);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept(this);
            initialization.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    this.visitElement(expression);
                }

                @Override
                public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                    PsiElement[] declaredElements;
                    for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }
            });
        }
        this.addCountingLoopBound(statement);
        PsiExpression condition = statement.getCondition();
        if (condition != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
        } else {
            this.addInstruction(new PushInstruction(statement.getRParenth() == null ? null : this.myFactory.getConstFactory().getTrue(), null));
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), true, condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        if ((update = statement.getUpdate()) != null) {
            update.accept(this);
        }
        ControlFlow.ControlFlowOffset offset = initialization != null ? this.getEndOffset(initialization) : this.getStartOffset(statement);
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement(statement);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.myCurrentFlow.removeVariable(psiVariable);
        }
    }

    private void addCountingLoopBound(PsiForStatement statement) {
        PsiVariable initialVariable;
        PsiExpression initializer;
        CountingLoop loop = CountingLoop.from(statement);
        if (loop == null) {
            return;
        }
        PsiLocalVariable counter = loop.getCounter();
        if (!(!loop.isIncluding() || PsiType.LONG.equals(counter.getType()) && PsiType.INT.equals(loop.getBound().getType()))) {
            Object bound = ExpressionUtils.computeConstantExpression(loop.getBound());
            if (!(bound instanceof Number)) {
                return;
            }
            if (bound.equals(Long.MAX_VALUE) || bound.equals(Integer.MAX_VALUE)) {
                return;
            }
        }
        if (!PsiType.INT.equals((initializer = loop.getInitializer()).getType()) && !PsiType.LONG.equals(initializer.getType())) {
            return;
        }
        DfaValue origin = null;
        Object initialValue = ExpressionUtils.computeConstantExpression(initializer);
        if (initialValue instanceof Number) {
            origin = this.myFactory.getConstFactory().createFromValue(initialValue, initializer.getType(), null);
        } else if (initializer instanceof PsiReferenceExpression && ((initialVariable = ObjectUtils.tryCast(((PsiReferenceExpression)initializer).resolve(), PsiVariable.class)) instanceof PsiLocalVariable || initialVariable instanceof PsiParameter) && !VariableAccessUtils.variableIsAssigned(initialVariable, statement.getBody())) {
            origin = this.myFactory.getVarFactory().createVariableValue(initialVariable, false);
        }
        if (origin == null || VariableAccessUtils.variableIsAssigned(counter, statement.getBody())) {
            return;
        }
        this.addInstruction(new PushInstruction(this.myFactory.getVarFactory().createVariableValue(counter, false), null));
        this.addInstruction(new PushInstruction(origin, null));
        this.addInstruction(new BinopInstruction(JavaTokenType.LT, null, this.myProject));
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), false, null));
    }

    @Override
    public void visitIfStatement(PsiIfStatement statement) {
        ControlFlow.ControlFlowOffset offset;
        this.startElement(statement);
        PsiExpression condition = statement.getCondition();
        PsiStatement thenStatement = statement.getThenBranch();
        PsiStatement elseStatement = statement.getElseBranch();
        ControlFlow.ControlFlowOffset controlFlowOffset = offset = elseStatement != null ? this.getStartOffset(elseStatement) : this.getEndOffset(statement);
        if (condition != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(offset, true, condition));
        }
        if (thenStatement != null) {
            thenStatement.accept(this);
        }
        if (elseStatement != null) {
            offset = this.getEndOffset(statement);
            GotoInstruction instruction = new GotoInstruction(offset);
            this.addInstruction(instruction);
            elseStatement.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitStatement(PsiStatement statement) {
        this.startElement(statement);
        this.finishElement(statement);
    }

    @Override
    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement(statement);
        PsiStatement childStatement = statement.getStatement();
        if (childStatement != null) {
            childStatement.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.addInstruction(new LambdaInstruction(expression));
        this.finishElement(expression);
    }

    @Override
    public void visitReturnStatement(PsiReturnStatement statement) {
        this.startElement(statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (this.myInlinedBlockContext != null) {
            if (returnValue != null) {
                DfaVariableValue var = this.myFactory.getVarFactory().createVariableValue(this.myInlinedBlockContext.myTarget, false);
                this.addInstruction(new PushInstruction(var, null, true));
                returnValue.accept(this);
                this.generateBoxingUnboxingInstructionFor(returnValue, var.getVariableType());
                if (this.myInlinedBlockContext.myForceNonNullBlockResult) {
                    this.addInstruction(new CheckNotNullInstruction(returnValue, NullabilityProblem.nullableFunctionReturn));
                }
                this.addInstruction(new AssignInstruction(returnValue, null));
                this.addInstruction(new PopInstruction());
            }
            this.controlTransfer(new InstructionTransfer(this.getEndOffset(this.myInlinedBlockContext.myCodeBlock), this.getVariablesInside(this.myInlinedBlockContext.myCodeBlock)), this.myTrapStack);
        } else {
            if (returnValue != null) {
                returnValue.accept(this);
                PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, true, PsiMember.class, PsiLambdaExpression.class);
                if (method != null) {
                    this.generateBoxingUnboxingInstructionFor(returnValue, method.getReturnType());
                } else {
                    PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiLambdaExpression.class, true, PsiMember.class);
                    if (lambdaExpression != null) {
                        this.generateBoxingUnboxingInstructionFor(returnValue, LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression));
                    }
                }
                this.addInstruction(new CheckReturnValueInstruction(returnValue));
            }
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, this.myTrapStack), statement));
        }
        this.finishElement(statement);
    }

    @Override
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement(statement);
        this.finishElement(statement);
    }

    @Override
    public void visitSwitchStatement(PsiSwitchStatement switchStmt) {
        PsiCodeBlock body;
        this.startElement(switchStmt);
        PsiExpression caseExpression = switchStmt.getExpression();
        HashSet<PsiEnumConstant> enumValues = null;
        if (caseExpression != null) {
            caseExpression.accept(this);
            this.generateBoxingUnboxingInstructionFor(caseExpression, PsiType.INT);
            PsiClass psiClass = PsiUtil.resolveClassInType(caseExpression.getType());
            if (psiClass != null) {
                this.addInstruction(new FieldReferenceInstruction(caseExpression, "switch statement expression"));
                if (psiClass.isEnum()) {
                    enumValues = new HashSet<PsiEnumConstant>();
                    for (PsiField f : psiClass.getFields()) {
                        if (!(f instanceof PsiEnumConstant)) continue;
                        enumValues.add((PsiEnumConstant)f);
                    }
                }
            } else {
                this.addInstruction(new PopInstruction());
            }
        }
        if ((body = switchStmt.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement psiLabelStatement = (PsiSwitchLabelStatement)statement;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    boolean alwaysTrue;
                    ControlFlow.ControlFlowOffset offset = this.getStartOffset(statement);
                    PsiExpression caseValue = psiLabelStatement.getCaseValue();
                    if (enumValues != null && caseValue instanceof PsiReferenceExpression) {
                        enumValues.remove(((PsiReferenceExpression)caseValue).resolve());
                    }
                    boolean bl = alwaysTrue = enumValues != null && enumValues.isEmpty();
                    if (alwaysTrue) {
                        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
                    } else if (caseValue != null && caseExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)caseExpression).getQualifierExpression() == null) {
                        this.addInstruction(new PushInstruction(this.myFactory.createValue(caseExpression), caseExpression));
                        caseValue.accept(this);
                        this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
                    } else {
                        this.pushUnknown();
                    }
                    this.addInstruction(new ConditionalGotoInstruction(offset, false, statement));
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            if (enumValues == null || !enumValues.isEmpty()) {
                ControlFlow.ControlFlowOffset offset = defaultLabel != null ? this.getStartOffset(defaultLabel) : this.getEndOffset(body);
                this.addInstruction(new GotoInstruction(offset));
            }
            body.accept(this);
        }
        this.finishElement(switchStmt);
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        this.startElement(expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept(this);
            this.addInstruction(new FieldReferenceInstruction(qualifier, METHOD_REFERENCE_QUALIFIER_SYNTHETIC_FIELD));
        }
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getFunctionalInterfaceType(), Nullness.NOT_NULL), expression));
        this.finishElement(expression);
    }

    @Override
    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        this.startElement(statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept(this);
            this.addInstruction(new FieldReferenceInstruction(lock, "Synchronized value"));
        }
        this.addInstruction(new FlushVariableInstruction(null));
        PsiCodeBlock body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitThrowStatement(PsiThrowStatement statement) {
        this.startElement(statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept(this);
            this.addConditionalRuntimeThrow();
            this.addInstruction(new FieldReferenceInstruction(exception, "thrown exception"));
            this.throwException(exception.getType(), (PsiElement)statement);
        }
        this.finishElement(statement);
    }

    private void addConditionalRuntimeThrow() {
        if (this.myTrapStack.isEmpty()) {
            return;
        }
        this.pushUnknown();
        ConditionalGotoInstruction ifNoException = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.pushUnknown();
        ConditionalGotoInstruction ifError = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.throwException(this.myRuntimeException, null);
        ifError.setOffset(this.myCurrentFlow.getInstructionCount());
        this.throwException(this.myError, null);
        ifNoException.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    @Override
    public void visitTryStatement(PsiTryStatement statement) {
        PsiCatchSection[] sections;
        Trap.TryFinally finallyDescriptor;
        this.startElement(statement);
        PsiResourceList resourceList = statement.getResourceList();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        Trap.TryFinally tryFinally = finallyDescriptor = finallyBlock != null ? new Trap.TryFinally(finallyBlock, this.getStartOffset(finallyBlock)) : null;
        if (finallyDescriptor != null) {
            this.myTrapStack = this.myTrapStack.prepend(finallyDescriptor);
        }
        if ((sections = statement.getCatchSections()).length > 0) {
            LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset> clauses = new LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset>();
            for (PsiCatchSection section : sections) {
                PsiCodeBlock catchBlock = section.getCatchBlock();
                if (catchBlock == null) continue;
                clauses.put(section, this.getStartOffset(catchBlock));
            }
            this.myTrapStack = this.myTrapStack.prepend(new Trap.TryCatch(statement, clauses));
        }
        if (resourceList != null) {
            resourceList.accept(this);
        }
        if (tryBlock != null) {
            tryBlock.accept(this);
        }
        InstructionTransfer gotoEnd = new InstructionTransfer(this.getEndOffset(statement), this.getVariablesInside(tryBlock));
        FList<Trap> singleFinally = FList.createFromReversed(ContainerUtil.createMaybeSingletonList(finallyDescriptor));
        this.controlTransfer(gotoEnd, singleFinally);
        if (sections.length > 0) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryCatch);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        for (PsiCatchSection section : sections) {
            PsiCodeBlock catchBlock = section.getCatchBlock();
            if (catchBlock != null) {
                this.visitCodeBlock(catchBlock);
            }
            this.controlTransfer(gotoEnd, singleFinally);
        }
        if (finallyBlock != null) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryFinally);
            this.myTrapStack = this.myTrapStack.getTail().prepend(new Trap.InsideFinally(finallyBlock));
            finallyBlock.accept(this);
            this.addInstruction(new ControlTransferInstruction(null));
            assert (this.myTrapStack.getHead() instanceof Trap.InsideFinally);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        this.finishElement(statement);
    }

    @Override
    public void visitResourceList(PsiResourceList resourceList) {
        for (PsiResourceListElement resource : resourceList) {
            List<PsiClassType> closerExceptions;
            if (resource instanceof PsiResourceVariable) {
                PsiResourceVariable variable = (PsiResourceVariable)resource;
                PsiExpression initializer = variable.getInitializer();
                if (initializer != null) {
                    this.initializeVariable(variable, initializer);
                }
            } else if (resource instanceof PsiResourceExpression) {
                ((PsiResourceExpression)resource).getExpression().accept(this);
            }
            if ((closerExceptions = ExceptionUtil.getCloserExceptions(resource)).isEmpty()) continue;
            this.addThrows(null, closerExceptions.toArray(new PsiClassType[closerExceptions.size()]));
        }
    }

    @Override
    public void visitWhileStatement(PsiWhileStatement statement) {
        this.startElement(statement);
        PsiExpression condition = statement.getCondition();
        if (condition != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), true, condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.addInstruction(new GotoInstruction(this.getStartOffset(statement)));
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions;
        this.startElement(list);
        for (PsiExpression expression : expressions = list.getExpressions()) {
            expression.accept(this);
        }
        this.finishElement(list);
    }

    @Override
    public void visitExpression(PsiExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.finishElement(expression);
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        this.startElement(expression);
        PsiExpression arrayExpression = expression.getArrayExpression();
        arrayExpression.accept(this);
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
            this.generateBoxingUnboxingInstructionFor(indexExpression, PsiType.INT);
        } else {
            this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
        }
        DfaValue toPush = this.myFactory.createValue(expression);
        if (toPush == null) {
            toPush = this.myFactory.createTypeValue(expression.getType(), Nullness.UNKNOWN);
        }
        this.addInstruction(new ArrayAccessInstruction(toPush, expression));
        this.finishElement(expression);
    }

    @Nullable
    private DfaVariableValue getTargetVariable(PsiExpression expression) {
        DfaValue value;
        PsiAssignmentExpression assignmentExpression;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(expression.getParent());
        if (parent instanceof PsiVariable) {
            return this.getFactory().getVarFactory().createVariableValue((PsiVariable)expression.getParent(), false);
        }
        if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.EQ) && PsiTreeUtil.isAncestor(assignmentExpression.getRExpression(), expression, false) && (value = this.getFactory().createValue(assignmentExpression.getLExpression())) instanceof DfaVariableValue) {
            return (DfaVariableValue)value;
        }
        return null;
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        this.startElement(expression);
        PsiType type = expression.getType();
        PsiType componentType = type instanceof PsiArrayType ? ((PsiArrayType)type).getComponentType() : null;
        DfaVariableValue var = this.getTargetVariable(expression);
        this.processArrayInitializers(expression, componentType, DfaPsiUtil.getTypeNullability(componentType));
        if (var != null) {
            this.addInstruction(new PushInstruction(var, null, true));
            this.addInstruction(new PushInstruction(this.getFactory().createTypeValue(type, Nullness.NOT_NULL), expression));
            this.addInstruction(new AssignInstruction(expression, var));
            this.addInstruction(new PushInstruction(SpecialField.ARRAY_LENGTH.createValue(this.getFactory(), var), null, true));
            this.addInstruction(new PushInstruction(this.getFactory().getInt(expression.getInitializers().length), null));
            this.addInstruction(new AssignInstruction(null, null));
            this.addInstruction(new PopInstruction());
        } else {
            this.pushUnknown();
        }
        this.finishElement(expression);
    }

    private void processArrayInitializers(@NotNull PsiArrayInitializerExpression expression, @Nullable PsiType componentType, @NotNull Nullness componentNullability) {
        PsiExpression[] initializers;
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        if (componentNullability == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        for (PsiExpression initializer : initializers = expression.getInitializers()) {
            initializer.accept(this);
            if (componentType != null) {
                this.generateBoxingUnboxingInstructionFor(initializer, componentType);
                if (componentNullability == Nullness.NOT_NULL) {
                    this.addInstruction(new CheckNotNullInstruction(initializer, NullabilityProblem.storingToNotNullArray));
                }
            }
            this.addInstruction(new PopInstruction());
        }
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, expression));
            this.finishElement(expression);
            return;
        }
        IElementType op = expression.getOperationTokenType();
        PsiExpression[] operands = expression.getOperands();
        if (operands.length <= 1) {
            this.pushUnknown();
            this.finishElement(expression);
            return;
        }
        PsiType type = expression.getType();
        if (op == JavaTokenType.ANDAND) {
            this.generateAndExpression(operands, type, true);
        } else if (op == JavaTokenType.OROR) {
            this.generateOrExpression(operands, type, true);
        } else if (op == JavaTokenType.XOR && PsiType.BOOLEAN.equals(type)) {
            this.generateXorExpression(expression, operands, type, false);
        } else if (op == JavaTokenType.AND && PsiType.BOOLEAN.equals(type)) {
            this.generateAndExpression(operands, type, false);
        } else if (op == JavaTokenType.OR && PsiType.BOOLEAN.equals(type)) {
            this.generateOrExpression(operands, type, false);
        } else if (ControlFlowAnalyzer.isBinaryDivision(op) && operands.length == 2 && type != null && PsiType.LONG.isAssignableFrom(type)) {
            this.generateDivMod(expression, type, operands[0], operands[1]);
        } else {
            this.generateOther(expression, op, operands, type);
        }
        this.finishElement(expression);
    }

    static boolean isBinaryDivision(IElementType binaryOp) {
        return binaryOp == JavaTokenType.DIV || binaryOp == JavaTokenType.PERC;
    }

    static boolean isAssignmentDivision(IElementType op) {
        return op == JavaTokenType.PERCEQ || op == JavaTokenType.DIVEQ;
    }

    private void generateDivMod(PsiPolyadicExpression expression, PsiType type, PsiExpression left, PsiExpression right) {
        left.accept(this);
        this.generateBoxingUnboxingInstructionFor(left, type);
        right.accept(this);
        this.generateBoxingUnboxingInstructionFor(right, type);
        this.checkZeroDivisor();
        this.addInstruction(new BinopInstruction(expression.getOperationTokenType(), expression.isPhysical() ? expression : null, this.myProject));
    }

    private void checkZeroDivisor() {
        this.addInstruction(new DupInstruction());
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(0, PsiType.LONG, null), null));
        this.addInstruction(new BinopInstruction(JavaTokenType.NE, null, this.myProject));
        ConditionalGotoInstruction ifNonZero = new ConditionalGotoInstruction(null, false, null);
        this.addInstruction(ifNonZero);
        this.throwException(JavaPsiFacade.getElementFactory(this.myProject).createTypeByFQClassName(ArithmeticException.class.getName()), null);
        ifNonZero.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    private void generateOther(PsiPolyadicExpression expression, IElementType op, PsiExpression[] operands, PsiType type) {
        op = ControlFlowAnalyzer.substituteBinaryOperation(op, type);
        PsiExpression lExpr = operands[0];
        lExpr.accept(this);
        PsiType lType = lExpr.getType();
        for (int i2 = 1; i2 < operands.length; ++i2) {
            PsiExpression rExpr = operands[i2];
            PsiType rType = rExpr.getType();
            this.acceptBinaryRightOperand(op, type, lExpr, lType, rExpr, rType);
            this.addInstruction(new BinopInstruction(op, expression.isPhysical() ? expression : null, this.myProject));
            lExpr = rExpr;
            lType = rType;
        }
    }

    @Nullable
    private static IElementType substituteBinaryOperation(IElementType op, PsiType type) {
        if (!(JavaTokenType.PLUS != op || type != null && type.equalsToText("java.lang.String"))) {
            return null;
        }
        return op;
    }

    private void acceptBinaryRightOperand(@Nullable IElementType op, PsiType type, PsiExpression lExpr, PsiType lType, PsiExpression rExpr, PsiType rType) {
        PsiType castType;
        boolean comparingPrimitiveNumeric;
        boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
        boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull(lType) && !TypeConversionUtil.isPrimitiveAndNotNull(rType);
        boolean bl = comparingPrimitiveNumeric = comparing && TypeConversionUtil.isPrimitiveAndNotNull(lType) && TypeConversionUtil.isPrimitiveAndNotNull(rType) && TypeConversionUtil.isNumericType(lType) && TypeConversionUtil.isNumericType(rType);
        PsiType psiType = comparingPrimitiveNumeric ? (TypeConversionUtil.isFloatOrDoubleType(lType) ? PsiType.DOUBLE : PsiType.LONG) : (castType = type);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(lExpr, castType);
        }
        rExpr.accept(this);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(rExpr, castType);
        }
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression expression, PsiType expectedType) {
        if (expression == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(5);
        }
        this.generateBoxingUnboxingInstructionFor(expression, expression.getType(), expectedType);
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression context, PsiType actualType, PsiType expectedType) {
        if (context == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        if (PsiType.VOID.equals(expectedType)) {
            return;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(expectedType) && TypeConversionUtil.isPrimitiveWrapper(actualType)) {
            this.addInstruction(new MethodCallInstruction(context, MethodCallInstruction.MethodType.UNBOXING, expectedType));
        } else if (TypeConversionUtil.isPrimitiveAndNotNull(actualType) && TypeConversionUtil.isAssignableFromPrimitiveWrapper(expectedType)) {
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(context, MethodCallInstruction.MethodType.BOXING, expectedType));
        } else if (actualType != expectedType && TypeConversionUtil.isPrimitiveAndNotNull(actualType) && TypeConversionUtil.isPrimitiveAndNotNull(expectedType) && TypeConversionUtil.isNumericType(actualType) && TypeConversionUtil.isNumericType(expectedType)) {
            this.addInstruction(new MethodCallInstruction(context, MethodCallInstruction.MethodType.CAST, expectedType){

                @Override
                public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
                    return visitor.visitCast(this, runner, stateBefore);
                }
            });
        }
    }

    private void generateXorExpression(PsiExpression expression, PsiExpression[] operands, PsiType exprType, boolean forAssignment) {
        PsiExpression operand = operands[0];
        operand.accept(this);
        if (forAssignment) {
            this.addInstruction(new DupInstruction());
        }
        this.generateBoxingUnboxingInstructionFor(operand, exprType);
        for (int i2 = 1; i2 < operands.length; ++i2) {
            operand = operands[i2];
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            PsiExpression psiAnchor = i2 == operands.length - 1 && expression.isPhysical() ? expression : null;
            this.addInstruction(new BinopInstruction(JavaTokenType.NE, psiAnchor, this.myProject));
        }
    }

    private void generateOrExpression(PsiExpression[] operands, PsiType exprType, boolean shortCircuit) {
        for (int i2 = 0; i2 < operands.length; ++i2) {
            PsiExpression nextOperand;
            PsiExpression operand = operands[i2];
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            if (!shortCircuit) {
                if (i2 <= 0) continue;
                this.combineStackBooleans(false, operand);
                continue;
            }
            PsiExpression psiExpression = nextOperand = i2 == operands.length - 1 ? null : operands[i2 + 1];
            if (nextOperand == null) continue;
            this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset(nextOperand), true, operand));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset(operands[operands.length - 1])));
        }
    }

    private void generateBooleanAssignmentExpression(boolean and, PsiExpression lExpression, PsiExpression rExpression, PsiType exprType) {
        lExpression.accept(this);
        this.generateBoxingUnboxingInstructionFor(lExpression, exprType);
        this.addInstruction(new DupInstruction());
        rExpression.accept(this);
        this.generateBoxingUnboxingInstructionFor(rExpression, exprType);
        this.addInstruction(new SwapInstruction());
        this.combineStackBooleans(and, lExpression);
    }

    private void combineStackBooleans(boolean and, PsiExpression anchor) {
        ConditionalGotoInstruction toPopAndPushSuccess = new ConditionalGotoInstruction(null, and, anchor);
        this.addInstruction(toPopAndPushSuccess);
        GotoInstruction overPushSuccess = new GotoInstruction(null);
        this.addInstruction(overPushSuccess);
        PopInstruction pop = new PopInstruction();
        this.addInstruction(pop);
        DfaConstValue constValue = this.myFactory.getBoolean(!and);
        PushInstruction pushSuccess = new PushInstruction(constValue, null);
        this.addInstruction(pushSuccess);
        toPopAndPushSuccess.setOffset(pop.getIndex());
        overPushSuccess.setOffset(pushSuccess.getIndex() + 1);
    }

    private void generateAndExpression(PsiExpression[] operands, PsiType exprType, boolean shortCircuit) {
        ArrayList<ConditionalGotoInstruction> branchToFail = new ArrayList<ConditionalGotoInstruction>();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            PsiExpression operand = operands[i2];
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            if (!shortCircuit) {
                if (i2 <= 0) continue;
                this.combineStackBooleans(true, operand);
                continue;
            }
            ConditionalGotoInstruction onFail = new ConditionalGotoInstruction(null, true, operand);
            branchToFail.add(onFail);
            this.addInstruction(onFail);
        }
        if (!shortCircuit) {
            return;
        }
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
        GotoInstruction toSuccess = new GotoInstruction(null);
        this.addInstruction(toSuccess);
        PushInstruction pushFalse = new PushInstruction(this.myFactory.getConstFactory().getFalse(), null);
        this.addInstruction(pushFalse);
        for (ConditionalGotoInstruction toFail : branchToFail) {
            toFail.setOffset(pushFalse.getIndex());
        }
        toSuccess.setOffset(pushFalse.getIndex() + 1);
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        this.startElement(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), expression));
        this.finishElement(expression);
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        ControlFlow.ControlFlowOffset elseOffset;
        this.startElement(expression);
        PsiExpression condition = expression.getCondition();
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        ControlFlow.ControlFlowOffset controlFlowOffset = elseOffset = elseExpression == null ? ControlFlow.deltaOffset(this.getEndOffset(expression), -1) : this.getStartOffset(elseExpression);
        if (thenExpression != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            PsiType type = expression.getType();
            this.addInstruction(new ConditionalGotoInstruction(elseOffset, true, PsiUtil.skipParenthesizedExprDown(condition)));
            thenExpression.accept(this);
            this.generateBoxingUnboxingInstructionFor(thenExpression, type);
            this.addInstruction(new GotoInstruction(this.getEndOffset(expression)));
            if (elseExpression != null) {
                elseExpression.accept(this);
                this.generateBoxingUnboxingInstructionFor(elseExpression, type);
            } else {
                this.pushUnknown();
            }
        } else {
            this.pushUnknown();
        }
        this.finishElement(expression);
    }

    void pushUnknown() {
        this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        this.startElement(expression);
        PsiExpression operand = expression.getOperand();
        PsiTypeElement checkType = expression.getCheckType();
        if (checkType != null) {
            operand.accept(this);
            PsiType type = checkType.getType();
            if (type instanceof PsiClassType) {
                type = ((PsiClassType)type).rawType();
            }
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type, Nullness.UNKNOWN), null));
            this.addInstruction(new InstanceofInstruction(expression, this.myProject, operand, type));
        } else {
            this.pushUnknown();
        }
        this.finishElement(expression);
    }

    private void addMethodThrows(PsiMethod method, @Nullable PsiElement explicitCall) {
        if (method != null) {
            this.addThrows(explicitCall, method.getThrowsList().getReferencedTypes());
        }
    }

    private void addThrows(@Nullable PsiElement explicitCall, PsiClassType[] refs) {
        for (PsiClassType ref : refs) {
            this.pushUnknown();
            ConditionalGotoInstruction cond = new ConditionalGotoInstruction(null, false, null);
            this.addInstruction(cond);
            this.throwException(ref, explicitCall);
            cond.setOffset(this.myCurrentFlow.getInstructionCount());
        }
    }

    private void throwException(PsiType ref, @Nullable PsiElement anchor) {
        this.throwException(new ExceptionTransfer(this.myFactory.createTypeValue(ref, Nullness.NOT_NULL)), anchor);
    }

    private void throwException(ExceptionTransfer kind, @Nullable PsiElement anchor) {
        this.addInstruction(new EmptyStackInstruction());
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(kind, this.myTrapStack), anchor));
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        this.startElement(expression);
        if (this.myInlining) {
            for (CallInliner inliner : INLINERS) {
                if (!inliner.tryInlineCall(new CFGBuilder(this), expression)) continue;
                this.finishElement(expression);
                return;
            }
        }
        if ((qualifierExpression = (methodExpression = expression.getMethodExpression()).getQualifierExpression()) != null) {
            qualifierExpression.accept(this);
        } else {
            this.pushUnknown();
        }
        PsiExpression[] expressions = expression.getArgumentList().getExpressions();
        JavaResolveResult result = methodExpression.advancedResolve(false);
        PsiElement method = result.getElement();
        PsiParameter[] parameters = method instanceof PsiMethod ? ((PsiMethod)method).getParameterList().getParameters() : null;
        boolean isEqualsCall = expressions.length == 1 && method instanceof PsiMethod && "equals".equals(((PsiMethod)method).getName()) && parameters.length == 1 && parameters[0].getType().equalsToText("java.lang.Object") && PsiType.BOOLEAN.equals(((PsiMethod)method).getReturnType());
        for (int i2 = 0; i2 < expressions.length; ++i2) {
            PsiExpression paramExpr = expressions[i2];
            paramExpr.accept(this);
            if (parameters != null && i2 < parameters.length) {
                this.generateBoxingUnboxingInstructionFor(paramExpr, result.getSubstitutor().substitute(parameters[i2].getType()));
            }
            if (i2 != 0 || !isEqualsCall) continue;
            this.addInstruction(new SpliceInstruction(2, 0, 1, 0));
        }
        this.addBareCall(expression, expression.getMethodExpression());
        if (isEqualsCall) {
            ConditionalGotoInstruction ifFalse = this.addInstruction(new ConditionalGotoInstruction(null, true, null));
            this.addInstruction(new ApplyNotNullInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset(expression)));
            ifFalse.setOffset(this.myCurrentFlow.getInstructionCount());
            this.addInstruction(new PopInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getFalse(), null));
        }
        this.finishElement(expression);
    }

    void addBareCall(@Nullable PsiMethodCallExpression expression, @NotNull PsiReferenceExpression reference) {
        PsiExpression anchor;
        MethodCallInstruction instruction;
        List contracts2;
        if (reference == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        this.addConditionalRuntimeThrow();
        PsiMethod method = ObjectUtils.tryCast(reference.resolve(), PsiMethod.class);
        List<Object> list = contracts2 = method == null ? Collections.emptyList() : ControlFlowAnalyzer.getMethodCallContracts(method, expression);
        if (expression == null) {
            assert (reference instanceof PsiMethodReferenceExpression);
            instruction = new MethodCallInstruction((PsiMethodReferenceExpression)reference, contracts2);
            anchor = reference;
        } else {
            instruction = new MethodCallInstruction(expression, this.myFactory.createValue(expression), contracts2);
            anchor = expression;
        }
        this.addInstruction(instruction);
        if (contracts2.stream().anyMatch(c -> c.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION)) {
            this.addInstruction(new DupInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getContractFail(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
            ConditionalGotoInstruction ifNotFail = new ConditionalGotoInstruction(null, true, null);
            this.addInstruction(ifNotFail);
            this.addInstruction(new EmptyStackInstruction());
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(new ExceptionTransfer(DfaUnknownValue.getInstance()), this.myTrapStack), anchor));
            ifNotFail.setOffset(this.myCurrentFlow.getInstructionCount());
        }
        if (!this.myTrapStack.isEmpty()) {
            this.addMethodThrows(method, anchor);
        }
    }

    public static List<? extends MethodContract> getMethodCallContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        List<MethodContract> contracts2;
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        return !(contracts2 = HardcodedContracts.getHardcodedContracts(method, call)).isEmpty() ? contracts2 : ControlFlowAnalyzer.getMethodContracts(method);
    }

    public static List<StandardMethodContract> getMethodContracts(@NotNull PsiMethod method) {
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        return (List)CachedValuesManager.getCachedValue(method, () -> {
            String text2;
            PsiAnnotation contractAnno;
            if (method == null) {
                ControlFlowAnalyzer.$$$reportNull$$$0(16);
            }
            if ((contractAnno = ControlFlowAnalyzer.findContractAnnotation(method)) != null && (text2 = AnnotationUtil.getStringAttributeValue(contractAnno, null)) != null) {
                try {
                    int paramCount = method.getParameterList().getParametersCount();
                    List<StandardMethodContract> applicable = ContainerUtil.filter(StandardMethodContract.parseContract(text2), contract -> contract.arguments.length == paramCount);
                    return CachedValueProvider.Result.create(applicable, contractAnno, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return CachedValueProvider.Result.create(Collections.emptyList(), method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(10);
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
    }

    public static boolean isPure(@NotNull PsiMethod method) {
        PsiAnnotation anno;
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(11);
        }
        return (anno = ControlFlowAnalyzer.findContractAnnotation(method)) != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue(anno, "pure"));
    }

    @Override
    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (enumConstant.getArgumentList() == null) {
            return;
        }
        this.pushUnknown();
        this.pushConstructorArguments(enumConstant);
        this.addInstruction(new MethodCallInstruction(enumConstant, null, Collections.emptyList()));
        this.addInstruction(new PopInstruction());
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression) {
        PsiType type;
        this.startElement(expression);
        PsiExpression qualifier = expression.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
            this.addInstruction(new CheckNotNullInstruction(expression, NullabilityProblem.callNPE));
            this.addInstruction(new PopInstruction());
        }
        if ((type = expression.getType()) instanceof PsiArrayType) {
            DfaVariableValue var = this.getTargetVariable(expression);
            if (var == null) {
                var = this.getFactory().getVarFactory().createVariableValue(this.createTempVariable(type), false);
            }
            DfaValue length = SpecialField.ARRAY_LENGTH.createValue(this.getFactory(), var);
            this.addInstruction(new PushInstruction(length, null, true));
            PsiExpression[] dimensions = expression.getArrayDimensions();
            boolean sizeOnStack = false;
            for (PsiExpression dimension : dimensions) {
                dimension.accept(this);
                if (sizeOnStack) {
                    this.addInstruction(new PopInstruction());
                }
                sizeOnStack = true;
            }
            PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
            if (arrayInitializer != null) {
                PsiType expectedType;
                Nullness nullability = DfaPsiUtil.getTypeNullability(((PsiArrayType)type).getComponentType());
                if (nullability == Nullness.UNKNOWN && (expectedType = ExpectedTypeUtils.findExpectedType(expression, false)) instanceof PsiArrayType) {
                    nullability = DfaPsiUtil.getTypeNullability(((PsiArrayType)expectedType).getComponentType());
                }
                this.processArrayInitializers(arrayInitializer, ((PsiArrayType)type).getComponentType(), nullability);
                if (!sizeOnStack) {
                    sizeOnStack = true;
                    this.addInstruction(new PushInstruction(this.getFactory().getInt(arrayInitializer.getInitializers().length), null));
                }
            }
            if (!sizeOnStack) {
                this.pushUnknown();
            }
            this.addInstruction(new PushInstruction(var, null, true));
            this.addInstruction(new PushInstruction(this.getFactory().createTypeValue(type, Nullness.NOT_NULL), expression));
            this.addInstruction(new AssignInstruction(expression, var));
            this.addInstruction(new SpliceInstruction(3, 0, 2, 1));
            this.addInstruction(new AssignInstruction(null, length));
            this.addInstruction(new PopInstruction());
        } else {
            this.pushUnknown();
            PsiMethod constructor = this.pushConstructorArguments(expression);
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(expression, null, constructor == null ? Collections.emptyList() : ControlFlowAnalyzer.getMethodContracts(constructor)));
            if (!this.myTrapStack.isEmpty()) {
                this.addMethodThrows(constructor, expression);
            }
        }
        this.finishElement(expression);
    }

    @Nullable
    private PsiMethod pushConstructorArguments(PsiConstructorCall call) {
        PsiExpressionList args = call.getArgumentList();
        PsiMethod ctr = call.resolveConstructor();
        if (args != null) {
            PsiExpression[] params = args.getExpressions();
            PsiParameter[] parameters = ctr == null ? null : ctr.getParameterList().getParameters();
            for (int i2 = 0; i2 < params.length; ++i2) {
                PsiExpression param = params[i2];
                param.accept(this);
                if (parameters == null || i2 >= parameters.length) continue;
                this.generateBoxingUnboxingInstructionFor(param, parameters[i2].getType());
            }
        }
        return ctr;
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.startElement(expression);
        PsiExpression inner = expression.getExpression();
        if (inner != null) {
            inner.accept(this);
        } else {
            this.pushUnknown();
        }
        this.finishElement(expression);
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression) {
        this.startElement(expression);
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression.getOperand());
        if (operand != null) {
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, PsiType.INT);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new PopInstruction());
        this.pushUnknown();
        this.flushIncrementedValue(operand);
        this.finishElement(expression);
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        if (dfaValue == null) {
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression.getOperand());
            if (operand == null) {
                this.pushUnknown();
            } else {
                operand.accept(this);
                PsiType type = expression.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType(type);
                this.generateBoxingUnboxingInstructionFor(operand, unboxed == null ? type : unboxed);
                if (expression.getOperationTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction(new NotInstruction());
                } else {
                    this.addInstruction(new PopInstruction());
                    this.pushUnknown();
                    this.flushIncrementedValue(operand);
                }
            }
        } else {
            this.addInstruction(new PushInstruction(dfaValue, expression));
        }
        this.finishElement(expression);
    }

    private void flushIncrementedValue(@Nullable PsiExpression operand) {
        DfaValue dfaVariable;
        DfaValue dfaValue = dfaVariable = operand == null ? null : this.myFactory.createValue(operand);
        if (dfaVariable instanceof DfaVariableValue && PsiUtil.isAccessedForWriting(operand)) {
            this.addInstruction(new FlushVariableInstruction((DfaVariableValue)dfaVariable));
            if (((DfaVariableValue)dfaVariable).getPsiVariable() instanceof PsiField) {
                this.addInstruction(new FlushVariableInstruction(null));
            }
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.startElement(expression);
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept(this);
            this.addInstruction(expression.resolve() instanceof PsiField ? new FieldReferenceInstruction(expression, null) : new PopInstruction());
        }
        boolean writing = PsiUtil.isAccessedForWriting(expression) && !PsiUtil.isAccessedForReading(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createValue(expression), expression, writing));
        this.finishElement(expression);
    }

    @Override
    public void visitSuperExpression(PsiSuperExpression expression) {
        this.startElement(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), null));
        this.finishElement(expression);
    }

    @Override
    public void visitThisExpression(PsiThisExpression expression) {
        this.startElement(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), null));
        this.finishElement(expression);
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createLiteralValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.finishElement(expression);
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression castExpression) {
        this.startElement(castExpression);
        PsiExpression operand = castExpression.getOperand();
        if (operand != null) {
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, castExpression.getType());
        } else {
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(castExpression.getType(), Nullness.UNKNOWN), null));
        }
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand != null && operand.getType() != null) {
            if (typeElement.getType() instanceof PsiPrimitiveType && UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(castExpression)) {
                this.addInstruction(new PopInstruction());
                this.pushUnknown();
            } else {
                this.addInstruction(new TypeCastInstruction(castExpression, operand, typeElement.getType()));
            }
        }
        this.finishElement(castExpression);
    }

    @Override
    public void visitClass(PsiClass aClass) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inlineBlock(@NotNull PsiCodeBlock block, @NotNull Nullness resultNullness, @NotNull PsiVariable target) {
        if (block == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(12);
        }
        if (resultNullness == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(13);
        }
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(14);
        }
        InlinedBlockContext oldBlock = this.myInlinedBlockContext;
        this.addInstruction(new PushInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, this.myTrapStack), null));
        this.myInlinedBlockContext = new InlinedBlockContext(block, resultNullness == Nullness.NOT_NULL, target);
        this.startElement(block);
        try {
            block.accept(this);
        }
        finally {
            this.finishElement(block);
            this.myInlinedBlockContext = oldBlock;
            this.addInstruction(new PopInstruction());
        }
    }

    @NotNull
    PsiVariable createTempVariable(@Nullable PsiType type) {
        if (type == null) {
            type = PsiType.VOID;
        }
        TempVariable tempVariable = new TempVariable(this.getInstructionCount(), type, this.getContext());
        if (tempVariable == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(15);
        }
        return tempVariable;
    }

    public static boolean isTempVariable(PsiModifierListOwner variable) {
        return variable instanceof TempVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentNullability";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultNullness";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrapsInsideStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesInside";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processArrayInitializers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateBoxingUnboxingInstructionFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addBareCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCallContracts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethodContracts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findContractAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPure";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inlineBlock";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMethodContracts$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InlinedBlockContext {
        final PsiCodeBlock myCodeBlock;
        final boolean myForceNonNullBlockResult;
        final PsiVariable myTarget;

        public InlinedBlockContext(PsiCodeBlock codeBlock, boolean forceNonNullBlockResult, PsiVariable target) {
            this.myCodeBlock = codeBlock;
            this.myForceNonNullBlockResult = forceNonNullBlockResult;
            this.myTarget = target;
        }
    }

    private static class TempVariable
    extends LightVariableBuilder<TempVariable> {
        TempVariable(int index, @NotNull PsiType type, @NotNull PsiElement navigationElement) {
            if (type == null) {
                TempVariable.$$$reportNull$$$0(0);
            }
            if (navigationElement == null) {
                TempVariable.$$$reportNull$$$0(1);
            }
            super("tmp$" + index, type, navigationElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigationElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer$TempVariable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ApplyNotNullInstruction
    extends Instruction {
        private ApplyNotNullInstruction() {
        }

        @Override
        public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState state, InstructionVisitor visitor) {
            DfaValue value = state.pop();
            DfaValueFactory factory = runner.getFactory();
            if (state.applyCondition(factory.createCondition(value, DfaRelationValue.RelationType.NE, factory.getConstFactory().getNull()))) {
                return this.nextInstruction(runner, state);
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }

        public String toString() {
            return "APPLY NOT NULL";
        }
    }

    private static class CannotAnalyzeException
    extends RuntimeException {
        private CannotAnalyzeException() {
        }
    }
}

