/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateThrows;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateThrowsInspection
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean ignoreSubclassing;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.duplicate.throws.display.name", new Object[0]);
        if (string == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("DuplicateThrows" == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(2);
        }
        return "DuplicateThrows";
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message("inspection.duplicate.throws.ignore.subclassing.option", new Object[0]), this, "ignoreSubclassing");
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
                PsiClassType[] types = throwsList.getReferencedTypes();
                for (int i2 = 0; i2 < types.length; ++i2) {
                    for (int j = i2 + 1; j < types.length; ++j) {
                        PsiClassType type = types[i2];
                        PsiClassType otherType = types[j];
                        String problem = null;
                        PsiJavaCodeReferenceElement ref = refs[i2];
                        if (type.equals(otherType)) {
                            problem = InspectionsBundle.message("inspection.duplicate.throws.problem", new Object[0]);
                        } else if (!DuplicateThrowsInspection.this.ignoreSubclassing) {
                            if (otherType.isAssignableFrom(type)) {
                                problem = InspectionsBundle.message("inspection.duplicate.throws.more.general.problem", otherType.getCanonicalText());
                            } else if (type.isAssignableFrom(otherType)) {
                                problem = InspectionsBundle.message("inspection.duplicate.throws.more.general.problem", type.getCanonicalText());
                                ref = refs[j];
                                type = otherType;
                            }
                        }
                        if (problem == null) continue;
                        holder.registerProblem((PsiElement)ref, problem, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new MethodThrowsFix(method, type, false, false));
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

