/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;

public abstract class InspectionElementsMergerBase
extends InspectionElementsMerger {
    protected Element writeOldSettings(String sourceToolName) throws WriteExternalException {
        Element sourceElement = new Element("inspection_tool");
        sourceElement.setAttribute("class", sourceToolName);
        sourceElement.setAttribute("enabled", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        sourceElement.setAttribute("level", this.getDefaultSeverityLevel(sourceToolName));
        sourceElement.setAttribute("enabled_by_default", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        return sourceElement;
    }

    protected String getDefaultSeverityLevel(String sourceToolName) {
        return HighlightSeverity.WARNING.getName();
    }

    protected boolean isEnabledByDefault(String sourceToolName) {
        return true;
    }

    protected static String getMergedMarkerName(String toolName) {
        return toolName + "Merged";
    }

    protected boolean markSettingsMerged(Map<String, Element> inspectionsSettings) {
        Element merge = this.merge(inspectionsSettings, true);
        if (merge != null) {
            Element defaultElement = this.merge(Collections.emptyMap(), true);
            return !JDOMUtil.areElementsEqual(merge, defaultElement);
        }
        return false;
    }

    protected boolean areSettingsMerged(Map<String, Element> inspectionsSettings, Element inspectionElement) {
        Element merge = this.merge(inspectionsSettings, true);
        return merge != null && JDOMUtil.areElementsEqual(merge, inspectionElement);
    }

    protected Element merge(Map<String, Element> inspectionElements) {
        return this.merge(inspectionElements, false);
    }

    protected Element merge(Map<String, Element> inspectionElements, boolean includeDefaults) {
        LinkedHashMap<String, Element> scopes = new LinkedHashMap<String, Element>();
        boolean enabled = false;
        String level = null;
        Element toolElement = new Element("inspection_tool");
        for (String sourceToolName : this.getSourceToolNames()) {
            Element sourceElement = inspectionElements.get(sourceToolName);
            if (sourceElement == null) {
                if (includeDefaults) {
                    try {
                        sourceElement = this.writeOldSettings(sourceToolName);
                    }
                    catch (WriteExternalException writeExternalException) {}
                } else {
                    enabled |= this.isEnabledByDefault(sourceToolName);
                    if (level == null) {
                        level = this.getDefaultSeverityLevel(sourceToolName);
                    }
                }
            }
            if (sourceElement == null) continue;
            this.collectContent(sourceToolName, sourceElement, toolElement, scopes);
            enabled |= Boolean.parseBoolean(sourceElement.getAttributeValue("enabled"));
            if (level != null) continue;
            level = InspectionElementsMergerBase.getLevel(sourceElement);
        }
        if (!toolElement.getChildren().isEmpty()) {
            toolElement.setAttribute("class", this.getMergedToolName());
            toolElement.setAttribute("enabled", String.valueOf(enabled));
            if (level != null) {
                toolElement.setAttribute("level", level);
            }
            toolElement.setAttribute("enabled_by_default", String.valueOf(enabled));
            for (Element scopeEl : scopes.values()) {
                toolElement.addContent(scopeEl);
            }
            return toolElement;
        }
        return null;
    }

    private static String getLevel(Element element) {
        return element != null ? element.getAttributeValue("level") : HighlightSeverity.WARNING.getName();
    }

    protected void collectContent(String sourceToolName, Element sourceElement, Element toolElement, Map<String, Element> scopes) {
        if (sourceElement != null) {
            Element wrapElement = this.wrapElement(sourceToolName, sourceElement, toolElement);
            for (Element element : sourceElement.getChildren()) {
                if ("scope".equals(element.getName())) {
                    String scopeName = element.getAttributeValue("name");
                    if (scopes.containsKey(scopeName)) {
                        this.copyScopeContent(sourceToolName, element, scopes.get(scopeName));
                        continue;
                    }
                    if (scopeName == null) continue;
                    Element scopeElement = element.clone();
                    scopeElement.removeContent();
                    scopes.put(scopeName, scopeElement);
                    this.copyScopeContent(sourceToolName, element, scopeElement);
                    continue;
                }
                wrapElement.addContent(element.clone());
            }
        }
    }

    private void copyScopeContent(String sourceToolName, Element element, Element scopeElement) {
        Element wrappedScope = this.wrapElement(sourceToolName, null, scopeElement);
        for (Element scopeEl : element.getChildren()) {
            wrappedScope.addContent(scopeEl.clone());
        }
    }

    protected Element wrapElement(String sourceToolName, Element sourceElement, Element toolElement) {
        return toolElement;
    }
}

