/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.ide.structureView.impl.java.SuperTypeGroup;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SuperTypesGrouper
implements Grouper {
    public static final Key<WeakReference<PsiMethod>> SUPER_METHOD_KEY = Key.create("StructureTreeBuilder.SUPER_METHOD_KEY");
    @NonNls
    public static final String ID = "SHOW_INTERFACES";

    @Override
    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode parent, @NotNull Collection<TreeElement> children) {
        if (parent == null) {
            SuperTypesGrouper.$$$reportNull$$$0(0);
        }
        if (children == null) {
            SuperTypesGrouper.$$$reportNull$$$0(1);
        }
        if (SuperTypesGrouper.isParentGrouped(parent)) {
            List<Group> list = Collections.emptyList();
            if (list == null) {
                SuperTypesGrouper.$$$reportNull$$$0(2);
            }
            return list;
        }
        THashMap groups = new THashMap();
        for (TreeElement child : children) {
            if (!(child instanceof PsiMethodTreeElement)) continue;
            PsiMethodTreeElement element = (PsiMethodTreeElement)child;
            PsiMethod method = ((PsiMethodTreeElement)child).getMethod();
            if (element.isInherited()) {
                PsiClass groupClass = method.getContainingClass();
                SuperTypeGroup group = SuperTypesGrouper.getOrCreateGroup(groupClass, SuperTypeGroup.OwnershipType.INHERITS, (Map<Group, SuperTypeGroup>)groups);
                group.addMethod(child);
                continue;
            }
            PsiMethod[] superMethods = method.findSuperMethods();
            if (superMethods.length <= 0) continue;
            for (int i2 = 1; i2 < superMethods.length; ++i2) {
                PsiMethod superMethod = superMethods[i2];
                PsiClass containingClass = superMethod.getContainingClass();
                if (containingClass == null || !containingClass.isInterface()) continue;
                ArrayUtil.swap(superMethods, 0, i2);
                break;
            }
            PsiMethod superMethod = superMethods[0];
            method.putUserData(SUPER_METHOD_KEY, new WeakReference<PsiMethod>(superMethod));
            PsiClass groupClass = superMethod.getContainingClass();
            boolean overrides = SuperTypesGrouper.methodOverridesSuper(method, superMethod);
            SuperTypeGroup.OwnershipType ownershipType = overrides ? SuperTypeGroup.OwnershipType.OVERRIDES : SuperTypeGroup.OwnershipType.IMPLEMENTS;
            SuperTypeGroup group = SuperTypesGrouper.getOrCreateGroup(groupClass, ownershipType, (Map<Group, SuperTypeGroup>)groups);
            group.addMethod(child);
        }
        Set<Group> set = groups.keySet();
        if (set == null) {
            SuperTypesGrouper.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static SuperTypeGroup getOrCreateGroup(PsiClass groupClass, SuperTypeGroup.OwnershipType ownershipType, Map<Group, SuperTypeGroup> groups) {
        SuperTypeGroup superTypeGroup = new SuperTypeGroup(groupClass, ownershipType);
        SuperTypeGroup existing = groups.get(superTypeGroup);
        if (existing == null) {
            groups.put(superTypeGroup, superTypeGroup);
            existing = superTypeGroup;
        }
        return existing;
    }

    private static boolean isParentGrouped(AbstractTreeNode parent) {
        while (parent != null) {
            if (parent.getValue() instanceof SuperTypeGroup) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean methodOverridesSuper(PsiMethod method, PsiMethod superMethod) {
        boolean overrides = false;
        if (method.hasModifierProperty("abstract") || !superMethod.hasModifierProperty("abstract")) {
            overrides = true;
        }
        return overrides;
    }

    @Override
    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message("action.structureview.group.methods.by.defining.type", new Object[0]), null, AllIcons.General.ImplementingMethod);
        if (actionPresentationData == null) {
            SuperTypesGrouper.$$$reportNull$$$0(4);
        }
        return actionPresentationData;
    }

    @Override
    @NotNull
    public String getName() {
        if (ID == null) {
            SuperTypesGrouper.$$$reportNull$$$0(5);
        }
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/java/SuperTypesGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/java/SuperTypesGrouper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

