/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.TrackingPathMacroSubstitutorImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @NotNull String macroName, @Nullable String path) {
        if (result == null) {
            BasePathMacroManager.$$$reportNull$$$0(0);
        }
        if (macroName == null) {
            BasePathMacroManager.$$$reportNull$$$0(1);
        }
        if (path != null) {
            BasePathMacroManager.addFileHierarchyReplacements(result, BasePathMacroManager.getLocalFileSystem().findFileByPath(path), '$' + macroName + '$');
        }
    }

    private static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @Nullable VirtualFile f, @NotNull String macro) {
        if (result == null) {
            BasePathMacroManager.$$$reportNull$$$0(2);
        }
        if (macro == null) {
            BasePathMacroManager.$$$reportNull$$$0(3);
        }
        if (f == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result, f.getParent(), macro + "/..");
        result.put(macro, StringUtil.trimEnd(f.getPath(), "/"));
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = '$' + macroName + '$';
        path = StringUtil.trimEnd(FileUtil.toSystemIndependentName(path), "/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty(path) && path.contains("/")) {
            result.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName(path, '/');
        }
    }

    @NotNull
    private static VirtualFileSystem getLocalFileSystem() {
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        if (virtualFileSystem == null) {
            BasePathMacroManager.$$$reportNull$$$0(4);
        }
        return virtualFileSystem;
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        this.getPathMacros().addMacroExpands(result);
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroExpand(entry.getKey(), entry.getValue());
        }
        ExpandMacroToPathMap expandMacroToPathMap = result;
        if (expandMacroToPathMap == null) {
            BasePathMacroManager.$$$reportNull$$$0(5);
        }
        return expandMacroToPathMap;
    }

    @NotNull
    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        this.getPathMacros().addMacroReplacements(result);
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroReplacement(entry.getValue(), entry.getKey());
        }
        ReplacePathToMacroMap replacePathToMacroMap = result;
        if (replacePathToMacroMap == null) {
            BasePathMacroManager.$$$reportNull$$$0(6);
        }
        return replacePathToMacroMap;
    }

    @Override
    @NotNull
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        TrackingPathMacroSubstitutorImpl trackingPathMacroSubstitutorImpl = new TrackingPathMacroSubstitutorImpl(this);
        if (trackingPathMacroSubstitutorImpl == null) {
            BasePathMacroManager.$$$reportNull$$$0(7);
        }
        return trackingPathMacroSubstitutorImpl;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    public String expandPath(@Nullable String text2) {
        if (StringUtil.isEmpty(text2)) {
            return text2;
        }
        return this.getExpandMacroMap().substitute(text2, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public String collapsePath(@Nullable String text2, boolean recursively) {
        if (StringUtil.isEmpty(text2)) {
            return text2;
        }
        return this.getReplacePathMap().substitute(text2, SystemInfo.isFileSystemCaseSensitive, recursively);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            BasePathMacroManager.$$$reportNull$$$0(8);
        }
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element, boolean recursively) {
        if (element == null) {
            BasePathMacroManager.$$$reportNull$$$0(9);
        }
        BasePathMacroManager.collapsePaths(element, recursively, this.getReplacePathMap());
    }

    public static void collapsePaths(@NotNull Element element, boolean recursively, @NotNull ReplacePathToMacroMap map) {
        if (element == null) {
            BasePathMacroManager.$$$reportNull$$$0(10);
        }
        if (map == null) {
            BasePathMacroManager.$$$reportNull$$$0(11);
        }
        map.substitute(element, SystemInfo.isFileSystemCaseSensitive, recursively, Holder.FILTER);
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        PathMacrosImpl pathMacrosImpl = this.myPathMacros;
        if (pathMacrosImpl == null) {
            BasePathMacroManager.$$$reportNull$$$0(12);
        }
        return pathMacrosImpl;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual(FileUtil.toSystemIndependentName(path1), FileUtil.toSystemIndependentName(path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/BasePathMacroManager";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/BasePathMacroManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileSystem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacePathMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrackingSubstitutor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFileHierarchyReplacements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandPaths";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collapsePaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter(Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));

        private Holder() {
        }
    }
}

