/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.ex.ProjectRootContainer;
import com.intellij.openapi.projectRoots.impl.CompositeProjectRoot;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProjectRootContainerImpl
implements JDOMExternalizable,
ProjectRootContainer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl");
    private final Map<OrderRootType, CompositeProjectRoot> myRoots = new THashMap();
    private final Map<OrderRootType, VirtualFile[]> myCachedFiles = new THashMap();
    private boolean myInsideChange;
    private final List<ProjectRootListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final boolean myNoCopyJars;

    ProjectRootContainerImpl(boolean noCopyJars) {
        this.myNoCopyJars = noCopyJars;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            this.myRoots.put(rootType, new CompositeProjectRoot());
            this.myCachedFiles.put(rootType, VirtualFile.EMPTY_ARRAY);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        if (type == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(0);
        }
        VirtualFile[] virtualFileArray = ObjectUtils.chooseNotNull(this.myCachedFiles.get(type), VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(1);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public ProjectRoot[] getRoots(@NotNull OrderRootType type) {
        if (type == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(2);
        }
        ProjectRoot[] projectRootArray = this.myRoots.get(type).getProjectRoots();
        if (projectRootArray == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(3);
        }
        return projectRootArray;
    }

    void startChange() {
        this.myInsideChange = true;
    }

    private void assertNotInsideChange() {
        if (this.myInsideChange) {
            throw new IllegalStateException();
        }
    }

    private void assertInsideChange() {
        if (!this.myInsideChange) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void changeRoots(@NotNull Runnable change) {
        if (change == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(4);
        }
        this.assertNotInsideChange();
        this.myInsideChange = true;
        THashMap oldRoots = new THashMap(this.myCachedFiles);
        try {
            change.run();
        }
        finally {
            this.myInsideChange = false;
            if (this.cacheFiles((Map<OrderRootType, VirtualFile[]>)oldRoots)) {
                this.fireRootsChanged();
            }
        }
    }

    private boolean cacheFiles(@NotNull Map<OrderRootType, VirtualFile[]> oldRoots) {
        if (oldRoots == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(5);
        }
        this.myCachedFiles.clear();
        boolean changed = false;
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            VirtualFile[] roots = this.myRoots.get(orderRootType).getVirtualFiles();
            changed |= !Comparing.equal(roots, (Object[])oldRoots.get(orderRootType));
            this.myCachedFiles.put(orderRootType, roots);
        }
        return changed;
    }

    void addProjectRootContainerListener(@NotNull ProjectRootListener listener) {
        if (listener == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(6);
        }
        this.myListeners.add(listener);
    }

    public void removeProjectRootContainerListener(@NotNull ProjectRootListener listener) {
        if (listener == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(7);
        }
        this.myListeners.remove(listener);
    }

    private void fireRootsChanged() {
        for (ProjectRootListener listener : this.myListeners) {
            listener.rootsChanged();
        }
    }

    @Override
    public void removeRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type) {
        if (root == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(8);
        }
        if (type == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(9);
        }
        this.assertInsideChange();
        this.myRoots.get(type).remove(root);
    }

    @Override
    @NotNull
    public ProjectRoot addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType type) {
        if (virtualFile == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(10);
        }
        if (type == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(11);
        }
        this.assertInsideChange();
        ProjectRoot projectRoot = this.myRoots.get(type).add(virtualFile);
        if (projectRoot == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(12);
        }
        return projectRoot;
    }

    @Override
    public void addRoot(@NotNull ProjectRoot root, @NotNull OrderRootType type) {
        if (root == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(13);
        }
        if (type == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(14);
        }
        this.assertInsideChange();
        this.myRoots.get(type).add(root);
    }

    @Override
    public void removeAllRoots(@NotNull OrderRootType type) {
        if (type == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(15);
        }
        this.assertInsideChange();
        this.myRoots.get(type).clear();
    }

    @Override
    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType type) {
        if (root == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(16);
        }
        if (type == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(17);
        }
        this.assertInsideChange();
        this.myRoots.get(type).remove(root);
    }

    @Override
    public void removeAllRoots() {
        this.assertInsideChange();
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    @Override
    public void update() {
        this.assertInsideChange();
        for (CompositeProjectRoot myRoot : this.myRoots.values()) {
            myRoot.update();
        }
    }

    @Override
    public void readExternal(Element element) {
        this.assertInsideChange();
        for (PersistentOrderRootType persistentOrderRootType : OrderRootType.getAllPersistentTypes()) {
            this.read(element, persistentOrderRootType);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myRoots.values().forEach(root -> {
                if (this.myNoCopyJars) {
                    ProjectRootContainerImpl.setNoCopyJars(root);
                }
            });
            this.cacheFiles((Map<OrderRootType, VirtualFile[]>)new THashMap(this.myCachedFiles));
        });
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            VirtualFile[] newRoots;
            VirtualFile[] oldRoots;
            if (this.myRoots.get(orderRootType) == null) {
                LOG.error(orderRootType + " wasn't serialized");
                this.myRoots.put(orderRootType, new CompositeProjectRoot());
            }
            if (Comparing.equal(oldRoots = VirtualFile.EMPTY_ARRAY, newRoots = this.getRootFiles(orderRootType))) continue;
            this.fireRootsChanged();
            break;
        }
    }

    @Override
    public void writeExternal(Element element) {
        List<PersistentOrderRootType> allTypes = OrderRootType.getSortedRootTypes();
        for (PersistentOrderRootType type : allTypes) {
            this.write(element, type);
        }
    }

    void copyRootsFrom(@NotNull ProjectRootContainerImpl rootContainer) {
        if (rootContainer == null) {
            ProjectRootContainerImpl.$$$reportNull$$$0(18);
        }
        this.changeRoots(() -> {
            if (rootContainer == null) {
                ProjectRootContainerImpl.$$$reportNull$$$0(19);
            }
            this.removeAllRoots();
            for (OrderRootType rootType : OrderRootType.getAllTypes()) {
                ProjectRoot[] newRoots;
                for (ProjectRoot newRoot : newRoots = rootContainer.getRoots(rootType)) {
                    this.addRoot(newRoot, rootType);
                }
            }
        });
    }

    private static void setNoCopyJars(ProjectRoot root) {
        block3: {
            block2: {
                if (!(root instanceof SimpleProjectRoot)) break block2;
                String url = ((SimpleProjectRoot)root).getUrl();
                if (!"jar".equals(VirtualFileManager.extractProtocol(url))) break block3;
                String path = VirtualFileManager.extractPath(url);
                VirtualFileSystem fileSystem = StandardFileSystems.jar();
                if (!(fileSystem instanceof JarCopyingFileSystem)) break block3;
                ((JarCopyingFileSystem)((Object)fileSystem)).setNoCopyJarForPath(path);
                break block3;
            }
            if (root instanceof CompositeProjectRoot) {
                ProjectRoot[] roots;
                for (ProjectRoot root1 : roots = ((CompositeProjectRoot)root).getProjectRoots()) {
                    ProjectRootContainerImpl.setNoCopyJars(root1);
                }
            }
        }
    }

    private void read(Element element, PersistentOrderRootType type) {
        Element child;
        String sdkRootName = type.getSdkRootName();
        Element element2 = child = sdkRootName != null ? element.getChild(sdkRootName) : null;
        if (child == null) {
            this.myRoots.put(type, new CompositeProjectRoot());
            return;
        }
        List children = child.getChildren();
        if (children.size() != 1) {
            LOG.error(children);
        }
        CompositeProjectRoot root = (CompositeProjectRoot)CompositeProjectRoot.read((Element)children.get(0));
        this.myRoots.put(type, root);
    }

    private void write(Element roots, PersistentOrderRootType type) {
        String sdkRootName = type.getSdkRootName();
        if (sdkRootName != null) {
            Element e = new Element(sdkRootName);
            roots.addContent(e);
            Element root = CompositeProjectRoot.write(this.myRoots.get(type));
            e.addContent(root);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectRootContainerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootFiles";
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "changeRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cacheFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addProjectRootContainerListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectRootContainerListener";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyRootsFrom";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyRootsFrom$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

