/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.roots.impl.libraries.JarDirectoryWatcher;
import com.intellij.openapi.roots.impl.libraries.JarDirectoryWatcherFactory;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryImpl
extends TraceableDisposable
implements LibraryEx.ModifiableModelEx,
LibraryEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.impl.LibraryImpl");
    @NonNls
    public static final String LIBRARY_NAME_ATTR = "name";
    @NonNls
    public static final String LIBRARY_TYPE_ATTR = "type";
    @NonNls
    public static final String ROOT_PATH_ELEMENT = "root";
    @NonNls
    public static final String ELEMENT = "library";
    @NonNls
    public static final String PROPERTIES_ELEMENT = "properties";
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private static final String EXCLUDED_ROOTS_TAG = "excluded";
    private String myName;
    private final LibraryTable myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    @Nullable
    private VirtualFilePointerContainer myExcludedRoots;
    private final JarDirectories myJarDirectories;
    private final LibraryImpl mySource;
    private PersistentLibraryKind<?> myKind;
    private LibraryProperties myProperties;
    private final MyRootProviderImpl myRootProvider;
    @Nullable
    private final ModifiableRootModel myRootModel;
    private boolean myDisposed;
    private final Disposable myPointersDisposable;
    private final JarDirectoryWatcher myRootsWatcher;
    private final ProjectModelExternalSource myExternalSource;

    LibraryImpl(LibraryTable table, @NotNull Element element, ModifiableRootModel rootModel) throws InvalidDataException {
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(0);
        }
        this(table, rootModel, null, element.getAttributeValue(LIBRARY_NAME_ATTR), LibraryImpl.findPersistentLibraryKind(element), LibraryImpl.findExternalSource(element));
        this.readProperties(element);
        this.myJarDirectories.readExternal(element);
        this.readRoots(element);
        this.myRootsWatcher.updateWatchedRoots();
    }

    @Nullable
    private static ProjectModelExternalSource findExternalSource(Element element) {
        String externalSourceId = element.getAttributeValue("__external-system-id");
        return externalSourceId != null ? ExternalProjectSystemRegistry.getInstance().getSourceById(externalSourceId) : null;
    }

    @Nullable
    private static PersistentLibraryKind<?> findPersistentLibraryKind(@NotNull Element element) {
        String typeString;
        LibraryKind kind;
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(1);
        }
        if ((kind = LibraryKind.findById(typeString = element.getAttributeValue(LIBRARY_TYPE_ATTR))) != null && !(kind instanceof PersistentLibraryKind)) {
            LOG.error("Cannot load non-persistable library kind: " + typeString);
            return null;
        }
        return (PersistentLibraryKind)kind;
    }

    LibraryImpl(String name, @Nullable PersistentLibraryKind<?> kind, LibraryTable table, ModifiableRootModel rootModel, ProjectModelExternalSource externalSource) {
        this(table, rootModel, null, name, kind, externalSource);
        if (kind != null) {
            this.myProperties = kind.createDefaultProperties();
        }
    }

    private LibraryImpl(@NotNull LibraryImpl from, LibraryImpl newSource, ModifiableRootModel rootModel) {
        if (from == null) {
            LibraryImpl.$$$reportNull$$$0(2);
        }
        this(from.myLibraryTable, rootModel, newSource, from.myName, from.myKind, from.myExternalSource);
        from.checkDisposed();
        if (from.myKind != null && from.myProperties != null) {
            this.myProperties = this.myKind.createDefaultProperties();
            this.myProperties.loadState(from.myProperties.getState());
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            VirtualFilePointerContainer thisContainer = this.myRoots.get(rootType);
            VirtualFilePointerContainer thatContainer = from.myRoots.get(rootType);
            thisContainer.addAll(thatContainer);
        }
        if (from.myExcludedRoots != null) {
            this.myExcludedRoots = from.myExcludedRoots.clone(this.myPointersDisposable);
        }
        this.myJarDirectories.copyFrom(from.myJarDirectories);
    }

    private LibraryImpl(LibraryTable table, @Nullable ModifiableRootModel rootModel, LibraryImpl newSource, String name, @Nullable PersistentLibraryKind<?> kind, @Nullable ProjectModelExternalSource externalSource) {
        super(true);
        this.myJarDirectories = new JarDirectories();
        this.myRootProvider = new MyRootProviderImpl();
        this.myPointersDisposable = Disposer.newDisposable();
        this.myRootsWatcher = JarDirectoryWatcherFactory.getInstance().createWatcher(this.myJarDirectories, this.myRootProvider);
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.mySource = newSource;
        this.myKind = kind;
        this.myName = name;
        this.myExternalSource = externalSource;
        this.myRoots = this.initRoots();
        Disposer.register(this, this.myRootsWatcher);
    }

    private Set<OrderRootType> getAllRootTypes() {
        HashSet<OrderRootType> rootTypes = new HashSet<OrderRootType>();
        rootTypes.addAll(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            rootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        return rootTypes;
    }

    @Override
    public void dispose() {
        this.checkDisposed();
        this.myDisposed = true;
        this.kill(null);
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            this.throwDisposalError("'" + this.myName + "' already disposed:");
        }
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(3);
        }
        this.checkDisposed();
        VirtualFilePointerContainer result = this.myRoots.get(rootType);
        String[] stringArray = result == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : result.getUrls();
        if (stringArray == null) {
            LibraryImpl.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(5);
        }
        this.checkDisposed();
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                LibraryImpl.$$$reportNull$$$0(6);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        SmartList<VirtualFile> expanded = new SmartList<VirtualFile>();
        for (VirtualFile file : container.getFiles()) {
            if (file.isDirectory() && this.myJarDirectories.contains(rootType, file.getUrl())) {
                LibraryImpl.collectJarFiles(file, expanded, this.myJarDirectories.isRecursive(rootType, file.getUrl()));
                continue;
            }
            expanded.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(expanded);
        if (virtualFileArray == null) {
            LibraryImpl.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    public static void collectJarFiles(VirtualFile dir, final List<VirtualFile> container, boolean recursively) {
        VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, recursively ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                VirtualFile jarRoot;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file.getPath() + "!/")) != null) {
                    container.add(jarRoot);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$1", "visitFile"));
            }
        });
    }

    @Override
    public void setName(String name) {
        LOG.assertTrue(this.isWritable());
        this.myName = name;
    }

    @Override
    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        this.checkDisposed();
        LibraryImpl libraryImpl = new LibraryImpl(this, this, this.myRootModel);
        if (libraryImpl == null) {
            LibraryImpl.$$$reportNull$$$0(8);
        }
        return libraryImpl;
    }

    public Library cloneLibrary(RootModelImpl rootModel) {
        LOG.assertTrue(this.myLibraryTable == null);
        LibraryImpl clone = new LibraryImpl(this, null, (ModifiableRootModel)rootModel);
        clone.myRootsWatcher.updateWatchedRoots();
        return clone;
    }

    @Override
    public List<String> getInvalidRootUrls(OrderRootType type) {
        if (this.myDisposed) {
            return Collections.emptyList();
        }
        List<VirtualFilePointer> pointers = this.myRoots.get(type).getList();
        SmartList<String> invalidPaths = null;
        for (VirtualFilePointer pointer : pointers) {
            if (pointer.isValid()) continue;
            if (invalidPaths == null) {
                invalidPaths = new SmartList<String>();
            }
            invalidPaths.add(pointer.getUrl());
        }
        return ContainerUtil.notNullize(invalidPaths);
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        LOG.assertTrue(this.isWritable());
        this.myProperties = properties;
    }

    @Override
    @NotNull
    public RootProvider getRootProvider() {
        MyRootProviderImpl myRootProviderImpl = this.myRootProvider;
        if (myRootProviderImpl == null) {
            LibraryImpl.$$$reportNull$$$0(9);
        }
        return myRootProviderImpl;
    }

    private Map<OrderRootType, VirtualFilePointerContainer> initRoots() {
        Disposer.register(this, this.myPointersDisposable);
        com.intellij.util.containers.HashMap<OrderRootType, VirtualFilePointerContainer> result = new com.intellij.util.containers.HashMap<OrderRootType, VirtualFilePointerContainer>(4);
        for (OrderRootType rootType : this.getAllRootTypes()) {
            result.put(rootType, VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable));
        }
        return result;
    }

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myExternalSource;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.readName(element);
        this.readProperties(element);
        this.readRoots(element);
        this.myJarDirectories.readExternal(element);
        this.myRootsWatcher.updateWatchedRoots();
    }

    private void readProperties(Element element) {
        String typeId = element.getAttributeValue(LIBRARY_TYPE_ATTR);
        if (typeId == null) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById(typeId);
        if (this.myKind == null) {
            return;
        }
        this.myProperties = this.myKind.createDefaultProperties();
        Element propertiesElement = element.getChild(PROPERTIES_ELEMENT);
        if (propertiesElement != null) {
            ComponentSerializationUtil.loadComponentState(this.myProperties, propertiesElement);
        }
    }

    private void readName(Element element) {
        this.myName = element.getAttributeValue(LIBRARY_NAME_ATTR);
    }

    private void readRoots(Element element) throws InvalidDataException {
        for (OrderRootType rootType : this.getAllRootTypes()) {
            Element rootChild = element.getChild(rootType.name());
            if (rootChild == null) continue;
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            roots.readExternal(rootChild, ROOT_PATH_ELEMENT);
        }
        Element excludedRoot = element.getChild(EXCLUDED_ROOTS_TAG);
        if (excludedRoot != null) {
            this.getOrCreateExcludedRoots().readExternal(excludedRoot, ROOT_PATH_ELEMENT);
        }
    }

    private VirtualFilePointerContainer getOrCreateExcludedRoots() {
        if (this.myExcludedRoots == null) {
            this.myExcludedRoots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable);
        }
        return this.myExcludedRoots;
    }

    public static List<OrderRootType> sortRootTypes(Collection<OrderRootType> rootTypes) {
        ArrayList<OrderRootType> allTypes = new ArrayList<OrderRootType>(rootTypes);
        Collections.sort(allTypes, (o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        return allTypes;
    }

    @Override
    public void writeExternal(Element rootElement) {
        Module module;
        Object project;
        this.checkDisposed();
        Element element = new Element(ELEMENT);
        if (this.myName != null) {
            element.setAttribute(LIBRARY_NAME_ATTR, this.myName);
        }
        if (this.myKind != null) {
            Element propertiesElement;
            element.setAttribute(LIBRARY_TYPE_ATTR, this.myKind.getKindId());
            LOG.assertTrue(this.myProperties != null, "Properties is 'null' in library with kind " + this.myKind);
            Object state = this.myProperties.getState();
            if (state != null && !JDOMUtil.isEmpty(propertiesElement = XmlSerializer.serializeIfNotDefault(state, SERIALIZATION_FILTERS))) {
                element.addContent(propertiesElement.setName(PROPERTIES_ELEMENT));
            }
        }
        if (this.myExternalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)(project = (module = this.getModule()) == null ? (this.myLibraryTable instanceof ProjectLibraryTable ? ((ProjectLibraryTable)this.myLibraryTable).getProject() : null) : module.getProject()))) {
            element.setAttribute("__external-system-id", this.myExternalSource.getId());
        }
        ArrayList<OrderRootType> storableRootTypes = new ArrayList<OrderRootType>();
        storableRootTypes.addAll(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            storableRootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        for (OrderRootType rootType : LibraryImpl.sortRootTypes(storableRootTypes)) {
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            if (roots.size() == 0 && rootType.skipWriteIfEmpty()) continue;
            Element rootTypeElement = new Element(rootType.name());
            roots.writeExternal(rootTypeElement, ROOT_PATH_ELEMENT);
            element.addContent(rootTypeElement);
        }
        if (this.myExcludedRoots != null && this.myExcludedRoots.size() > 0) {
            Element excluded = new Element(EXCLUDED_ROOTS_TAG);
            this.myExcludedRoots.writeExternal(excluded, ROOT_PATH_ELEMENT);
            element.addContent(excluded);
        }
        this.myJarDirectories.writeExternal(element);
        rootElement.addContent(element);
    }

    private boolean isWritable() {
        return this.mySource != null;
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.myKind;
    }

    @Override
    public void addExcludedRoot(@NotNull String url) {
        VirtualFilePointerContainer roots;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(10);
        }
        if ((roots = this.getOrCreateExcludedRoots()).findByUrl(url) == null) {
            roots.add(url);
        }
    }

    @Override
    public boolean removeExcludedRoot(@NotNull String url) {
        VirtualFilePointer pointer;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(11);
        }
        if (this.myExcludedRoots != null && (pointer = this.myExcludedRoots.findByUrl(url)) != null) {
            this.myExcludedRoots.remove(pointer);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getExcludedRootUrls() {
        String[] stringArray = this.myExcludedRoots != null ? this.myExcludedRoots.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            LibraryImpl.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludedRoots() {
        VirtualFile[] virtualFileArray = this.myExcludedRoots != null ? this.myExcludedRoots.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            LibraryImpl.$$$reportNull$$$0(13);
        }
        return virtualFileArray;
    }

    @Override
    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setKind(PersistentLibraryKind<?> kind) {
        LOG.assertTrue(this.isWritable());
        LOG.assertTrue(this.myKind == null || this.myKind == kind, "Library kind cannot be changed from " + this.myKind + " to " + kind);
        this.myKind = kind;
        this.myProperties = kind.createDefaultProperties();
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(14);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(15);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(url);
    }

    @Override
    public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
        if (file == null) {
            LibraryImpl.$$$reportNull$$$0(16);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(17);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(file);
    }

    @Override
    public void addJarDirectory(@NotNull String url, boolean recursive) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(18);
        }
        this.addJarDirectory(url, recursive, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    @Override
    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive) {
        if (file == null) {
            LibraryImpl.$$$reportNull$$$0(19);
        }
        this.addJarDirectory(file, recursive, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    @Override
    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(20);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(21);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(url);
        this.myJarDirectories.add(rootType, url, recursive);
    }

    @Override
    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive, @NotNull OrderRootType rootType) {
        if (file == null) {
            LibraryImpl.$$$reportNull$$$0(22);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(23);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(file);
        this.myJarDirectories.add(rootType, file.getUrl(), recursive);
    }

    @Override
    public boolean isJarDirectory(@NotNull String url) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(24);
        }
        return this.isJarDirectory(url, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    @Override
    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(25);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(26);
        }
        return this.myJarDirectories.contains(rootType, url);
    }

    @Override
    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointerContainer container;
        VirtualFilePointer fp;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(27);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(28);
        }
        return (fp = (container = this.myRoots.get(rootType)).findByUrl(url)) != null && fp.isValid();
    }

    @Override
    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(29);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(30);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer byUrl = container.findByUrl(url);
        if (byUrl != null) {
            container.remove(byUrl);
            if (this.myExcludedRoots != null) {
                for (String excludedRoot : this.myExcludedRoots.getUrls()) {
                    VirtualFilePointer pointer;
                    if (this.isUnderRoots(excludedRoot) || (pointer = this.myExcludedRoots.findByUrl(excludedRoot)) == null) continue;
                    this.myExcludedRoots.remove(pointer);
                }
            }
            this.myJarDirectories.remove(rootType, url);
            return true;
        }
        return false;
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(31);
        }
        for (VirtualFilePointerContainer container : this.myRoots.values()) {
            if (!VfsUtilCore.isUnder(url, Arrays.asList(container.getUrls()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(32);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(33);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveUp(url);
    }

    @Override
    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(34);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(35);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveDown(url);
    }

    @Override
    public boolean isChanged() {
        return !this.mySource.equals(this);
    }

    private boolean areRootsChanged(LibraryImpl that) {
        return !that.equals(this);
    }

    public Library getSource() {
        return this.mySource;
    }

    @Override
    public void commit() {
        this.checkDisposed();
        if (this.isChanged()) {
            this.mySource.commit(this);
        }
        Disposer.dispose(this);
    }

    private void commit(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            LibraryImpl.$$$reportNull$$$0(36);
        }
        if (this.myLibraryTable != null) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (!Comparing.equal(fromModel.myName, this.myName)) {
            this.myName = fromModel.myName;
            if (this.myLibraryTable instanceof LibraryTableBase) {
                ((LibraryTableBase)this.myLibraryTable).fireLibraryRenamed(this);
            }
        }
        this.myKind = fromModel.getKind();
        this.myProperties = fromModel.myProperties;
        if (this.areRootsChanged(fromModel)) {
            this.disposeMyPointers();
            this.copyRootsFrom(fromModel);
            this.myJarDirectories.copyFrom(fromModel.myJarDirectories);
            this.myRootsWatcher.updateWatchedRoots();
            this.myRootProvider.fireRootSetChanged();
        }
    }

    private void copyRootsFrom(LibraryImpl fromModel) {
        HashMap<OrderRootType, VirtualFilePointerContainer> clonedRoots = ContainerUtil.newHashMap();
        for (Map.Entry<OrderRootType, VirtualFilePointerContainer> entry : fromModel.myRoots.entrySet()) {
            OrderRootType rootType = entry.getKey();
            VirtualFilePointerContainer container = entry.getValue();
            VirtualFilePointerContainer clone = container.clone(this.myPointersDisposable);
            clonedRoots.put(rootType, clone);
        }
        this.myRoots.clear();
        this.myRoots.putAll(clonedRoots);
        VirtualFilePointerContainer excludedRoots = fromModel.myExcludedRoots;
        this.myExcludedRoots = excludedRoots != null ? excludedRoots.clone(this.myPointersDisposable) : null;
    }

    private void disposeMyPointers() {
        for (VirtualFilePointerContainer container : new THashSet(this.myRoots.values())) {
            container.killAll();
        }
        if (this.myExcludedRoots != null) {
            this.myExcludedRoots.killAll();
        }
        Disposer.dispose(this.myPointersDisposable);
        Disposer.register(this, this.myPointersDisposable);
    }

    @Override
    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library = (LibraryImpl)o;
        if (!this.myJarDirectories.equals(library.myJarDirectories)) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(library.myName) : library.myName != null) {
            return false;
        }
        if (this.myRoots != null ? !this.myRoots.equals(library.myRoots) : library.myRoots != null) {
            return false;
        }
        if (this.myKind != null ? !this.myKind.equals(library.myKind) : library.myKind != null) {
            return false;
        }
        if (this.myProperties != null ? !this.myProperties.equals(library.myProperties) : library.myProperties != null) {
            return false;
        }
        return Comparing.equal(this.myExcludedRoots, library.myExcludedRoots);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myRoots != null ? this.myRoots.hashCode() : 0);
        result = 31 * result + this.myJarDirectories.hashCode();
        return result;
    }

    @NonNls
    public String toString() {
        return "Library: name:" + this.myName + "; jars:" + this.myJarDirectories + "; roots:" + this.myRoots.values();
    }

    @Nullable(value="will return non-null value only for module level libraries")
    public Module getModule() {
        return this.myRootModel == null ? null : this.myRootModel.getModule();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRootUrls";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findPersistentLibraryKind";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isJarDirectory";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "moveRootUp";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "moveRootDown";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRootProviderImpl
    extends RootProviderBaseImpl {
        private MyRootProviderImpl() {
        }

        @Override
        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                MyRootProviderImpl.$$$reportNull$$$0(0);
            }
            LinkedHashSet<String> originalUrls = new LinkedHashSet<String>(Arrays.asList(LibraryImpl.this.getUrls(rootType)));
            for (VirtualFile file : this.getFiles(rootType)) {
                originalUrls.add(file.getUrl());
            }
            String[] stringArray = ArrayUtil.toStringArray(originalUrls);
            if (stringArray == null) {
                MyRootProviderImpl.$$$reportNull$$$0(1);
            }
            return stringArray;
        }

        @Override
        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                MyRootProviderImpl.$$$reportNull$$$0(2);
            }
            VirtualFile[] virtualFileArray = LibraryImpl.this.getFiles(rootType);
            if (virtualFileArray == null) {
                MyRootProviderImpl.$$$reportNull$$$0(3);
            }
            return virtualFileArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

