/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.impl.cache.impl.id.FileTypeIdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer> {
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create("IdIndex");
    private final FileBasedIndex.InputFilter myInputFilter = file -> IdIndex.isIndexable(file.getFileType());
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty("idea.index.snapshot.mappings.enabled", true);
    private final DataExternalizer<Integer> myValueExternalizer = new DataExternalizer<Integer>(){

        @Override
        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.write((int)(value & 0xFF));
        }

        @Override
        public Integer read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return in.readByte() & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final KeyDescriptor<IdIndexEntry> myKeyDescriptor = new InlineKeyDescriptor<IdIndexEntry>(){

        @Override
        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        @Override
        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };
    private final DataIndexer<IdIndexEntry, Integer, FileContent> myIndexer = new DataIndexer<IdIndexEntry, Integer, FileContent>(){

        @Override
        @NotNull
        public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
            FileTypeIdIndexer indexer;
            if (inputData == null) {
                3.$$$reportNull$$$0(0);
            }
            if ((indexer = IdTableBuilding.getFileTypeIndexer(inputData.getFileType())) != null) {
                Map<IdIndexEntry, Integer> map = indexer.map(inputData);
                if (map == null) {
                    3.$$$reportNull$$$0(1);
                }
                return map;
            }
            Map<IdIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                3.$$$reportNull$$$0(2);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @Override
    public int getVersion() {
        return 16 + (ourSnapshotMappingsEnabled ? 255 : 0);
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    @NotNull
    public ID<IdIndexEntry, Integer> getName() {
        ID<IdIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            IdIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        DataIndexer<IdIndexEntry, Integer, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            IdIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        DataExternalizer<Integer> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            IdIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        KeyDescriptor<IdIndexEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            IdIndex.$$$reportNull$$$0(3);
        }
        return keyDescriptor;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            IdIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public static boolean isIndexable(FileType fileType) {
        return fileType instanceof LanguageFileType || fileType instanceof CustomSyntaxTableFileType || IdTableBuilding.isIdIndexerRegistered(fileType) || CacheBuilderRegistry.getInstance().getCacheBuilder(fileType) != null;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

