/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FCTSBackedLighterAST;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.util.Getter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.CharTable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileElement
extends LazyParseableElement
implements FileASTNode,
Getter<FileElement> {
    public static final FileElement[] EMPTY_ARRAY = new FileElement[0];
    private volatile CharTable myCharTable;
    private volatile boolean myDetached;
    private volatile Reference<List<CompositeElement>> myStubbedDescendants;

    @Override
    protected PsiElement createPsiNoLock() {
        return this.myDetached ? null : super.createPsiNoLock();
    }

    public void detachFromFile() {
        this.myDetached = true;
        this.clearPsi();
    }

    @Override
    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            FileElement.$$$reportNull$$$0(0);
        }
        return charTable;
    }

    @Override
    @NotNull
    public LighterAST getLighterAST() {
        IElementType contentType = this.getElementType();
        if (!this.isParsed() && contentType instanceof ILightStubFileElementType) {
            FCTSBackedLighterAST fCTSBackedLighterAST = new FCTSBackedLighterAST(this.getCharTable(), ((ILightStubFileElementType)contentType).parseContentsLight(this));
            if (fCTSBackedLighterAST == null) {
                FileElement.$$$reportNull$$$0(1);
            }
            return fCTSBackedLighterAST;
        }
        TreeBackedLighterAST treeBackedLighterAST = new TreeBackedLighterAST(this);
        if (treeBackedLighterAST == null) {
            FileElement.$$$reportNull$$$0(2);
        }
        return treeBackedLighterAST;
    }

    public FileElement(@NotNull IElementType type, CharSequence text2) {
        if (type == null) {
            FileElement.$$$reportNull$$$0(3);
        }
        super(type, text2);
        this.myCharTable = new CharTableImpl();
    }

    @Deprecated
    public FileElement(IElementType type) {
        super(type, null);
        this.myCharTable = new CharTableImpl();
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        return (PsiManagerEx)this.getPsi().getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(@NotNull CharTable table) {
        if (table == null) {
            FileElement.$$$reportNull$$$0(4);
        }
        this.myCharTable = table;
    }

    @Override
    public FileElement get() {
        return this;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myStubbedDescendants = null;
    }

    @NotNull
    public final List<CompositeElement> getStubbedDescendants() {
        List<CompositeElement> result = SoftReference.dereference(this.myStubbedDescendants);
        if (result == null) {
            IStubFileElementType type = ((PsiFileImpl)this.getPsi()).getElementTypeForStubBuilder();
            if (type == null) {
                List<CompositeElement> list = Collections.emptyList();
                if (list == null) {
                    FileElement.$$$reportNull$$$0(5);
                }
                return list;
            }
            result = this.calcStubbedDescendants(type.getBuilder());
            this.myStubbedDescendants = this.getManager().isBatchFilesProcessingMode() ? new WeakReference<List<CompositeElement>>(result) : new SoftReference<List<CompositeElement>>(result);
        }
        List<CompositeElement> list = result;
        if (list == null) {
            FileElement.$$$reportNull$$$0(6);
        }
        return list;
    }

    private List<CompositeElement> calcStubbedDescendants(final StubBuilder builder) {
        final ArrayList<CompositeElement> result = new ArrayList<CompositeElement>();
        result.add(this);
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitComposite(CompositeElement node) {
                CompositeElement parent = node.getTreeParent();
                if (parent != null && builder.skipChildProcessingWhenBuildingStubs(parent, node)) {
                    return;
                }
                IElementType type = node.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node)) {
                    result.add(node);
                }
                super.visitNode(node);
            }
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLighterAST";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/FileElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedDescendants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCharTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

