/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");
    private static final TokenSet BRACKETS = TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET);

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(0);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(1);
        }
        return JavaSharedImplUtil.getType(typeElement, anchor, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(3);
        }
        PsiType type = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations : allAnnotations) {
            type = type.createArrayType().annotate(TypeAnnotationProvider.Static.create(annotations));
        }
        return type;
    }

    private static List<PsiAnnotation[]> collectAnnotations(PsiElement anchor, PsiAnnotation stopAt) {
        List<PsiAnnotation[]> annotations = ContainerUtil.newSmartList();
        List current = null;
        boolean found = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = ContainerUtil.newSmartList();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                annotations.add(ContainerUtil.toArray(current, PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop) continue;
                return annotations;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.RBRACKET)) break;
        }
        return !found || stop ? null : annotations;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type, @Nullable PsiModifierList modifierList) {
        PsiAnnotation[] annotations;
        if (type == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(4);
        }
        if (modifierList != null && (annotations = modifierList.getAnnotations()).length > 0) {
            TypeAnnotationProvider original = modifierList.getParent() instanceof PsiMethod ? type.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
            FilteringTypeAnnotationProvider provider = new FilteringTypeAnnotationProvider(annotations, original);
            if (type instanceof PsiArrayType) {
                Stack<PsiArrayType> types = new Stack<PsiArrayType>();
                do {
                    types.push((PsiArrayType)type);
                } while ((type = ((PsiArrayType)type).getComponentType()) instanceof PsiArrayType);
                type = type.annotate(provider);
                while (!types.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types.pop();
                    type = t instanceof PsiEllipsisType ? new PsiEllipsisType(type, t.getAnnotations()) : new PsiArrayType(type, t.getAnnotations());
                }
                PsiType psiType = type;
                if (psiType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(5);
                }
                return psiType;
            }
            if (type instanceof PsiDisjunctionType) {
                ArrayList<PsiType> components = ContainerUtil.newArrayList(((PsiDisjunctionType)type).getDisjunctions());
                components.set(0, ((PsiType)components.get(0)).annotate(provider));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type).newDisjunctionType(components);
                if (psiDisjunctionType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(6);
                }
                return psiDisjunctionType;
            }
            PsiType psiType = type.annotate(provider);
            if (psiType == null) {
                JavaSharedImplUtil.$$$reportNull$$$0(7);
            }
            return psiType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(8);
        }
        return psiType;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable) {
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(9);
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type = typeElement.getNode();
        ASTNode name = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                variableElement.removeChild(element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type.clone();
            for (int i2 = 0; i2 < arrayCount; ++i2) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type));
            variableElement.replaceChild(type, newType);
        }
    }

    public static void setInitializer(PsiVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        PsiExpression oldInitializer = variable.getInitializer();
        if (oldInitializer != null) {
            oldInitializer.delete();
        }
        if (initializer == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable;
        }
        variable.addAfter(initializer, eq.getPsi());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBrackets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(PsiAnnotation[] candidates, TypeAnnotationProvider originalProvider) {
            this.myCandidates = candidates;
            this.myOriginalProvider = originalProvider;
        }

        @Override
        @NotNull
        public PsiAnnotation[] getAnnotations() {
            PsiAnnotation[] result = this.myCache;
            if (result == null) {
                List<PsiAnnotation> filtered = JBIterable.of(this.myCandidates).filter(annotation -> AnnotationTargetUtil.isTypeAnnotation(annotation)).append((PsiAnnotation)this.myOriginalProvider.getAnnotations()).toList();
                result = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(new PsiAnnotation[filtered.size()]);
                this.myCache = result;
            }
            if (result == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(0);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider", "getAnnotations"));
        }
    }
}

