/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractedParameter {
    @NotNull
    public final List<PsiReferenceExpression> myPatternUsages;
    @NotNull
    public final PsiVariable myPatternVariable;
    @NotNull
    public final PsiReferenceExpression myCandidateUsage;
    @NotNull
    public final PsiVariable myCandidateVariable;
    @NotNull
    public final PsiType myType;

    ExtractedParameter(@NotNull PsiVariable patternVariable, @NotNull PsiReferenceExpression patternUsage, @NotNull PsiVariable candidateVariable, @NotNull PsiReferenceExpression candidateUsage, @NotNull PsiType type) {
        if (patternVariable == null) {
            ExtractedParameter.$$$reportNull$$$0(0);
        }
        if (patternUsage == null) {
            ExtractedParameter.$$$reportNull$$$0(1);
        }
        if (candidateVariable == null) {
            ExtractedParameter.$$$reportNull$$$0(2);
        }
        if (candidateUsage == null) {
            ExtractedParameter.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ExtractedParameter.$$$reportNull$$$0(4);
        }
        this.myPatternUsages = new ArrayList<PsiReferenceExpression>();
        this.myPatternVariable = patternVariable;
        this.myPatternUsages.add(patternUsage);
        this.myCandidateVariable = candidateVariable;
        this.myCandidateUsage = candidateUsage;
        this.myType = type;
    }

    public static boolean match(PsiElement pattern, PsiElement candidate, @NotNull List<ExtractedParameter> parameters) {
        if (parameters == null) {
            ExtractedParameter.$$$reportNull$$$0(5);
        }
        if (pattern instanceof PsiReferenceExpression && candidate instanceof PsiReferenceExpression) {
            PsiReferenceExpression patternUsage = (PsiReferenceExpression)pattern;
            PsiReferenceExpression candidateUsage = (PsiReferenceExpression)candidate;
            PsiElement resolvedPattern = patternUsage.resolve();
            PsiElement resolvedCandidate = candidateUsage.resolve();
            if (resolvedPattern instanceof PsiVariable && resolvedCandidate instanceof PsiVariable) {
                PsiVariable patternVariable = (PsiVariable)resolvedPattern;
                PsiVariable candidateVariable = (PsiVariable)resolvedCandidate;
                if (ExtractedParameter.isStaticOrLocal(patternVariable) && ExtractedParameter.isStaticOrLocal(candidateVariable)) {
                    for (ExtractedParameter parameter : parameters) {
                        boolean samePattern = resolvedPattern.equals(parameter.myPatternVariable);
                        boolean sameCandidate = resolvedCandidate.equals(parameter.myCandidateVariable);
                        if (samePattern && sameCandidate) {
                            parameter.myPatternUsages.add(patternUsage);
                            return true;
                        }
                        if (!samePattern && !sameCandidate) continue;
                        return false;
                    }
                    PsiType type = ExtractedParameter.getParameterType(patternVariable, candidateVariable);
                    if (type != null) {
                        parameters.add(new ExtractedParameter(patternVariable, patternUsage, candidateVariable, candidateUsage, type));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static List<Match> getCompatibleMatches(List<Match> matches, PsiElement[] pattern) {
        Set<PsiVariable> patternVariables = null;
        ArrayList<Match> result = new ArrayList<Match>();
        for (Match match : matches) {
            List<ExtractedParameter> parameters = match.getExtractedParameters();
            if (patternVariables == null) {
                patternVariables = ExtractedParameter.getPatternVariables(parameters);
                if (ExtractedParameter.containsModifiedField(pattern, patternVariables)) {
                    return Collections.emptyList();
                }
                result.add(match);
                continue;
            }
            if (!patternVariables.equals(ExtractedParameter.getPatternVariables(parameters))) continue;
            result.add(match);
        }
        return result;
    }

    private static boolean containsModifiedField(PsiElement[] pattern, Set<PsiVariable> variables) {
        Set fields = ((StreamEx)StreamEx.of(variables).select(PsiField.class).filter(field -> !field.hasModifierProperty("final"))).toSet();
        if (!fields.isEmpty()) {
            FieldModificationVisitor visitor = new FieldModificationVisitor(fields);
            for (PsiElement element : pattern) {
                element.accept(visitor);
                if (!visitor.myModified) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    static Set<PsiVariable> getPatternVariables(@Nullable List<ExtractedParameter> parameters) {
        if (parameters != null) {
            Set<PsiVariable> set = ContainerUtil.map2Set(parameters, parameter -> parameter.myPatternVariable);
            if (set == null) {
                ExtractedParameter.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<PsiVariable> set = Collections.emptySet();
        if (set == null) {
            ExtractedParameter.$$$reportNull$$$0(7);
        }
        return set;
    }

    static boolean isStaticOrLocal(@NotNull PsiVariable variable) {
        if (variable == null) {
            ExtractedParameter.$$$reportNull$$$0(8);
        }
        if (variable instanceof PsiField && variable.hasModifierProperty("static")) {
            return true;
        }
        return variable instanceof PsiLocalVariable || variable instanceof PsiParameter;
    }

    @Nullable
    static PsiType getParameterType(@NotNull PsiVariable patternVariable, @NotNull PsiVariable candidateVariable) {
        PsiType candidateType;
        PsiType patternType;
        if (patternVariable == null) {
            ExtractedParameter.$$$reportNull$$$0(9);
        }
        if (candidateVariable == null) {
            ExtractedParameter.$$$reportNull$$$0(10);
        }
        if ((patternType = patternVariable.getType()).isAssignableFrom(candidateType = candidateVariable.getType())) {
            return patternType;
        }
        if (candidateType.isAssignableFrom(patternType)) {
            return candidateType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternVariable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternUsage";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateVariable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateUsage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/ExtractedParameter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/ExtractedParameter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStaticOrLocal";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldModificationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> myFields;
        private boolean myModified;

        public FieldModificationVisitor(Set<PsiField> fields) {
            this.myFields = fields;
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            this.visitModifiedExpression(expression.getLExpression());
        }

        @Override
        public void visitUnaryExpression(PsiUnaryExpression expression) {
            super.visitUnaryExpression(expression);
            IElementType op = expression.getOperationTokenType();
            if (op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) {
                this.visitModifiedExpression(expression.getOperand());
            }
        }

        private void visitModifiedExpression(PsiExpression modifiedExpression) {
            PsiField field;
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown(modifiedExpression);
            if (expression instanceof PsiReferenceExpression && (field = ObjectUtils.tryCast(((PsiReferenceExpression)expression).resolve(), PsiField.class)) != null && this.myFields.contains(field)) {
                this.myModified = true;
                this.stopWalking();
            }
        }
    }
}

