/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class LimitedPool<T> {
    private final int maxCapacity;
    private final ObjectFactory<T> factory;
    private Object[] storage;
    private int index;

    public LimitedPool(int maxCapacity, @NotNull ObjectFactory<T> factory) {
        if (factory == null) {
            LimitedPool.$$$reportNull$$$0(0);
        }
        this.maxCapacity = maxCapacity;
        this.factory = factory;
        this.storage = new Object[10];
    }

    @NotNull
    public T alloc() {
        if (this.index == 0) {
            T t = this.factory.create();
            if (t == null) {
                LimitedPool.$$$reportNull$$$0(1);
            }
            return t;
        }
        int i2 = --this.index;
        Object result = this.storage[i2];
        this.storage[i2] = null;
        Object object = result;
        if (object == null) {
            LimitedPool.$$$reportNull$$$0(2);
        }
        return (T)object;
    }

    public void recycle(@NotNull T t) {
        if (t == null) {
            LimitedPool.$$$reportNull$$$0(3);
        }
        this.factory.cleanup(t);
        if (this.index >= this.maxCapacity) {
            return;
        }
        this.ensureCapacity();
        this.storage[this.index++] = t;
    }

    private void ensureCapacity() {
        if (this.storage.length <= this.index) {
            int newCapacity = Math.min(this.maxCapacity, this.storage.length * 3 / 2);
            this.storage = ArrayUtil.realloc(this.storage, newCapacity, ArrayUtil.OBJECT_ARRAY_FACTORY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/LimitedPool";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/LimitedPool";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "alloc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recycle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ObjectFactory<T> {
        @NotNull
        public T create();

        public void cleanup(@NotNull T var1);
    }
}

