/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementsWithoutDefaultInspection
extends BaseInspection {
    public boolean m_ignoreFullyCoveredEnums = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statements.without.default.display.name", new Object[0]);
        if (string == null) {
            SwitchStatementsWithoutDefaultInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("SwitchStatementWithoutDefaultBranch" == null) {
            SwitchStatementsWithoutDefaultInspection.$$$reportNull$$$0(1);
        }
        return "SwitchStatementWithoutDefaultBranch";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("switch.statements.without.default.problem.descriptor", new Object[0]);
        if (string == null) {
            SwitchStatementsWithoutDefaultInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("switch.statement.without.default.ignore.option", new Object[0]), this, "m_ignoreFullyCoveredEnums");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementsWithoutDefaultVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SwitchStatementsWithoutDefaultVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementsWithoutDefaultVisitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                SwitchStatementsWithoutDefaultVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            if (this.switchStatementHasDefault(statement)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private boolean switchStatementHasDefault(PsiSwitchStatement statement) {
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return true;
            }
            Collection<PsiSwitchLabelStatement> labelStatements = PsiTreeUtil.findChildrenOfType(body, PsiSwitchLabelStatement.class);
            if (labelStatements.isEmpty() || labelStatements.stream().anyMatch(PsiSwitchLabelStatement::isDefaultCase)) {
                return true;
            }
            return SwitchStatementsWithoutDefaultInspection.this.m_ignoreFullyCoveredEnums && this.switchStatementIsFullyCoveredEnum(statement, labelStatements.size());
        }

        private boolean switchStatementIsFullyCoveredEnum(PsiSwitchStatement statement, int branchCount) {
            PsiExpression expression = statement.getExpression();
            if (expression == null) {
                return true;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            return aClass != null && aClass.isEnum() && ControlFlowUtils.hasChildrenOfTypeCount(aClass, branchCount, PsiEnumConstant.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection$SwitchStatementsWithoutDefaultVisitor", "visitSwitchStatement"));
        }
    }
}

