/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicClassDependencyInspection
extends BaseGlobalInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cyclic.class.dependency.display.name", new Object[0]);
        if (string == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        String errorString;
        RefClass[] classes;
        if (refEntity == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(1);
        }
        if (analysisScope == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(2);
        }
        if (inspectionManager == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(3);
        }
        if (globalInspectionContext == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        if (refClass.isAnonymous() || refClass.isLocalClass() || refClass.isSyntheticJSP()) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateTransitiveDependenciesForClass(refClass);
        Set<RefClass> dependents = DependencyUtils.calculateTransitiveDependentsForClass(refClass);
        HashSet<RefClass> mutualDependents = new HashSet<RefClass>(dependencies);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        if (numMutualDependents == 1) {
            classes = mutualDependents.toArray(new RefClass[1]);
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.1.problem.descriptor", refEntity.getName(), classes[0].getExternalName());
        } else if (numMutualDependents == 2) {
            classes = mutualDependents.toArray(new RefClass[2]);
            Arrays.sort(classes, RefEntityAlphabeticalComparator.getInstance());
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.2.problem.descriptor", refEntity.getName(), classes[0].getExternalName(), classes[1].getExternalName());
        } else {
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.problem.descriptor", refEntity.getName(), numMutualDependents);
        }
        PsiClass aClass = refClass.getElement();
        if (aClass == null) {
            return null;
        }
        PsiIdentifier anchor = aClass.getNameIdentifier();
        if (anchor == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor((PsiElement)anchor, errorString, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dependency/CyclicClassDependencyInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dependency/CyclicClassDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

