/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnOfInnerClassInspection
extends BaseInspection {
    public boolean ignoreNonPublic = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.of.inner.class.display.name", new Object[0]);
        if (string == null) {
            ReturnOfInnerClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        switch ((ClassType)((Object)infos[0])) {
            case ANONYMOUS_CLASS: {
                String string = InspectionGadgetsBundle.message("return.of.anonymous.class.problem.descriptor", new Object[0]);
                if (string == null) {
                    ReturnOfInnerClassInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            case LOCAL_CLASS: {
                PsiClass aClass = (PsiClass)infos[1];
                String string = InspectionGadgetsBundle.message("return.of.local.class.problem.descriptor", aClass.getName());
                if (string == null) {
                    ReturnOfInnerClassInspection.$$$reportNull$$$0(2);
                }
                return string;
            }
            case INNER_CLASS: {
                PsiClass aClass = (PsiClass)infos[1];
                String string = InspectionGadgetsBundle.message("return.of.inner.class.problem.descriptor", aClass.getName());
                if (string == null) {
                    ReturnOfInnerClassInspection.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("return.of.inner.class.ignore.non.public.option", new Object[0]), this, "ignoreNonPublic");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfInnerClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/ReturnOfInnerClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ReturnOfInnerClassVisitor
    extends BaseInspectionVisitor {
        private ReturnOfInnerClassVisitor() {
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            super.visitReturnStatement(statement);
            PsiExpression expression = ParenthesesUtils.stripParentheses(statement.getReturnValue());
            if (expression == null) {
                return;
            }
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, true, PsiLambdaExpression.class);
            if (method == null || method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                return;
            }
            if (ReturnOfInnerClassInspection.this.ignoreNonPublic && (method.hasModifierProperty("protected") || method.hasModifierProperty("packageLocal"))) {
                return;
            }
            if (expression instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)expression).getAnonymousClass()) != null) {
                this.registerStatementError(statement, new Object[]{ClassType.ANONYMOUS_CLASS});
                return;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (PsiUtil.isLocalClass(aClass)) {
                this.registerStatementError(statement, new Object[]{ClassType.LOCAL_CLASS, aClass});
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null || aClass.hasModifierProperty("static")) {
                return;
            }
            this.registerStatementError(statement, new Object[]{ClassType.INNER_CLASS, aClass});
        }
    }

    private static enum ClassType {
        ANONYMOUS_CLASS,
        LOCAL_CLASS,
        INNER_CLASS;

    }
}

