/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralsToDecimalsFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroesFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OctalAndDecimalIntegersMixedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("OctalAndDecimalIntegersInSameArray" == null) {
            OctalAndDecimalIntegersMixedInspection.$$$reportNull$$$0(0);
        }
        return "OctalAndDecimalIntegersInSameArray";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("octal.and.decimal.integers.in.same.array.display.name", new Object[0]);
        if (string == null) {
            OctalAndDecimalIntegersMixedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("octal.and.decimal.integers.in.same.array.problem.descriptor", new Object[0]);
        if (string == null) {
            OctalAndDecimalIntegersMixedInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ConvertOctalLiteralsToDecimalsFix(), new RemoveLeadingZeroesFix()};
        if (inspectionGadgetsFixArray == null) {
            OctalAndDecimalIntegersMixedInspection.$$$reportNull$$$0(3);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OctalAndDecimalIntegersMixedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/OctalAndDecimalIntegersMixedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class OctalAndDecimalIntegersMixedVisitor
    extends BaseInspectionVisitor {
        private OctalAndDecimalIntegersMixedVisitor() {
        }

        @Override
        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiExpression[] initializers = expression.getInitializers();
            boolean hasDecimalLiteral = false;
            boolean hasOctalLiteral = false;
            for (PsiExpression initializer : initializers) {
                if (!((initializer = ParenthesesUtils.stripParentheses(initializer)) instanceof PsiLiteralExpression)) continue;
                PsiLiteralExpression literal = (PsiLiteralExpression)initializer;
                if (OctalAndDecimalIntegersMixedVisitor.isDecimalLiteral(literal)) {
                    hasDecimalLiteral = true;
                }
                if (!ExpressionUtils.isOctalLiteral(literal)) continue;
                hasOctalLiteral = true;
            }
            if (hasOctalLiteral && hasDecimalLiteral) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private static boolean isDecimalLiteral(PsiLiteralExpression literal) {
            PsiType type = literal.getType();
            if (!PsiType.INT.equals(type) && !PsiType.LONG.equals(type)) {
                return false;
            }
            String text2 = literal.getText();
            return text2.charAt(0) != '0';
        }
    }
}

