/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8MigrationUtils {
    @Nullable
    private static MapCheckCondition tryExtract(PsiExpression fullCondition, @Nullable PsiStatement statement, boolean treatGetNullAsContainsKey) {
        PsiMethodCallExpression call;
        PsiExpression condition = PsiUtil.skipParenthesizedExprDown(fullCondition);
        boolean negated = false;
        while (condition != null && BoolUtils.isNegation(condition)) {
            negated ^= true;
            condition = BoolUtils.getNegated(condition);
        }
        if (condition == null) {
            return null;
        }
        PsiReferenceExpression valueReference = null;
        boolean containsKey = false;
        if (condition instanceof PsiBinaryExpression) {
            negated ^= ((PsiBinaryExpression)condition).getOperationTokenType().equals(JavaTokenType.EQEQ);
            PsiExpression value = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)condition);
            if (value instanceof PsiReferenceExpression && statement != null) {
                valueReference = (PsiReferenceExpression)value;
                PsiElement previous = PsiTreeUtil.skipWhitespacesAndCommentsBackward(statement);
                call = Java8MigrationUtils.tryExtractMapGetCall(valueReference, previous);
            } else {
                call = Java8MigrationUtils.extractMapMethodCall(value, "get");
            }
        } else {
            call = Java8MigrationUtils.extractMapMethodCall(condition, "containsKey");
            containsKey = true;
        }
        if (call == null) {
            return null;
        }
        PsiExpression mapExpression = call.getMethodExpression().getQualifierExpression();
        if (mapExpression == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression keyExpression = args[0];
        return new MapCheckCondition(valueReference, mapExpression, keyExpression, fullCondition, negated, containsKey, treatGetNullAsContainsKey);
    }

    @Nullable
    @Contract(value="_, null -> null")
    private static PsiMethodCallExpression tryExtractMapGetCall(PsiReferenceExpression target, PsiElement element) {
        PsiExpression lValue;
        PsiElement lastDeclaration;
        PsiDeclarationStatement declaration;
        PsiElement[] elements;
        if (element instanceof PsiDeclarationStatement && (elements = (declaration = (PsiDeclarationStatement)element).getDeclaredElements()).length > 0 && (lastDeclaration = elements[elements.length - 1]) instanceof PsiLocalVariable && target.isReferenceTo(lastDeclaration)) {
            PsiLocalVariable var = (PsiLocalVariable)lastDeclaration;
            return Java8MigrationUtils.extractMapMethodCall(var.getInitializer(), "get");
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && (lValue = assignment.getLExpression()) instanceof PsiReferenceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(target, lValue)) {
            return Java8MigrationUtils.extractMapMethodCall(assignment.getRExpression(), "get");
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    public static PsiMethodCallExpression extractMapMethodCall(PsiExpression expression, @NotNull String expectedName) {
        if (expectedName == null) {
            Java8MigrationUtils.$$$reportNull$$$0(0);
        }
        if (!((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        if (!expectedName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        Object[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            superMethods = new PsiMethod[]{method};
        }
        return ((StreamEx)StreamEx.of((Object[])superMethods).map(PsiMember::getContainingClass).nonNull()).map(PsiClass::getQualifiedName).has((Object)"java.util.Map") ? methodCallExpression : null;
    }

    @Nullable
    public static PsiExpression extractLambdaCandidate(MapCheckCondition condition, PsiStatement statement) {
        PsiAssignmentExpression assignment;
        PsiExpression putValue = Java8MigrationUtils.extractPutValue(condition, statement);
        if (putValue != null) {
            assignment = ExpressionUtils.getAssignment(putValue);
        } else {
            if (!(statement instanceof PsiBlockStatement)) {
                return null;
            }
            PsiStatement[] statements = ((PsiBlockStatement)statement).getCodeBlock().getStatements();
            if (statements.length != 2) {
                return null;
            }
            putValue = Java8MigrationUtils.extractPutValue(condition, statements[1]);
            if (!condition.isValueReference(putValue)) {
                return null;
            }
            assignment = ExpressionUtils.getAssignment(statements[0]);
        }
        if (assignment == null) {
            return null;
        }
        PsiExpression lambdaCandidate = assignment.getRExpression();
        if (lambdaCandidate == null || !condition.isValueReference(assignment.getLExpression())) {
            return null;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda(lambdaCandidate)) {
            return null;
        }
        return lambdaCandidate;
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static PsiExpression extractPutValue(MapCheckCondition condition, PsiStatement statement) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiMethodCallExpression putCall = Java8MigrationUtils.extractMapMethodCall(((PsiExpressionStatement)statement).getExpression(), "put");
        if (putCall == null) {
            return null;
        }
        PsiExpression[] putArguments = putCall.getArgumentList().getExpressions();
        return putArguments.length == 2 && condition.isMap(putCall.getMethodExpression().getQualifierExpression()) && condition.isKey(putArguments[0]) ? putArguments[1] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedName", "com/siyeh/ig/psiutils/Java8MigrationUtils", "extractMapMethodCall"));
    }

    public static class MapCheckCondition {
        @Nullable
        private final PsiReferenceExpression myValueReference;
        private final PsiExpression myMapExpression;
        private final PsiExpression myKeyExpression;
        private final PsiExpression myFullCondition;
        private final boolean myNegated;
        private final boolean myContainsKey;
        private final boolean myTreatGetNullAsContainsKey;

        private MapCheckCondition(@Nullable PsiReferenceExpression valueReference, PsiExpression mapExpression, PsiExpression keyExpression, PsiExpression fullCondition, boolean negated, boolean containsKey, boolean treatGetNullAsContainsKey) {
            this.myValueReference = valueReference;
            this.myMapExpression = mapExpression;
            this.myKeyExpression = keyExpression;
            this.myFullCondition = fullCondition;
            this.myNegated = negated;
            this.myContainsKey = containsKey;
            this.myTreatGetNullAsContainsKey = treatGetNullAsContainsKey;
        }

        @Nullable
        public PsiReferenceExpression getValueReference() {
            return this.myValueReference;
        }

        @Nullable
        public PsiExpression getMapExpression() {
            return this.myMapExpression;
        }

        public PsiExpression getKeyExpression() {
            return this.myKeyExpression;
        }

        public boolean isContainsKey() {
            return this.myContainsKey || this.myTreatGetNullAsContainsKey;
        }

        public boolean isGetNull() {
            return !this.myContainsKey || this.myTreatGetNullAsContainsKey;
        }

        @Contract(value="null -> false")
        public boolean isMap(PsiElement element) {
            return element != null && PsiEquivalenceUtil.areElementsEquivalent(this.myMapExpression, element);
        }

        @Contract(value="null -> false")
        public boolean isKey(PsiElement element) {
            return element != null && PsiEquivalenceUtil.areElementsEquivalent(this.myKeyExpression, element);
        }

        public PsiMethodCallExpression extractGetCall(PsiElement element) {
            if (!(element instanceof PsiExpression)) {
                return null;
            }
            PsiMethodCallExpression getCall = Java8MigrationUtils.extractMapMethodCall((PsiExpression)element, "get");
            if (getCall == null) {
                return null;
            }
            PsiExpression[] args = getCall.getArgumentList().getExpressions();
            return args.length == 1 && this.isKey(args[0]) && this.isMap(getCall.getMethodExpression().getQualifierExpression()) ? getCall : null;
        }

        @Contract(value="null -> false")
        public boolean isValueReference(PsiElement element) {
            return element != null && this.myValueReference != null && PsiEquivalenceUtil.areElementsEquivalent(element, this.myValueReference);
        }

        public <T extends PsiElement> T getExistsBranch(T thenBranch, T elseBranch) {
            return this.myNegated ? elseBranch : thenBranch;
        }

        public <T extends PsiElement> T getNoneBranch(T thenBranch, T elseBranch) {
            return this.myNegated ? thenBranch : elseBranch;
        }

        public PsiVariable extractDeclaration() {
            if (this.myValueReference == null) {
                return null;
            }
            return PsiTreeUtil.getParentOfType((PsiElement)this.myKeyExpression, PsiVariable.class, true, PsiStatement.class);
        }

        public boolean hasVariable() {
            if (this.myValueReference == null) {
                return false;
            }
            PsiVariable var = this.extractDeclaration();
            return var == null || ReferencesSearch.search(var).findAll().size() != 1;
        }

        public PsiMethodCallExpression getCheckCall() {
            return PsiTreeUtil.getParentOfType((PsiElement)this.myMapExpression, PsiMethodCallExpression.class);
        }

        public PsiExpression getFullCondition() {
            return this.myFullCondition;
        }

        public void register(ProblemsHolder holder, boolean informationLevel, LocalQuickFix fix, String methodName) {
            holder.registerProblem((PsiElement)this.getFullCondition(), QuickFixBundle.message("java.8.map.api.inspection.description", methodName), informationLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
        }

        public boolean isMapValueType(@Nullable PsiType type) {
            if (type == null) {
                return false;
            }
            PsiType mapExpressionType = this.myMapExpression.getType();
            PsiType valueTypeParameter = PsiUtil.substituteTypeParameter(mapExpressionType, "java.util.Map", 1, false);
            return valueTypeParameter != null && valueTypeParameter.isAssignableFrom(type);
        }

        @Contract(value="null, _ -> null")
        public static MapCheckCondition fromConditional(PsiElement conditional, boolean treatGetNullAsContainsKey) {
            if (conditional instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)conditional;
                return Java8MigrationUtils.tryExtract(ifStatement.getCondition(), ifStatement, treatGetNullAsContainsKey);
            }
            if (conditional instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)conditional;
                PsiElement parent = ternary.getParent().getParent();
                return Java8MigrationUtils.tryExtract(ternary.getCondition(), parent instanceof PsiStatement ? (PsiStatement)parent : null, treatGetNullAsContainsKey);
            }
            return null;
        }
    }
}

