/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class EmptySynchronizedStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.synchronized.statement.display.name", new Object[0]);
        if (string == null) {
            EmptySynchronizedStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.synchronized.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptySynchronizedStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptySynchronizedStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/EmptySynchronizedStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EmptySynchronizedStatementVisitor
    extends BaseInspectionVisitor {
        private EmptySynchronizedStatementVisitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                EmptySynchronizedStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiCodeBlock body = statement.getBody();
            if (!ControlFlowUtils.isEmptyCodeBlock(body)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/EmptySynchronizedStatementInspection$EmptySynchronizedStatementVisitor", "visitSynchronizedStatement"));
        }
    }
}

