/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermuteArgumentsFix
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(PermuteArgumentsFix.class);
    private final PsiCall myCall;
    private final PsiCall myPermutation;

    private PermuteArgumentsFix(@NotNull PsiCall call, @NotNull PsiCall permutation) {
        if (call == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(0);
        }
        if (permutation == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(1);
        }
        this.myCall = call;
        this.myPermutation = permutation;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("permute.arguments", new Object[0]);
        if (string == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(4);
        }
        return !project.isDisposed() && this.myCall.isValid() && this.myCall.getManager().isInProject(this.myCall);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(5);
        }
        this.myCall.getArgumentList().replace(this.myPermutation.getArgumentList());
    }

    public static void registerFix(HighlightInfo info, PsiCall callExpression, CandidateInfo[] candidates, TextRange fixRange) {
        PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
        if (expressions.length < 2) {
            return;
        }
        ArrayList<PsiCall> permutations = new ArrayList<PsiCall>();
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            MethodCandidateInfo methodCandidate = (MethodCandidateInfo)candidate;
            PsiMethod method = methodCandidate.getElement();
            PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (expressions.length != parameters.length || parameters.length == 0) continue;
            int minIncompatibleIndex = parameters.length;
            int maxIncompatibleIndex = 0;
            int incompatibilitiesCount = 0;
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiParameter parameter = parameters[i2];
                PsiType type = substitutor.substitute(parameter.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible(type, expressions[i2])) continue;
                if (minIncompatibleIndex == parameters.length) {
                    minIncompatibleIndex = i2;
                }
                maxIncompatibleIndex = i2;
                ++incompatibilitiesCount;
            }
            try {
                PermuteArgumentsFix.registerSwapFixes(expressions, callExpression, permutations, methodCandidate, incompatibilitiesCount, minIncompatibleIndex, maxIncompatibleIndex);
                PermuteArgumentsFix.registerShiftFixes(expressions, callExpression, permutations, methodCandidate, minIncompatibleIndex, maxIncompatibleIndex);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        if (permutations.size() == 1) {
            PermuteArgumentsFix fix = new PermuteArgumentsFix(callExpression, (PsiCall)permutations.get(0));
            QuickFixAction.registerQuickFixAction(info, fixRange, fix);
        }
    }

    private static void registerShiftFixes(PsiExpression[] expressions, PsiCall callExpression, List<PsiCall> permutations, MethodCandidateInfo methodCandidate, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = methodCandidate.getElement();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        for (int i2 = 0; i2 <= minIncompatibleIndex; ++i2) {
            for (int j = Math.max(i2 + 2, maxIncompatibleIndex); j < expressions.length; ++j) {
                ArrayUtil.rotateLeft(expressions, i2, j);
                if (PsiUtil.isApplicable(method, substitutor, expressions) && PermuteArgumentsFix.canShift(expressions, callExpression, permutations, i2)) {
                    return;
                }
                ArrayUtil.rotateRight(expressions, i2, j);
                ArrayUtil.rotateRight(expressions, i2, j);
                if (PsiUtil.isApplicable(method, substitutor, expressions) && PermuteArgumentsFix.canShift(expressions, callExpression, permutations, i2)) {
                    return;
                }
                ArrayUtil.rotateLeft(expressions, i2, j);
            }
        }
    }

    private static boolean canShift(PsiExpression[] expressions, PsiCall callExpression, List<PsiCall> permutations, int i2) {
        PsiCall copy = LambdaUtil.copyTopLevelCall(callExpression);
        if (copy == null) {
            return false;
        }
        PsiExpressionList list = copy.getArgumentList();
        if (list == null) {
            return false;
        }
        PsiExpression[] copyExpressions = list.getExpressions();
        for (int k = i2; k < copyExpressions.length; ++k) {
            copyExpressions[k].replace(expressions[k]);
        }
        JavaResolveResult result = copy.resolveMethodGenerics();
        if (result.getElement() != null && result.isValidResult()) {
            permutations.add(copy);
            if (permutations.size() > 1) {
                return true;
            }
        }
        return false;
    }

    private static void registerSwapFixes(PsiExpression[] expressions, PsiCall callExpression, List<PsiCall> permutations, MethodCandidateInfo candidate, int incompatibilitiesCount, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (incompatibilitiesCount >= 3) {
            return;
        }
        for (int i2 = minIncompatibleIndex; i2 < maxIncompatibleIndex; ++i2) {
            for (int j = i2 + 1; j <= maxIncompatibleIndex; ++j) {
                ArrayUtil.swap(expressions, i2, j);
                if (PsiUtil.isApplicable(method, substitutor, expressions)) {
                    PsiCall copy = LambdaUtil.copyTopLevelCall(callExpression);
                    if (copy == null) {
                        return;
                    }
                    PsiExpressionList argumentList = copy.getArgumentList();
                    if (argumentList == null) {
                        return;
                    }
                    PsiExpression[] copyExpressions = argumentList.getExpressions();
                    copyExpressions[i2].replace(expressions[i2]);
                    copyExpressions[j].replace(expressions[j]);
                    JavaResolveResult result = copy.resolveMethodGenerics();
                    if (result.getElement() != null && result.isValidResult()) {
                        permutations.add(copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.swap(expressions, i2, j);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permutation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

