/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.HMethod;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.KeyedMethodVisitor;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class BytecodeAnalysisIndex
extends ScalarIndexExtension<HMethod> {
    private static final ID<HMethod, Void> NAME = ID.create("bytecodeAnalysis");
    private static final HKeyDescriptor KEY_DESCRIPTOR = new HKeyDescriptor();
    private static final int VERSION = 6;
    private static final int VERSION_MODIFIER = HardCodedPurity.AGGRESSIVE_HARDCODED_PURITY ? 1 : 0;
    private static final int FINAL_VERSION = 12 + VERSION_MODIFIER;
    private static final VirtualFileGist<Map<HMethod, Equations>> ourGist = GistManager.getInstance().newVirtualFileGist("BytecodeAnalysisIndex", FINAL_VERSION, new EquationsExternalizer(), new ClassDataIndexer());

    @Override
    @NotNull
    public ID<HMethod, Void> getName() {
        ID<HMethod, Void> iD = NAME;
        if (iD == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<HMethod, Void, FileContent> getIndexer() {
        DataIndexer<HMethod, Void, FileContent> dataIndexer = inputData -> {
            try {
                return BytecodeAnalysisIndex.collectKeys(inputData.getContent());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
                return Collections.emptyMap();
            }
        };
        if (dataIndexer == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    private static Map<HMethod, Void> collectKeys(byte[] content) {
        final HashMap<HMethod, Void> map = new HashMap<HMethod, Void>();
        final MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
        new ClassReader(content).accept((ClassVisitor)new KeyedMethodVisitor(){

            @Override
            @Nullable
            MethodVisitor visitMethod(MethodNode node, Method method, EKey key) {
                map.put(method.hashed(md), null);
                return null;
            }
        }, 6);
        HashMap<HMethod, Void> hashMap = map;
        if (hashMap == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public KeyDescriptor<HMethod> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = KEY_DESCRIPTOR;
        if (hKeyDescriptor == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(3);
        }
        return hKeyDescriptor;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(JavaClassFileType.INSTANCE);
        if (defaultFileTypeSpecificInputFilter == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 10;
    }

    @NotNull
    static List<Equations> getEquations(GlobalSearchScope scope, HMethod key) {
        Project project = ProjectManager.getInstance().getDefaultProject();
        List<Equations> list = ContainerUtil.mapNotNull(FileBasedIndex.getInstance().getContainingFiles(NAME, key, scope), file -> ourGist.getFileData(project, (VirtualFile)file).get(key));
        if (list == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectKeys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquations";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class EquationsExternalizer
    implements DataExternalizer<Map<HMethod, Equations>> {
        @Override
        public void save(@NotNull DataOutput out, Map<HMethod, Equations> value) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(0);
            }
            DataInputOutputUtilRt.writeSeq(out, value.entrySet(), entry -> {
                if (out == null) {
                    EquationsExternalizer.$$$reportNull$$$0(12);
                }
                KEY_DESCRIPTOR.save(out, (HMethod)entry.getKey());
                EquationsExternalizer.saveEquations(out, (Equations)entry.getValue());
            });
        }

        @Override
        public Map<HMethod, Equations> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(1);
            }
            return DataInputOutputUtilRt.readSeq(in, () -> {
                if (in == null) {
                    EquationsExternalizer.$$$reportNull$$$0(11);
                }
                return Pair.create(KEY_DESCRIPTOR.read(in), EquationsExternalizer.readEquations(in));
            }).stream().collect(Collectors.toMap(p -> (HMethod)p.getFirst(), p -> (Equations)p.getSecond()));
        }

        private static void saveEquations(@NotNull DataOutput out, Equations eqs) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(2);
            }
            out.writeBoolean(eqs.stable);
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            DataInputOutputUtil.writeINT(out, eqs.results.size());
            for (DirectionResultPair pair : eqs.results) {
                DataInputOutputUtil.writeINT(out, pair.directionKey);
                Result rhs = pair.result;
                if (rhs instanceof Final) {
                    Final finalResult = (Final)rhs;
                    out.writeBoolean(true);
                    DataInputOutputUtil.writeINT(out, finalResult.value.ordinal());
                    continue;
                }
                if (rhs instanceof Pending) {
                    Pending pendResult = (Pending)rhs;
                    out.writeBoolean(false);
                    DataInputOutputUtil.writeINT(out, pendResult.delta.length);
                    for (Component component : pendResult.delta) {
                        DataInputOutputUtil.writeINT(out, component.value.ordinal());
                        EKey[] ids = component.ids;
                        DataInputOutputUtil.writeINT(out, ids.length);
                        for (EKey hKey : ids) {
                            EquationsExternalizer.writeKey(out, hKey, md);
                        }
                    }
                    continue;
                }
                if (!(rhs instanceof Effects)) continue;
                Effects effects = (Effects)rhs;
                DataInputOutputUtil.writeINT(out, effects.effects.size());
                for (EffectQuantum effect : effects.effects) {
                    EquationsExternalizer.writeEffect(out, effect, md);
                }
                EquationsExternalizer.writeDataValue(out, effects.returnValue, md);
            }
        }

        private static Equations readEquations(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(3);
            }
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT(in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT(in);
                Direction direction = Direction.fromInt(directionKey);
                if (direction == Direction.Pure) {
                    HashSet<EffectQuantum> effects = new HashSet<EffectQuantum>();
                    int effectsSize = DataInputOutputUtil.readINT(in);
                    for (int i2 = 0; i2 < effectsSize; ++i2) {
                        effects.add(EquationsExternalizer.readEffect(in));
                    }
                    DataValue returnValue = EquationsExternalizer.readDataValue(in);
                    results.add(new DirectionResultPair(directionKey, new Effects(returnValue, effects)));
                    continue;
                }
                boolean isFinal = in.readBoolean();
                if (isFinal) {
                    int ordinal = DataInputOutputUtil.readINT(in);
                    Value value = Value.values()[ordinal];
                    results.add(new DirectionResultPair(directionKey, new Final(value)));
                    continue;
                }
                int sumLength = DataInputOutputUtil.readINT(in);
                Component[] components = new Component[sumLength];
                for (int i3 = 0; i3 < sumLength; ++i3) {
                    int ordinal = DataInputOutputUtil.readINT(in);
                    Value value = Value.values()[ordinal];
                    int componentSize = DataInputOutputUtil.readINT(in);
                    EKey[] ids = new EKey[componentSize];
                    for (int j = 0; j < componentSize; ++j) {
                        ids[j] = EquationsExternalizer.readKey(in);
                    }
                    components[i3] = new Component(value, ids);
                }
                results.add(new DirectionResultPair(directionKey, new Pending(components)));
            }
            return new Equations(results, stable);
        }

        @NotNull
        private static EKey readKey(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(4);
            }
            byte[] bytes = new byte[14];
            in.readFully(bytes);
            int rawDirKey = DataInputOutputUtil.readINT(in);
            EKey eKey = new EKey((MethodDescriptor)new HMethod(bytes), Direction.fromInt(Math.abs(rawDirKey)), in.readBoolean(), rawDirKey < 0);
            if (eKey == null) {
                EquationsExternalizer.$$$reportNull$$$0(5);
            }
            return eKey;
        }

        private static void writeKey(@NotNull DataOutput out, EKey key, MessageDigest md) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(6);
            }
            out.write(key.method.hashed((MessageDigest)md).myBytes);
            int rawDirKey = key.negated ? -key.dirKey : key.dirKey;
            DataInputOutputUtil.writeINT(out, rawDirKey);
            out.writeBoolean(key.stable);
        }

        private static void writeEffect(@NotNull DataOutput out, EffectQuantum effect, MessageDigest md) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(7);
            }
            if (effect == EffectQuantum.TopEffectQuantum) {
                DataInputOutputUtil.writeINT(out, -1);
            } else if (effect == EffectQuantum.ThisChangeQuantum) {
                DataInputOutputUtil.writeINT(out, -2);
            } else if (effect instanceof EffectQuantum.CallQuantum) {
                DataInputOutputUtil.writeINT(out, -3);
                EffectQuantum.CallQuantum callQuantum = (EffectQuantum.CallQuantum)effect;
                EquationsExternalizer.writeKey(out, callQuantum.key, md);
                out.writeBoolean(callQuantum.isStatic);
                DataInputOutputUtil.writeINT(out, callQuantum.data.length);
                for (DataValue dataValue : callQuantum.data) {
                    EquationsExternalizer.writeDataValue(out, dataValue, md);
                }
            } else if (effect instanceof EffectQuantum.ReturnChangeQuantum) {
                DataInputOutputUtil.writeINT(out, -4);
                EquationsExternalizer.writeKey(out, ((EffectQuantum.ReturnChangeQuantum)effect).key, md);
            } else if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                DataInputOutputUtil.writeINT(out, ((EffectQuantum.ParamChangeQuantum)effect).n);
            }
        }

        private static EffectQuantum readEffect(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(8);
            }
            int effectMask = DataInputOutputUtil.readINT(in);
            switch (effectMask) {
                case -1: {
                    return EffectQuantum.TopEffectQuantum;
                }
                case -2: {
                    return EffectQuantum.ThisChangeQuantum;
                }
                case -3: {
                    EKey key = EquationsExternalizer.readKey(in);
                    boolean isStatic = in.readBoolean();
                    int dataLength = DataInputOutputUtil.readINT(in);
                    DataValue[] data = new DataValue[dataLength];
                    for (int di = 0; di < dataLength; ++di) {
                        data[di] = EquationsExternalizer.readDataValue(in);
                    }
                    return new EffectQuantum.CallQuantum(key, data, isStatic);
                }
                case -4: {
                    return new EffectQuantum.ReturnChangeQuantum(EquationsExternalizer.readKey(in));
                }
            }
            return new EffectQuantum.ParamChangeQuantum(effectMask);
        }

        private static void writeDataValue(@NotNull DataOutput out, DataValue dataValue, MessageDigest md) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(9);
            }
            if (dataValue == DataValue.ThisDataValue) {
                DataInputOutputUtil.writeINT(out, -1);
            } else if (dataValue == DataValue.LocalDataValue) {
                DataInputOutputUtil.writeINT(out, -2);
            } else if (dataValue == DataValue.OwnedDataValue) {
                DataInputOutputUtil.writeINT(out, -3);
            } else if (dataValue == DataValue.UnknownDataValue1) {
                DataInputOutputUtil.writeINT(out, -4);
            } else if (dataValue == DataValue.UnknownDataValue2) {
                DataInputOutputUtil.writeINT(out, -5);
            } else if (dataValue instanceof DataValue.ReturnDataValue) {
                DataInputOutputUtil.writeINT(out, -6);
                EquationsExternalizer.writeKey(out, ((DataValue.ReturnDataValue)dataValue).key, md);
            } else if (dataValue instanceof DataValue.ParameterDataValue) {
                DataInputOutputUtil.writeINT(out, ((DataValue.ParameterDataValue)dataValue).n);
            }
        }

        private static DataValue readDataValue(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(10);
            }
            int dataI = DataInputOutputUtil.readINT(in);
            switch (dataI) {
                case -1: {
                    return DataValue.ThisDataValue;
                }
                case -2: {
                    return DataValue.LocalDataValue;
                }
                case -3: {
                    return DataValue.OwnedDataValue;
                }
                case -4: {
                    return DataValue.UnknownDataValue1;
                }
                case -5: {
                    return DataValue.UnknownDataValue2;
                }
                case -6: {
                    return new DataValue.ReturnDataValue(EquationsExternalizer.readKey(in));
                }
            }
            return new DataValue.ParameterDataValue(dataI);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "saveEquations";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readEquations";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readKey";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "writeKey";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "writeEffect";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "readEffect";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "writeDataValue";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "readDataValue";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$read$1";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$save$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<HMethod>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private HKeyDescriptor() {
        }

        @Override
        public void save(@NotNull DataOutput out, HMethod value) throws IOException {
            if (out == null) {
                HKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.write(value.myBytes);
        }

        @Override
        public HMethod read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                HKeyDescriptor.$$$reportNull$$$0(1);
            }
            byte[] bytes = new byte[14];
            in.readFully(bytes);
            return new HMethod(bytes);
        }

        @Override
        public int getHashCode(HMethod value) {
            return value.hashCode();
        }

        @Override
        public boolean isEqual(HMethod val1, HMethod val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

