/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefMethodImpl
extends RefJavaElementImpl
implements RefMethod {
    private static final List<RefMethod> EMPTY_METHOD_LIST = Collections.emptyList();
    private static final RefParameter[] EMPTY_PARAMS_ARRAY = new RefParameter[0];
    private static final int IS_APPMAIN_MASK = 65536;
    private static final int IS_LIBRARY_OVERRIDE_MASK = 131072;
    private static final int IS_CONSTRUCTOR_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_BODY_EMPTY_MASK = 0x100000;
    private static final int IS_ONLY_CALLS_SUPER_MASK = 0x200000;
    private static final int IS_RETURN_VALUE_USED_MASK = 0x400000;
    private static final int IS_TEST_METHOD_MASK = 0x4000000;
    private static final int IS_CALLED_ON_SUBCLASS_MASK = 0x8000000;
    private static final String RETURN_VALUE_UNDEFINED = "#";
    private List<RefMethod> mySuperMethods;
    private List<RefMethod> myDerivedMethods;
    private List<String> myUnThrownExceptions;
    private RefParameter[] myParameters;
    private String myReturnValueTemplate;

    RefMethodImpl(@NotNull RefClass ownerClass, PsiMethod method, RefManager manager) {
        if (ownerClass == null) {
            RefMethodImpl.$$$reportNull$$$0(0);
        }
        super(method, manager);
        ((RefClassImpl)ownerClass).add(this);
    }

    protected RefMethodImpl(@NotNull String name, @NotNull RefClass ownerClass) {
        if (name == null) {
            RefMethodImpl.$$$reportNull$$$0(1);
        }
        if (ownerClass == null) {
            RefMethodImpl.$$$reportNull$$$0(2);
        }
        super(name, ownerClass);
        ((RefClassImpl)ownerClass).add(this);
        this.addOutReference(ownerClass);
        ((RefClassImpl)ownerClass).addInReference(this);
        this.setConstructor(true);
    }

    @Override
    public void add(@NotNull RefEntity child) {
        if (child == null) {
            RefMethodImpl.$$$reportNull$$$0(3);
        }
        if (child instanceof RefParameter) {
            return;
        }
        super.add(child);
    }

    @Override
    @NotNull
    public synchronized List<RefEntity> getChildren() {
        List superChildren = super.getChildren();
        if (this.myParameters == null) {
            List list = superChildren;
            if (list == null) {
                RefMethodImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (superChildren.isEmpty()) {
            List<RefEntity> list = Arrays.asList(this.myParameters);
            if (list == null) {
                RefMethodImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<RefEntity> allChildren = new ArrayList<RefEntity>(superChildren.size() + this.myParameters.length);
        allChildren.addAll(superChildren);
        Collections.addAll(allChildren, this.myParameters);
        ArrayList<RefEntity> arrayList = allChildren;
        if (arrayList == null) {
            RefMethodImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        PsiParameter[] paramList;
        PsiMethod method = (PsiMethod)this.getElement();
        LOG.assertTrue(method != null);
        this.setConstructor(method.isConstructor());
        PsiType returnType = method.getReturnType();
        this.setFlag(returnType == null || PsiType.VOID.equals(returnType) || returnType.equalsToText("java.lang.Void"), 0x400000L);
        if (!this.isReturnValueUsed()) {
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                this.myReturnValueTemplate = RETURN_VALUE_UNDEFINED;
            }
        }
        if (this.isConstructor()) {
            this.addReference(this.getOwnerClass(), this.getOwnerClass().getElement(), method, false, true, null);
        }
        if (this.getOwnerClass().isInterface()) {
            this.setAbstract(false);
        } else {
            this.setAbstract(method.hasModifierProperty("abstract"));
        }
        this.setAppMain(RefMethodImpl.isAppMain(method, this));
        this.setLibraryOverride(method.hasModifierProperty("native"));
        this.initializeSuperMethods(method);
        if (this.isExternalOverride()) {
            ((RefClassImpl)this.getOwnerClass()).addLibraryOverrideMethod(this);
        }
        String name = method.getName();
        if (this.getOwnerClass().isTestCase() && name.startsWith("test")) {
            this.setTestMethod(true);
        }
        if ((paramList = method.getParameterList().getParameters()).length > 0) {
            RefParameterImpl[] newParameters = new RefParameterImpl[paramList.length];
            for (int i2 = 0; i2 < paramList.length; ++i2) {
                newParameters[i2] = this.getRefJavaManager().getParameterReference(paramList[i2], i2);
            }
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                this.myParameters = newParameters;
            }
        }
        if (method.hasModifierProperty("native")) {
            this.updateReturnValueTemplate(null);
            this.updateThrowsList(null);
        }
        this.collectUncaughtExceptions(method);
    }

    private static boolean isAppMain(PsiMethod psiMethod, RefMethod refMethod) {
        if (!refMethod.isStatic()) {
            return false;
        }
        if (!PsiType.VOID.equals(psiMethod.getReturnType())) {
            return false;
        }
        PsiMethod appMainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppMainPattern();
        if (MethodSignatureUtil.areSignaturesEqual(psiMethod, appMainPattern)) {
            return true;
        }
        PsiMethod appPremainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppPremainPattern();
        if (MethodSignatureUtil.areSignaturesEqual(psiMethod, appPremainPattern)) {
            return true;
        }
        PsiMethod appAgentmainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppAgentmainPattern();
        return MethodSignatureUtil.areSignaturesEqual(psiMethod, appAgentmainPattern);
    }

    private void checkForSuperCall(PsiMethod method) {
        if (this.isConstructor()) {
            String text2;
            PsiExpression qualifierExpression;
            PsiExpression firstExpression;
            PsiStatement first;
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            boolean isBaseExplicitlyCalled = false;
            if (statements.length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (firstExpression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && (qualifierExpression = ((PsiMethodCallExpression)firstExpression).getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression && ("super".equals(text2 = qualifierExpression.getText()) || text2.equals("this"))) {
                isBaseExplicitlyCalled = true;
            }
            if (!isBaseExplicitlyCalled) {
                for (RefClass superClass : this.getOwnerClass().getBaseClasses()) {
                    RefMethodImpl superDefaultConstructor = (RefMethodImpl)superClass.getDefaultConstructor();
                    if (superDefaultConstructor == null) continue;
                    superDefaultConstructor.addInReference(this);
                    this.addOutReference(superDefaultConstructor);
                }
            }
        }
    }

    @Override
    @NotNull
    public synchronized Collection<RefMethod> getSuperMethods() {
        Collection collection = ObjectUtils.notNull(this.mySuperMethods, EMPTY_METHOD_LIST);
        if (collection == null) {
            RefMethodImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @NotNull
    public synchronized Collection<RefMethod> getDerivedMethods() {
        Collection collection = ObjectUtils.notNull(this.myDerivedMethods, EMPTY_METHOD_LIST);
        if (collection == null) {
            RefMethodImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Override
    public boolean isBodyEmpty() {
        return this.checkFlag(0x100000L);
    }

    @Override
    public boolean isOnlyCallsSuper() {
        return this.checkFlag(0x200000L);
    }

    @Override
    public boolean hasBody() {
        return !this.isAbstract() && !this.getOwnerClass().isInterface() || !this.isBodyEmpty();
    }

    private void initializeSuperMethods(PsiMethod method) {
        if (this.getRefManager().isOfflineView() || !this.getRefManager().isDeclarationsFound()) {
            return;
        }
        for (PsiMethod psiSuperMethod : method.findSuperMethods()) {
            if (this.getRefManager().belongsToScope(psiSuperMethod)) {
                RefMethodImpl refSuperMethod = (RefMethodImpl)this.getRefManager().getReference(psiSuperMethod);
                if (refSuperMethod == null) continue;
                this.addSuperMethod(refSuperMethod);
                refSuperMethod.markExtended(this);
                continue;
            }
            this.setLibraryOverride(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuperMethod(RefMethodImpl refSuperMethod) {
        if (!refSuperMethod.getSuperMethods().contains(this)) {
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                List<RefMethod> superMethods = this.mySuperMethods;
                if (superMethods == null) {
                    this.mySuperMethods = superMethods = new ArrayList<RefMethod>(1);
                }
                if (!superMethods.contains(refSuperMethod)) {
                    superMethods.add(refSuperMethod);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markExtended(RefMethodImpl method) {
        if (!method.getDerivedMethods().contains(this)) {
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                List<RefMethod> derivedMethods = this.myDerivedMethods;
                if (derivedMethods == null) {
                    this.myDerivedMethods = derivedMethods = new ArrayList<RefMethod>(1);
                }
                if (!derivedMethods.contains(method)) {
                    this.myDerivedMethods.add(method);
                }
            }
        }
    }

    @Override
    @NotNull
    public synchronized RefParameter[] getParameters() {
        RefParameter[] refParameterArray = ObjectUtils.notNull(this.myParameters, EMPTY_PARAMS_ARRAY);
        if (refParameterArray == null) {
            RefMethodImpl.$$$reportNull$$$0(9);
        }
        return refParameterArray;
    }

    @Override
    public void buildReferences() {
        PsiMethod method = (PsiMethod)this.getElement();
        if (method == null) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        refUtil.addReferences(method, this, method);
        this.checkForSuperCall(method);
        this.setOnlyCallsSuper(refUtil.isMethodOnlyCallsSuper(method));
        this.setBodyEmpty(this.isOnlyCallsSuper() || !this.isExternalOverride() && (body == null || body.getStatements().length == 0));
        refUtil.addTypeReference(method, method.getReturnType(), this.getRefManager(), this);
        for (RefParameter parameter : this.getParameters()) {
            refUtil.setIsFinal(parameter, parameter.getElement().hasModifierProperty("final"));
        }
        this.getRefManager().fireBuildReferences(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectUncaughtExceptions(@NotNull PsiMethod method) {
        if (method == null) {
            RefMethodImpl.$$$reportNull$$$0(10);
        }
        if (this.getRefManager().isOfflineView()) {
            return;
        }
        PsiClassType[] throwsList = method.getThrowsList().getReferencedTypes();
        if (throwsList.length > 0) {
            AbstractList unThrownExceptions = throwsList.length == 1 ? new SmartList() : new ArrayList(throwsList.length);
            for (PsiClassType type : throwsList) {
                String fqn;
                PsiClass aClass = type.resolve();
                String string = fqn = aClass == null ? null : aClass.getQualifiedName();
                if (fqn == null) continue;
                unThrownExceptions.add(fqn);
            }
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                this.myUnThrownExceptions = unThrownExceptions;
            }
        }
    }

    public synchronized void removeUnThrownExceptions(PsiClass unThrownException) {
        if (this.myUnThrownExceptions != null) {
            this.myUnThrownExceptions.remove(unThrownException.getQualifiedName());
        }
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefMethodImpl.$$$reportNull$$$0(11);
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    RefMethodImpl.$$$reportNull$$$0(15);
                }
                ((RefJavaVisitor)visitor).visitMethod(this);
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean isExternalOverride() {
        return this.isLibraryOverride(new HashSet<RefMethod>());
    }

    private boolean isLibraryOverride(@NotNull Collection<RefMethod> processed2) {
        if (processed2 == null) {
            RefMethodImpl.$$$reportNull$$$0(12);
        }
        if (!processed2.add(this)) {
            return false;
        }
        if (this.checkFlag(131072L)) {
            return true;
        }
        for (RefMethod superMethod : this.getSuperMethods()) {
            if (!((RefMethodImpl)superMethod).isLibraryOverride(processed2)) continue;
            this.setFlag(true, 131072L);
            return true;
        }
        return false;
    }

    @Override
    public boolean isAppMain() {
        return this.checkFlag(65536L);
    }

    @Override
    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    @Override
    public boolean hasSuperMethods() {
        return !this.getSuperMethods().isEmpty() || this.isExternalOverride();
    }

    @Override
    public boolean isReferenced() {
        for (RefElement refCaller : this.getInReferences()) {
            if (this.getDerivedMethods().contains(refCaller)) continue;
            return true;
        }
        return this.isExternalOverride();
    }

    @Override
    public boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious() || this.getDerivedMethods().contains(refCaller)) continue;
            return true;
        }
        if (this.isExternalOverride()) {
            return true;
        }
        if (!this.isStatic() && !this.isConstructor()) {
            for (RefMethod refSuper : this.getSuperMethods()) {
                if (!((RefMethodImpl)refSuper).isSuspicious()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConstructor() {
        return this.checkFlag(262144L);
    }

    @Override
    public RefClass getOwnerClass() {
        return (RefClass)this.getOwner();
    }

    @Override
    @NotNull
    public String getName() {
        if (this.isValid()) {
            String string = ReadAction.compute(() -> {
                PsiMethod psiMethod = (PsiMethod)this.getElement();
                if (psiMethod instanceof SyntheticElement) {
                    return psiMethod.getName();
                }
                return PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 257, 2);
            });
            if (string == null) {
                RefMethodImpl.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = super.getName();
        if (string == null) {
            RefMethodImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public String getExternalName() {
        return ReadAction.compute(() -> {
            PsiMethod psiMethod = (PsiMethod)this.getElement();
            LOG.assertTrue(psiMethod != null);
            return PsiFormatUtil.getExternalName(psiMethod, true, Integer.MAX_VALUE);
        });
    }

    @Nullable
    static RefMethod methodFromExternalName(RefManager manager, String externalName) {
        return (RefMethod)manager.getReference(RefMethodImpl.findPsiMethod(PsiManager.getInstance(manager.getProject()), externalName));
    }

    @Nullable
    public static PsiMethod findPsiMethod(PsiManager manager, String externalName) {
        int spaceIdx = externalName.indexOf(32);
        String className = externalName.substring(0, spaceIdx);
        PsiClass psiClass = ClassUtil.findPsiClass(manager, className);
        if (psiClass == null) {
            return null;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory();
            String methodSignature = externalName.substring(spaceIdx + 1);
            PsiMethod patternMethod = factory.createMethodFromText(methodSignature, psiClass);
            return psiClass.findMethodBySignature(patternMethod, false);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public void referenceRemoved() {
        if (this.getOwnerClass() != null) {
            ((RefClassImpl)this.getOwnerClass()).methodRemoved(this);
        }
        super.referenceRemoved();
        for (RefMethod superMethod : this.getSuperMethods()) {
            superMethod.getDerivedMethods().remove(this);
        }
        for (RefMethod subMethod : this.getDerivedMethods()) {
            subMethod.getSuperMethods().remove(this);
        }
    }

    @Override
    public boolean isSuspicious() {
        if (this.isConstructor() && "private".equals(this.getAccessModifier()) && this.getParameters().length == 0 && this.getOwnerClass().getConstructors().size() == 1) {
            return false;
        }
        return super.isSuspicious();
    }

    void setReturnValueUsed(boolean value) {
        if (this.checkFlag(0x400000L) == value) {
            return;
        }
        this.setFlag(value, 0x400000L);
        for (RefMethod refSuper : this.getSuperMethods()) {
            ((RefMethodImpl)refSuper).setReturnValueUsed(value);
        }
    }

    @Override
    public boolean isReturnValueUsed() {
        return this.checkFlag(0x400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateReturnValueTemplate(PsiExpression expression) {
        RefMethodImpl refMethodImpl = this;
        synchronized (refMethodImpl) {
            if (this.myReturnValueTemplate == null) {
                return;
            }
        }
        if (!this.getSuperMethods().isEmpty()) {
            for (RefMethod refMethod : this.getSuperMethods()) {
                RefMethodImpl refSuper = (RefMethodImpl)refMethod;
                refSuper.updateReturnValueTemplate(expression);
            }
        } else {
            String newTemplate = null;
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (expression instanceof PsiLiteralExpression) {
                PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)expression;
                newTemplate = psiLiteralExpression.getText();
            } else if (expression instanceof PsiReferenceExpression) {
                PsiField psiField;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiField && (psiField = (PsiField)resolved).hasModifierProperty("static") && psiField.hasModifierProperty("final") && refUtil.compareAccess(refUtil.getAccessModifier(psiField), this.getAccessModifier()) >= 0) {
                    newTemplate = PsiFormatUtil.formatVariable(psiField, 6145, PsiSubstitutor.EMPTY);
                }
            } else if (refUtil.isCallToSuperMethod(expression, (PsiMethod)this.getElement())) {
                return;
            }
            RefMethodImpl refMethodImpl2 = this;
            synchronized (refMethodImpl2) {
                if (this.myReturnValueTemplate == RETURN_VALUE_UNDEFINED) {
                    this.myReturnValueTemplate = newTemplate;
                } else if (!Comparing.equal(this.myReturnValueTemplate, newTemplate)) {
                    this.myReturnValueTemplate = null;
                }
            }
        }
    }

    void updateParameterValues(PsiExpression[] args) {
        block4: {
            block3: {
                if (this.isExternalOverride()) {
                    return;
                }
                if (this.getSuperMethods().isEmpty()) break block3;
                for (RefMethod refSuper : this.getSuperMethods()) {
                    ((RefMethodImpl)refSuper).updateParameterValues(args);
                }
                break block4;
            }
            RefParameter[] params = this.getParameters();
            if (params.length > args.length || params.length <= 0) break block4;
            for (int i2 = 0; i2 < args.length; ++i2) {
                RefParameter refParameter = params.length <= i2 ? params[params.length - 1] : params[i2];
                ((RefParameterImpl)refParameter).updateTemplateValue(args[i2]);
            }
        }
    }

    @Override
    public synchronized String getReturnValueIfSame() {
        if (this.myReturnValueTemplate == RETURN_VALUE_UNDEFINED) {
            return null;
        }
        return this.myReturnValueTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThrowsList(PsiClassType exceptionType) {
        for (RefMethod refSuper : this.getSuperMethods()) {
            ((RefMethodImpl)refSuper).updateThrowsList(exceptionType);
        }
        RefMethodImpl refMethodImpl = this;
        synchronized (refMethodImpl) {
            List<String> unThrownExceptions = this.myUnThrownExceptions;
            if (unThrownExceptions != null) {
                if (exceptionType == null) {
                    this.myUnThrownExceptions = null;
                } else {
                    PsiClass exceptionClass = exceptionType.resolve();
                    JavaPsiFacade facade = JavaPsiFacade.getInstance(this.myManager.getProject());
                    for (int i2 = unThrownExceptions.size() - 1; i2 >= 0; --i2) {
                        String exceptionFqn = unThrownExceptions.get(i2);
                        PsiClass classType = facade.findClass(exceptionFqn, GlobalSearchScope.allScope(this.getRefManager().getProject()));
                        if (!InheritanceUtil.isInheritorOrSelf(exceptionClass, classType, true) && !InheritanceUtil.isInheritorOrSelf(classType, exceptionClass, true)) continue;
                        unThrownExceptions.remove(i2);
                    }
                    if (unThrownExceptions.isEmpty()) {
                        this.myUnThrownExceptions = null;
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public synchronized PsiClass[] getUnThrownExceptions() {
        List<String> unThrownExceptions;
        if (this.getRefManager().isOfflineView()) {
            LOG.debug("Should not traverse graph offline");
        }
        if ((unThrownExceptions = this.myUnThrownExceptions) == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.myManager.getProject());
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(unThrownExceptions.size());
        for (String exception : unThrownExceptions) {
            PsiClass element = facade.findClass(exception, GlobalSearchScope.allScope(this.myManager.getProject()));
            if (element == null) continue;
            result.add(element);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    public void setLibraryOverride(boolean libraryOverride) {
        this.setFlag(libraryOverride, 131072L);
    }

    private void setAppMain(boolean appMain) {
        this.setFlag(appMain, 65536L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    public void setBodyEmpty(boolean bodyEmpty) {
        this.setFlag(bodyEmpty, 0x100000L);
    }

    private void setOnlyCallsSuper(boolean onlyCallsSuper) {
        this.setFlag(onlyCallsSuper, 0x200000L);
    }

    private void setConstructor(boolean constructor) {
        this.setFlag(constructor, 262144L);
    }

    @Override
    public boolean isTestMethod() {
        return this.checkFlag(0x4000000L);
    }

    private void setTestMethod(boolean testMethod) {
        this.setFlag(testMethod, 0x4000000L);
    }

    @Override
    public PsiModifierListOwner getElement() {
        return (PsiModifierListOwner)super.getElement();
    }

    @Override
    public boolean isCalledOnSubClass() {
        return this.checkFlag(0x8000000L);
    }

    void setCalledOnSubClass(boolean isCalledOnSubClass) {
        this.setFlag(isCalledOnSubClass, 0x8000000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefMethodImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefMethodImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectUncaughtExceptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryOverride";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$accept$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

