/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterCanBeLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ParameterCanBeLocal";

    @NotNull
    private static List<PsiParameter> filterFinal(PsiParameter[] parameters) {
        ArrayList<PsiParameter> result = new ArrayList<PsiParameter>(parameters.length);
        for (PsiParameter parameter : parameters) {
            if (parameter.hasModifierProperty("final")) continue;
            result.add(parameter);
        }
        ArrayList<PsiParameter> arrayList = result;
        if (arrayList == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static Collection<PsiParameter> getWriteBeforeRead(@NotNull Collection<PsiParameter> parameters, @NotNull PsiCodeBlock body) {
        ControlFlow controlFlow;
        if (parameters == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(1);
        }
        if (body == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(2);
        }
        if ((controlFlow = ParameterCanBeLocalInspectionBase.getControlFlow(body)) == null) {
            return Collections.emptyList();
        }
        Set<PsiParameter> result = ParameterCanBeLocalInspectionBase.filterParameters(controlFlow, parameters);
        result.retainAll(ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false));
        for (PsiReferenceExpression readBeforeWrite : ControlFlowUtil.getReadBeforeWrite(controlFlow)) {
            PsiElement resolved = readBeforeWrite.resolve();
            if (!(resolved instanceof PsiParameter)) continue;
            result.remove(resolved);
        }
        return result;
    }

    private static Set<PsiParameter> filterParameters(@NotNull ControlFlow controlFlow, @NotNull Collection<PsiParameter> parameters) {
        if (controlFlow == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(4);
        }
        HashSet<PsiVariable> usedVars = new HashSet<PsiVariable>(ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize()));
        HashSet<PsiParameter> result = new HashSet<PsiParameter>();
        for (PsiParameter parameter : parameters) {
            if (!usedVars.contains(parameter)) continue;
            result.add(parameter);
        }
        return result;
    }

    private static boolean isOverrides(PsiMethod method) {
        return SuperMethodsSearch.search(method, null, true, false).findFirst() != null;
    }

    @Nullable
    private static ControlFlow getControlFlow(PsiElement context) {
        try {
            return ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASS_LAYOUT_GROUP_NAME;
        if (string == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.parameter.can.be.local.display.name", new Object[0]);
        if (string == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(7);
        }
        return SHORT_NAME;
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(9);
        }
        List<PsiParameter> parameters = ParameterCanBeLocalInspectionBase.filterFinal(method.getParameterList().getParameters());
        PsiCodeBlock body = method.getBody();
        if (body == null || parameters.isEmpty() || ParameterCanBeLocalInspectionBase.isOverrides(method)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (PsiParameter parameter : ParameterCanBeLocalInspectionBase.getWriteBeforeRead(parameters, body)) {
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null || !identifier.isPhysical()) continue;
            result.add(this.createProblem(manager, identifier, isOnTheFly));
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    @NotNull
    private ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull PsiIdentifier identifier, boolean isOnTheFly) {
        if (manager == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(10);
        }
        if (identifier == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(11);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)identifier, InspectionsBundle.message("inspection.parameter.can.be.local.problem.descriptor", new Object[0]), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly, this.createFix());
        if (problemDescriptor == null) {
            ParameterCanBeLocalInspectionBase.$$$reportNull$$$0(12);
        }
        return problemDescriptor;
    }

    protected LocalQuickFix createFix() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFinal";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWriteBeforeRead";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterParameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

