/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreFileTypeRegistry
extends FileTypeRegistry {
    private final Map<String, FileType> myExtensionsMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
    private final List<FileType> myAllFileTypes = new ArrayList<FileType>();

    public CoreFileTypeRegistry() {
        this.myAllFileTypes.add(UnknownFileType.INSTANCE);
    }

    @Override
    public boolean isFileIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Override
    @NotNull
    public FileType[] getRegisteredFileTypes() {
        FileType[] fileTypeArray = this.myAllFileTypes.toArray(new FileType[this.myAllFileTypes.size()]);
        if (fileTypeArray == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(1);
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(2);
        }
        if (file instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file).getAssignedFileType()) != null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                CoreFileTypeRegistry.$$$reportNull$$$0(3);
            }
            return fileType2;
        }
        FileType fileType3 = this.getFileTypeByFileName(file.getName());
        if (fileType3 == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(4);
        }
        return fileType3;
    }

    @Override
    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(5);
        }
        String extension = FileUtilRt.getExtension(fileName);
        FileType fileType = this.getFileTypeByExtension(extension);
        if (fileType == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(6);
        }
        return fileType;
    }

    @Override
    @NotNull
    public FileType getFileTypeByExtension(@NonNls @NotNull String extension) {
        FileType result;
        if (extension == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(7);
        }
        FileType fileType = (result = this.myExtensionsMap.get(extension)) == null ? UnknownFileType.INSTANCE : result;
        if (fileType == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull @NonNls String extension) {
        if (fileType == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(9);
        }
        if (extension == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(10);
        }
        this.myAllFileTypes.add(fileType);
        for (String ext : extension.split(";")) {
            this.myExtensionsMap.put(ext, fileType);
        }
    }

    @Override
    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(11);
        }
        FileType fileType = UnknownFileType.INSTANCE;
        if (fileType == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    @Override
    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            CoreFileTypeRegistry.$$$reportNull$$$0(13);
        }
        for (FileType type : this.myAllFileTypes) {
            if (!type.getName().equals(fileTypeName)) continue;
            return type;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/core/CoreFileTypeRegistry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/core/CoreFileTypeRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileTypeFromContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectFileTypeFromContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

