/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathSaveItem;
import com.intellij.openapi.module.impl.SaveItem;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManagerImpl
extends ModuleManager
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    public static final String ELEMENT_MODULES = "modules";
    public static final String ELEMENT_MODULE = "module";
    public static final String ATTRIBUTE_FILEURL = "fileurl";
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    public static final String ATTRIBUTE_GROUP = "group";
    public static final String IML_EXTENSION = ".iml";
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.module.impl.ModuleManagerImpl");
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create("DisposedNeverAddedModuleName");
    public static final String MODULE_GROUP_SEPARATOR = "/";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    protected volatile ModuleModelImpl myModuleModel;
    private LinkedHashSet<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths;
    private final Map<String, UnloadedModuleDescriptionImpl> myUnloadedModules;
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance(project);
    }

    public ModuleManagerImpl(@NotNull Project project) {
        if (project == null) {
            ModuleManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModuleModel = new ModuleModelImpl(this);
        this.myFailedModulePaths = new THashSet();
        this.myUnloadedModules = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>();
        this.myProject = project;
        this.myMessageBus = project.getMessageBus();
    }

    @Override
    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectOpened();
        }
    }

    @Override
    public void projectClosed() {
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    @Override
    public void dispose() {
        this.myModuleModel.disposeModel();
    }

    @Override
    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    @Override
    public void loadState(Element state) {
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = ModuleManagerImpl.getPathsToModuleFiles(state);
        HashSet<String> unloadedModuleNames = new HashSet<String>(UnloadedModulesListStorage.getInstance(this.myProject).getUnloadedModuleNames());
        Iterator iterator = this.myModulePathsToLoad.iterator();
        ArrayList<ModulePath> unloadedModulePaths = new ArrayList<ModulePath>();
        while (iterator.hasNext()) {
            ModulePath modulePath = (ModulePath)iterator.next();
            if (!unloadedModuleNames.contains(modulePath.getModuleName())) continue;
            unloadedModulePaths.add(modulePath);
            iterator.remove();
        }
        List<UnloadedModuleDescriptionImpl> descriptions = UnloadedModuleDescriptionImpl.createFromPaths(unloadedModulePaths, this);
        this.myUnloadedModules.clear();
        for (UnloadedModuleDescriptionImpl description : descriptions) {
            this.myUnloadedModules.put(description.getName(), description);
        }
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model = this.getModifiableModel();
        Module[] existingModules = model.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        THashMap modulePathMap = new THashMap(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
            if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
        }
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(model::commit);
        this.myModulePathsToLoad.clear();
    }

    @NotNull
    public static LinkedHashSet<ModulePath> getPathsToModuleFiles(@NotNull Element element) {
        if (element == null) {
            ModuleManagerImpl.$$$reportNull$$$0(1);
        }
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Element moduleElement : modules.getChildren(ELEMENT_MODULE)) {
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH) : VirtualFileManager.extractPath(fileUrlValue);
                paths.add(new ModulePath(FileUtilRt.toSystemIndependentName(filepath), moduleElement.getAttributeValue(ATTRIBUTE_GROUP)));
            }
        }
        LinkedHashSet<ModulePath> linkedHashSet = paths;
        if (linkedHashSet == null) {
            ModuleManagerImpl.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(3);
        }
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ProgressIndicator progressIndicator = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator.setText("Loading modules...");
        progressIndicator.setText2("");
        List<ModuleLoadingErrorDescription> errors = Collections.synchronizedList(new ArrayList());
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        ExecutorService service = AppExecutorUtil.createBoundedApplicationPoolExecutor("modules loader", JobSchedulerImpl.CORES_COUNT);
        ArrayList<Pair<Object, ModulePath>> tasks = new ArrayList<Pair<Object, ModulePath>>();
        THashSet paths = new THashSet();
        boolean parallel = Registry.is("parallel.modules.loading") && !ApplicationManager.getApplication().isDispatchThread();
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator.isCanceled()) break;
            String string = modulePath.getPath();
            if (!paths.add(string)) continue;
            if (!parallel) {
                tasks.add(Pair.create(null, modulePath));
                continue;
            }
            tasks.add(Pair.create(service.submit(() -> {
                if (moduleModel == null) {
                    ModuleManagerImpl.$$$reportNull$$$0(45);
                }
                progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
                return ProgressManager.getInstance().runProcess(() -> {
                    if (moduleModel == null) {
                        ModuleManagerImpl.$$$reportNull$$$0(46);
                    }
                    try {
                        return this.myProject.isDisposed() ? null : moduleModel.loadModuleInternal(string);
                    }
                    catch (IOException e) {
                        this.reportError(errors, modulePath, e);
                    }
                    catch (Exception e) {
                        LOG.error(e);
                    }
                    return null;
                }, (ProgressIndicator)ProgressWrapper.wrap(progressIndicator));
            }), modulePath));
        }
        SmartList<Module> modulesWithUnknownTypes = new SmartList<Module>();
        for (Pair pair : tasks) {
            if (progressIndicator.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module;
                if (parallel) {
                    module = (Module)((Future)pair.first).get();
                } else {
                    module = moduleModel.loadModuleInternal(((ModulePath)pair.second).getPath());
                    progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
                }
                if (module == null) continue;
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = (modulePath = (ModulePath)pair.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPathString.split(MODULE_GROUP_SEPARATOR));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (IOException e) {
                this.reportError(errors, (ModulePath)pair.second, e);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        service.shutdown();
        progressIndicator.checkCanceled();
        Application application = ApplicationManager.getApplication();
        if (application.isInternal() || application.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            THashMap tHashMap = new THashMap();
            for (Module module : moduleModel.getModules()) {
                for (String url : ModuleRootManager.getInstance(module).getContentRootUrls()) {
                    Module oldModule = tHashMap.put(url, module);
                    if (oldModule == null) continue;
                    LOG.error("Module '" + module.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification(modulesWithUnknownTypes);
    }

    private void reportError(List<ModuleLoadingErrorDescription> errors, ModulePath modulePath, Exception e) {
        errors.add(new ModuleLoadingErrorDescription(ProjectBundle.message("module.cannot.load.error", modulePath.getPath(), e.getMessage()), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(4);
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<Module> types) {
        if (types == null) {
            ModuleManagerImpl.$$$reportNull$$$0(5);
        }
    }

    protected void fireModuleAdded(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(6);
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).moduleAdded(this.myProject, module);
    }

    protected void fireModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(7);
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(8);
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(9);
        }
        if (oldNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(10);
        }
        if (!modules.isEmpty()) {
            this.myMessageBus.syncPublisher(ProjectTopics.MODULES).modulesRenamed(this.myProject, modules, oldNames::get);
        }
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<ModuleLoadingErrorDescription> errors) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(11);
        }
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(12);
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(moduleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            ModuleEx module = moduleModel.getModuleByFilePath(error.getModulePath().getPath());
            if (module == null) continue;
            moduleModel.myModules.remove(module.getName());
            ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose(module), module.getDisposed());
        }
        this.fireModuleLoadErrors(errors);
    }

    protected void fireModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(14);
        }
        this.myFailedModulePaths.remove(modulePath);
    }

    @Override
    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            ModuleManagerImpl.$$$reportNull$$$0(15);
        }
        return moduleModelImpl;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ModuleManagerImpl.$$$reportNull$$$0(16);
        }
        Module[] collection = this.getModules();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.length + this.myFailedModulePaths.size() + this.myUnloadedModules.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        for (UnloadedModuleDescriptionImpl description : this.myUnloadedModules.values()) {
            sorted.add(new ModulePathSaveItem(description.getModulePath()));
        }
        if (!sorted.isEmpty()) {
            Collections.sort(sorted, Comparator.comparing(SaveItem::getModuleName));
            Element modules = new Element(ELEMENT_MODULES);
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element.addContent(modules);
        }
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(17);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(18);
        }
        return module2;
    }

    @Override
    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(19);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(20);
        }
        return module2;
    }

    @Override
    public void disposeModule(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module == null) {
                ModuleManagerImpl.$$$reportNull$$$0(44);
            }
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module);
            modifiableModel.commit();
        });
    }

    @Override
    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            ModuleManagerImpl.$$$reportNull$$$0(22);
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(23);
        }
        return this.myCachedSortedModules;
    }

    @Override
    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            ModuleManagerImpl.$$$reportNull$$$0(24);
        }
        return this.myModuleModel.findModuleByName(name);
    }

    @Override
    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator = this.myCachedModuleComparator;
        if (comparator == null) {
            ModuleManagerImpl.$$$reportNull$$$0(25);
        }
        return comparator;
    }

    protected void deliverPendingEvents() {
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            ModuleManagerImpl.$$$reportNull$$$0(26);
        }
        return graph;
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph(includeTests);
        if (graph == null) {
            ModuleManagerImpl.$$$reportNull$$$0(27);
        }
        return graph;
    }

    @Override
    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(28);
        }
        SmartList<Module> result = new SmartList<Module>();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module)) continue;
            result.add(aModule);
        }
        SmartList<Module> smartList = result;
        if (smartList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(29);
        }
        return smartList;
    }

    @Override
    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(30);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(32);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(33);
        }
        return ModuleRootManager.getInstance(module).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module == null) {
                ModuleManagerImpl.$$$reportNull$$$0(43);
            }
            if (!module.isLoaded()) {
                module.moduleAdded();
                this.fireModuleAdded(module);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, Runnable runnable) {
        if (model == null) {
            ModuleManagerImpl.$$$reportNull$$$0(35);
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(ModuleModelImpl moduleModel, Runnable runnable) {
        THashSet removedModules;
        THashSet addedModules;
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        THashSet newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new THashSet(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new THashSet(oldModules);
            removedModules.removeAll((Collection<?>)newModules);
        }
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(() -> this.lambda$commitModel$5((Collection)removedModules, moduleModel, oldModules, runnable, (Collection)addedModules), false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module, @NotNull String oldName) {
        Module moduleInMap;
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(36);
        }
        if (oldName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(37);
        }
        LOG.assertTrue((moduleInMap = this.myModuleModel.myModules.remove(oldName)) == null || moduleInMap == module);
        this.myModuleModel.myModules.put(module.getName(), module);
        this.incModificationCount();
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(() -> {
            if (module == null) {
                ModuleManagerImpl.$$$reportNull$$$0(41);
            }
            if (oldName == null) {
                ModuleManagerImpl.$$$reportNull$$$0(42);
            }
            this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName));
        }, false, true);
    }

    @Override
    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(38);
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    @Override
    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    @Override
    public Collection<ModuleDescription> getAllModuleDescriptions() {
        Module[] modules = this.getModules();
        ArrayList<ModuleDescription> descriptions = new ArrayList<ModuleDescription>(modules.length + this.myUnloadedModules.size());
        for (Module module : modules) {
            descriptions.add(new LoadedModuleDescriptionImpl(module));
        }
        descriptions.addAll(this.myUnloadedModules.values());
        return descriptions;
    }

    @Override
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        return Collections.unmodifiableCollection(this.myUnloadedModules.values());
    }

    @Override
    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull String moduleName) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(39);
        }
        return this.myUnloadedModules.get(moduleName);
    }

    @Override
    public void setUnloadedModules(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(40);
        }
        if (this.myUnloadedModules.keySet().equals(unloadedModuleNames)) {
            return;
        }
        UnloadedModulesListStorage.getInstance(this.myProject).setUnloadedModuleNames(unloadedModuleNames);
        ModifiableModuleModel model = this.getModifiableModel();
        LinkedHashMap<String, UnloadedModuleDescriptionImpl> toLoad = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>(this.myUnloadedModules);
        this.myUnloadedModules.clear();
        for (String name : unloadedModuleNames) {
            if (toLoad.containsKey(name)) {
                this.myUnloadedModules.put(name, (UnloadedModuleDescriptionImpl)toLoad.remove(name));
                continue;
            }
            Module module = this.findModuleByName(name);
            if (module == null) continue;
            LoadedModuleDescriptionImpl description = new LoadedModuleDescriptionImpl(module);
            ModuleSaveItem saveItem = new ModuleSaveItem(module);
            ModulePath modulePath = new ModulePath(saveItem.getModuleFilePath(), saveItem.getGroupPathString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            List<VirtualFilePointer> contentRoots = ContainerUtil.map(ModuleRootManager.getInstance(module).getContentRootUrls(), url -> pointerManager.create((String)url, (Disposable)this, null));
            UnloadedModuleDescriptionImpl unloadedModuleDescription = new UnloadedModuleDescriptionImpl(modulePath, description.getDependencyModuleNames(), contentRoots);
            ServiceKt.getStateStore(module).save(new ArrayList<Pair<StateStorage.SaveSession, VirtualFile>>());
            model.disposeModule(module);
            this.myUnloadedModules.put(name, unloadedModuleDescription);
        }
        ArrayList<ModulePath> oldFailedPaths = new ArrayList<ModulePath>(this.myFailedModulePaths);
        this.myModulePathsToLoad = toLoad.values().stream().map(UnloadedModuleDescriptionImpl::getModulePath).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(model::commit);
        this.myFailedModulePaths.addAll(oldFailedPaths);
        this.myModulePathsToLoad.clear();
    }

    public void setModuleGroupPath(Module module, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    private /* synthetic */ void lambda$commitModel$5(Collection removedModules, ModuleModelImpl moduleModel, Collection oldModules, Runnable runnable, Collection addedModules) {
        for (Object removedModule : removedModules) {
            this.fireBeforeModuleRemoved((Module)removedModule);
            this.cleanCachedStuff();
        }
        if (!moduleModel.myModulesToDispose.isEmpty()) {
            ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
            neverAddedModules.removeAll(oldModules);
            for (Module neverAddedModule : neverAddedModules) {
                neverAddedModule.putUserData(DISPOSED_MODULE_NAME, neverAddedModule.getName());
                Disposer.dispose(neverAddedModule);
            }
        }
        if (runnable != null) {
            runnable.run();
        }
        Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
        Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
        modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
        ArrayList<Module> modules = new ArrayList<Module>();
        HashMap<Module, String> oldNames = ContainerUtil.newHashMap();
        for (Module module : modulesToBeRenamed) {
            oldNames.put(module, module.getName());
            moduleModel.myModules.remove(module.getName());
            modules.add(module);
            ((ModuleEx)module).rename((String)modulesToNewNamesMap.get(module), true);
            moduleModel.myModules.put(module.getName(), module);
            this.myUnloadedModules.remove(module.getName());
        }
        moduleModel.myIsWritable = false;
        this.myModuleModel = moduleModel;
        for (Module module : removedModules) {
            this.fireModuleRemoved(module);
            this.cleanCachedStuff();
            Disposer.dispose(module);
            this.cleanCachedStuff();
        }
        for (Module addedModule : addedModules) {
            this.myUnloadedModules.remove(addedModule.getName());
            ((ModuleEx)addedModule).moduleAdded();
            this.cleanCachedStuff();
            this.fireModuleAdded(addedModule);
            this.cleanCachedStuff();
        }
        this.cleanCachedStuff();
        this.fireModulesRenamed(modules, oldNames);
        this.cleanCachedStuff();
        UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance(this.myProject);
        unloadedModulesListStorage.setUnloadedModuleNames(ContainerUtil.filter(unloadedModulesListStorage.getUnloadedModuleNames(), this.myUnloadedModules::containsKey));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 3: 
            case 11: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 21: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MODULE;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MODULES;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onModule";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModuleNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToModuleFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedModules";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleDependencyComparator";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleGraph";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToModuleFiles";
                break;
            }
            case 2: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownModuleType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showUnknownModuleTypeNotification";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAdded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeModuleRemoved";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fireModulesRenamed";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onModuleLoadErrors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleLoadErrors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeFailedModulePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "disposeModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDependentModules";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependent";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependsOn";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAddedInWriteAction";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "commitModelWithRunnable";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRenamedByVfsEvent";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGroupPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModules";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fireModuleRenamedByVfsEvent$6";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fireModuleAddedInWriteAction$4";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$disposeModule$3";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadModules$1";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager) {
            if (manager == null) {
                ModuleModelImpl.$$$reportNull$$$0(0);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap<Module, String>();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap<String, Module>();
            this.myManager = manager;
            this.myIsWritable = false;
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            if (that == null) {
                ModuleModelImpl.$$$reportNull$$$0(1);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap<Module, String>();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap<String, Module>();
            this.myManager = that.myManager;
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, "Attempt to modify committed ModifiableModuleModel");
        }

        @Override
        @NotNull
        public Module[] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules = this.myModules.values();
                cache = modules.toArray(new Module[modules.size()]);
                this.myModulesCache = cache;
            }
            if (cache == null) {
                ModuleModelImpl.$$$reportNull$$$0(2);
            }
            return cache;
        }

        @NotNull
        private Module[] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                ModuleModelImpl.$$$reportNull$$$0(3);
            }
            return allModules;
        }

        @Override
        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(4);
            }
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(5);
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message("module.already.exists.error", newName), newName);
            }
        }

        @Override
        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(6);
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            Module moduleToBeRenamed;
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(7);
            }
            if ((moduleToBeRenamed = this.getModuleToBeRenamed(newName)) != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        @Override
        public String getNewName(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(8);
            }
            return this.myModuleToNewName.get(module);
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(9);
            }
            Module module = this.newModule(filePath, moduleTypeId, null);
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(10);
            }
            return module;
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(11);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(12);
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName(ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module != null) {
                ModuleEx moduleEx = module;
                if (moduleEx == null) {
                    ModuleModelImpl.$$$reportNull$$$0(13);
                }
                return moduleEx;
            }
            ModuleEx newModule = module = this.myManager.createModule(filePath);
            String finalFilePath = filePath;
            this.initModule(module, () -> {
                if (moduleTypeId == null) {
                    ModuleModelImpl.$$$reportNull$$$0(29);
                }
                ((ModuleStore)((Object)ServiceKt.getStateStore(newModule))).setPath(finalFilePath, true);
                newModule.setModuleType(moduleTypeId);
                if (options != null) {
                    for (Map.Entry option : options.entrySet()) {
                        newModule.setOption((String)option.getKey(), (String)option.getValue());
                    }
                }
            });
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(14);
            }
            return moduleEx;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(15);
            }
            try {
                string = FileUtil.resolveShortWindowsName(filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    ModuleModelImpl.$$$reportNull$$$0(17);
                }
                return string2;
            }
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(16);
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull String filePath) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(18);
            }
            for (Module module : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module.getModuleFilePath().equals(filePath) : module.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module;
            }
            return null;
        }

        @Override
        @NotNull
        public Module loadModule(@NotNull String filePath) throws IOException {
            Module module;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(19);
            }
            this.assertWritable();
            String resolvedPath = FileUtilRt.toSystemIndependentName(ModuleModelImpl.resolveShortWindowsName(filePath));
            try {
                ModuleEx module2 = this.getModuleByFilePath(resolvedPath);
                module = module2 == null ? this.loadModuleInternal(resolvedPath) : module2;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectBundle.message("module.corrupted.file.error", FileUtilRt.toSystemDependentName(resolvedPath), e.getMessage()), e);
            }
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(20);
            }
            return module;
        }

        @NotNull
        private Module loadModuleInternal(@NotNull String filePath) throws IOException {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(21);
            }
            StandardFileSystems.local().refreshAndFindFileByPath(filePath);
            Module module = ReadAction.compute(() -> {
                if (filePath == null) {
                    ModuleModelImpl.$$$reportNull$$$0(27);
                }
                ModuleEx module = this.myManager.createAndLoadModule(filePath);
                this.initModule(module, () -> {
                    if (filePath == null) {
                        ModuleModelImpl.$$$reportNull$$$0(28);
                    }
                    ((ModuleStore)((Object)ServiceKt.getStateStore(module))).setPath(filePath, false);
                });
                return module;
            });
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(22);
            }
            return module;
        }

        private void initModule(@NotNull ModuleEx module, @Nullable Runnable beforeComponentCreation) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(23);
            }
            module.init(beforeComponentCreation);
            this.myModulesCache = null;
            this.myModules.put(module.getName(), module);
        }

        @Override
        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(24);
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module.getName()) != null) {
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        @Override
        public Module findModuleByName(@NotNull String name) {
            Module module;
            if (name == null) {
                ModuleModelImpl.$$$reportNull$$$0(25);
            }
            if ((module = this.myModules.get(name)) != null && !module.isDisposed()) {
                return module;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder<Module> builder = new DFSTBuilder<Module>(this.moduleGraph(true));
            return builder.comparator();
        }

        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<Module>(){

                @Override
                public Collection<Module> getNodes() {
                    return myModules.values();
                }

                @Override
                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance(m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        @Override
        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(Runnable runnable) {
            this.myManager.commitModel(this, runnable);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        @Override
        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            THashSet existingModules = new THashSet(Arrays.asList(this.myManager.myModuleModel.getModules()));
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose(thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose(moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        @Override
        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            return !this.myModules.equals(this.myManager.myModuleModel.myModules) || !Comparing.equal(this.myManager.myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            Module[] modules = this.getModules();
            this.myModulesCache = null;
            for (Module module : modules) {
                Disposer.dispose(module);
            }
            this.myModules.clear();
            this.myModuleGroupPath = null;
        }

        @Override
        public String[] getModuleGroupPath(Module module) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        @Override
        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        @Override
        public void setModuleGroupPath(@NotNull Module module, @Nullable(value="null means remove") String[] groupPath) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(26);
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 4: 
                case 8: 
                case 23: 
                case 24: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 9: 
                case 11: 
                case 15: 
                case 18: 
                case 19: 
                case 21: 
                case 27: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 12: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleTypeId";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedModules";
                    break;
                }
                case 10: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newModule";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveShortWindowsName";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadModule";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadModuleInternal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "renameModule";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleToBeRenamed";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByNewName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewName";
                    break;
                }
                case 9: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "newModule";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveShortWindowsName";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByFilePath";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "loadModule";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "loadModuleInternal";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "initModule";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeModule";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "findModuleByName";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "setModuleGroupPath";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$loadModuleInternal$2";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$1";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$newModule$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        ModuleSaveItem(Module module) {
            if (module == null) {
                ModuleSaveItem.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join(groupPath, ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleGroupInterner {
        private final StringInterner groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module, @Nullable String[] group) {
            String[] cached;
            if (model == null) {
                ModuleGroupInterner.$$$reportNull$$$0(0);
            }
            if (module == null) {
                ModuleGroupInterner.$$$reportNull$$$0(1);
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i2 = 0; i2 < group.length; ++i2) {
                    String g = group[i2];
                    cached[i2] = this.groups.intern(g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module, cached);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner";
            objectArray[2] = "setModuleGroupPath";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

