/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.text.StringFactory;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamUtil {
    private static final Logger LOG = Logger.getInstance(StreamUtil.class);

    private StreamUtil() {
    }

    public static int copyStreamContent(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int count;
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            StreamUtil.$$$reportNull$$$0(1);
        }
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    @NotNull
    public static byte[] loadFromStream(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(2);
        }
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.copyStreamContent(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
        byte[] byArray = outputStream.toByteArray();
        if (byArray == null) {
            StreamUtil.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(4);
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        String string = new String(data);
        if (string == null) {
            StreamUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(6);
        }
        if (encoding == null) {
            StreamUtil.$$$reportNull$$$0(7);
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        String string = new String(data, encoding);
        if (string == null) {
            StreamUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull Charset encoding) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(9);
        }
        if (encoding == null) {
            StreamUtil.$$$reportNull$$$0(10);
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        String string = new String(data, encoding);
        if (string == null) {
            StreamUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String convertSeparators(@NotNull String s) {
        if (s == null) {
            StreamUtil.$$$reportNull$$$0(12);
        }
        String string = StringFactory.createShared(StreamUtil.convertSeparators(s.toCharArray()));
        if (string == null) {
            StreamUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static char[] readTextAndConvertSeparators(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            StreamUtil.$$$reportNull$$$0(14);
        }
        char[] buffer = StreamUtil.readText(reader);
        char[] cArray = StreamUtil.convertSeparators(buffer);
        if (cArray == null) {
            StreamUtil.$$$reportNull$$$0(15);
        }
        return cArray;
    }

    @NotNull
    private static char[] convertSeparators(@NotNull char[] buffer) {
        if (buffer == null) {
            StreamUtil.$$$reportNull$$$0(16);
        }
        int dst = 0;
        int prev = 32;
        for (int n : buffer) {
            switch (n) {
                case 13: {
                    buffer[dst++] = 10;
                    break;
                }
                case 10: {
                    if (prev == 13) break;
                    buffer[dst++] = 10;
                    break;
                }
                default: {
                    buffer[dst++] = n;
                }
            }
            prev = n;
        }
        if (dst == buffer.length) {
            if (buffer == null) {
                StreamUtil.$$$reportNull$$$0(17);
            }
            return buffer;
        }
        char[] result = new char[dst];
        System.arraycopy(buffer, 0, result, 0, result.length);
        if (result == null) {
            StreamUtil.$$$reportNull$$$0(18);
        }
        return result;
    }

    @NotNull
    public static String readTextFrom(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            StreamUtil.$$$reportNull$$$0(19);
        }
        String string = StringFactory.createShared(StreamUtil.readText(reader));
        if (string == null) {
            StreamUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static char[] readText(@NotNull Reader reader) throws IOException {
        int read2;
        if (reader == null) {
            StreamUtil.$$$reportNull$$$0(21);
        }
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[2048];
        while ((read2 = reader.read(buffer)) >= 0) {
            writer.write(buffer, 0, read2);
        }
        char[] cArray = writer.toCharArray();
        if (cArray == null) {
            StreamUtil.$$$reportNull$$$0(22);
        }
        return cArray;
    }

    public static void closeStream(@Nullable Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/StreamUtil";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/StreamUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromStream";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readText";
                break;
            }
            case 13: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeparators";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readTextAndConvertSeparators";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "readTextFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyStreamContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readText";
                break;
            }
            case 12: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertSeparators";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readTextAndConvertSeparators";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readTextFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

