/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DocumentCommitThread
implements Runnable,
Disposable,
DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DocumentCommitThread");
    private static final String SYNC_COMMIT_REASON = "Sync commit";
    private final ExecutorService executor = new BoundedTaskExecutor("Document committing pool", PooledThreadExecutor.INSTANCE, 1, this);
    private final Object lock = new Object();
    private final HashSetQueue<CommitTask> documentsToCommit = new HashSetQueue();
    private final HashSetQueue<CommitTask> documentsToApplyInEDT = new HashSetQueue();
    private final ApplicationEx myApplication;
    private volatile boolean isDisposed;
    private CommitTask currentTask;
    private boolean myEnabled;
    private static final Key<Object> CANCEL_REASON = Key.create("CANCEL_REASON");
    private static final Key<Lock> DOCUMENT_LOCK = Key.create("DOCUMENT_LOCK");

    public static DocumentCommitThread getInstance() {
        return (DocumentCommitThread)ServiceManager.getService(DocumentCommitProcessor.class);
    }

    public DocumentCommitThread(ApplicationEx application) {
        this.myApplication = application;
        application.invokeLater(() -> {
            if (application.isDisposed()) {
                return;
            }
            assert (!application.isWriteAccessAllowed() || application.isUnitTestMode());
            application.addApplicationListener(new ApplicationAdapter(){

                @Override
                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DocumentCommitThread.this.disable("Write action started: " + action);
                }

                @Override
                public void afterWriteActionFinished(@NotNull Object action) {
                    if (action == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DocumentCommitThread.this.enable("Write action finished: " + action);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "action";
                    objectArray2[1] = "com/intellij/psi/impl/DocumentCommitThread$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeWriteActionStart";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "afterWriteActionFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, this);
            this.enable("Listener installed, started");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.isDisposed = true;
        Object object = this.lock;
        synchronized (object) {
            this.documentsToCommit.clear();
        }
        this.cancel("Stop thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(0);
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancel(reason);
            this.myEnabled = false;
        }
        this.log(null, "disabled", null, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(1);
        }
        Object object = this.lock;
        synchronized (object) {
            this.myEnabled = true;
            this.wakeUpQueue();
        }
        this.log(null, "enabled", null, reason);
    }

    private void wakeUpQueue() {
        if (!this.isDisposed && !this.documentsToCommit.isEmpty()) {
            this.executor.execute(this);
        }
    }

    private void cancel(@NonNls @NotNull Object reason) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(2);
        }
        this.startNewTask(null, reason);
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason, @Nullable TransactionId context) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(3);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(4);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(5);
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getCachedPsiFile(document);
        if (psiFile == null || psiFile instanceof PsiCompiledElement) {
            return;
        }
        this.doQueue(project, document, DocumentCommitThread.getAllFileNodes(psiFile), reason, context, PsiDocumentManager.getInstance(project).getLastCommittedText(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @Nullable TransactionId context, @NotNull CharSequence lastCommittedText) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(6);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(7);
        }
        if (oldFileNodes == null) {
            DocumentCommitThread.$$$reportNull$$$0(8);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(9);
        }
        if (lastCommittedText == null) {
            DocumentCommitThread.$$$reportNull$$$0(10);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!project.isInitialized()) {
                return;
            }
            CommitTask newTask = this.createNewTaskAndCancelSimilar(project, document, oldFileNodes, reason, context, lastCommittedText);
            this.documentsToCommit.offer(newTask);
            this.log(project, "Queued", newTask, reason);
            this.wakeUpQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CommitTask createNewTaskAndCancelSimilar(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @Nullable TransactionId context, @NotNull CharSequence lastCommittedText) {
        Pair<PsiFileImpl, FileASTNode> pair;
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(11);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(12);
        }
        if (oldFileNodes == null) {
            DocumentCommitThread.$$$reportNull$$$0(13);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(14);
        }
        if (lastCommittedText == null) {
            DocumentCommitThread.$$$reportNull$$$0(15);
        }
        Object object = this.lock;
        // MONITORENTER : object
        Iterator<Pair<PsiFileImpl, FileASTNode>> iterator = oldFileNodes.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                CommitTask newTask = new CommitTask(project, document, oldFileNodes, this.createProgressIndicator(), reason, context, lastCommittedText);
                this.cancelAndRemoveFromDocsToCommit(newTask, reason);
                this.cancelAndRemoveCurrentTask(newTask, reason);
                this.cancelAndRemoveFromDocsToApplyInEDT(newTask, reason);
                CommitTask commitTask = newTask;
                // MONITOREXIT : object
                if (commitTask != null) return commitTask;
                DocumentCommitThread.$$$reportNull$$$0(16);
                return commitTask;
            }
            pair = iterator.next();
            assert (((PsiFileImpl)pair.first).getProject() == project);
        }
    }

    public void log(Project project, @NonNls String msg, @Nullable CommitTask task, Object ... args) {
    }

    private void cancelAll() {
        String reason = "Cancel all in tests";
        this.cancel(reason);
        for (CommitTask commitTask : this.documentsToCommit) {
            commitTask.cancel(reason, this);
            this.log(commitTask.project, "Removed from background queue", commitTask, new Object[0]);
        }
        this.documentsToCommit.clear();
        for (CommitTask commitTask : this.documentsToApplyInEDT) {
            commitTask.cancel(reason, this);
            this.log(commitTask.project, "Removed from EDT apply queue (sync commit called)", commitTask, new Object[0]);
        }
        this.documentsToApplyInEDT.clear();
        CommitTask task = this.currentTask;
        if (task != null) {
            this.cancelAndRemoveFromDocsToCommit(task, reason);
        }
        this.cancel("Sync commit intervened");
        ((BoundedTaskExecutor)this.executor).clearAndCancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelAll();
            this.wakeUpQueue();
        }
    }

    private void cancelAndRemoveCurrentTask(@NotNull CommitTask newTask, @NotNull Object reason) {
        CommitTask currentTask;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(17);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(18);
        }
        if ((currentTask = this.currentTask) != null && currentTask.equals(newTask)) {
            this.cancelAndRemoveFromDocsToCommit(currentTask, reason);
            this.cancel(reason);
        }
    }

    private void cancelAndRemoveFromDocsToApplyInEDT(@NotNull CommitTask newTask, @NotNull Object reason) {
        boolean removed;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(19);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(20);
        }
        if (removed = this.cancelAndRemoveFromQueue(newTask, this.documentsToApplyInEDT, reason)) {
            this.log(newTask.project, "Removed from EDT apply queue", newTask, new Object[0]);
        }
    }

    private void cancelAndRemoveFromDocsToCommit(@NotNull CommitTask newTask, @NotNull Object reason) {
        boolean removed;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(21);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(22);
        }
        if (removed = this.cancelAndRemoveFromQueue(newTask, this.documentsToCommit, reason)) {
            this.log(newTask.project, "Removed from background queue", newTask, new Object[0]);
        }
    }

    private boolean cancelAndRemoveFromQueue(@NotNull CommitTask newTask, @NotNull HashSetQueue<CommitTask> queue, @NotNull Object reason) {
        CommitTask queuedTask;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(23);
        }
        if (queue == null) {
            DocumentCommitThread.$$$reportNull$$$0(24);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(25);
        }
        if ((queuedTask = queue.find(newTask)) != null) {
            assert (queuedTask != newTask);
            queuedTask.cancel(reason, this);
        }
        return queue.remove(newTask);
    }

    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                boolean polled = this.pollQueue();
                if (polled) continue;
                break;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollQueue() {
        assert (!this.myApplication.isDispatchThread()) : Thread.currentThread();
        boolean success = false;
        Document document = null;
        Project project = null;
        CommitTask task = null;
        Object failureReason = null;
        try {
            ProgressIndicator indicator;
            Object object = this.lock;
            synchronized (object) {
                if (!this.myEnabled || (task = this.documentsToCommit.poll()) == null) {
                    return false;
                }
                document = task.getDocument();
                indicator = task.indicator;
                project = task.project;
                if (project.isDisposed() || !((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).isInUncommittedSet(document)) {
                    this.log(project, "Abandon and proceed to next", task, new Object[0]);
                    return true;
                }
                if (indicator.isCanceled()) {
                    return true;
                }
                this.startNewTask(task, "Pulled new task");
                this.documentsToApplyInEDT.add(task);
            }
            if (indicator.isCanceled()) {
                success = false;
            } else {
                CommitTask commitTask = task;
                Ref result = new Ref();
                ProgressManager.getInstance().executeProcessUnderProgress(() -> result.set(this.commitUnderProgress(commitTask, false)), indicator);
                Runnable finishRunnable = (Runnable)((Pair)result.get()).first;
                success = finishRunnable != null;
                failureReason = ((Pair)result.get()).second;
                if (success) {
                    assert (!this.myApplication.isDispatchThread());
                    TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                    guard.submitTransaction(project, task.myCreationContext, finishRunnable);
                }
            }
        }
        catch (ProcessCanceledException e) {
            this.cancel(e + " (cancel reason: " + ((UserDataHolder)((Object)task.indicator)).getUserData(CANCEL_REASON) + ")");
            success = false;
            failureReason = e;
        }
        catch (Throwable e) {
            this.cancel(e);
            failureReason = ExceptionUtil.getThrowableText(e);
        }
        if (!success && task != null) {
            Project finalProject = project;
            Document finalDocument = document;
            String finalFailureReason = failureReason;
            CommitTask finalTask = task;
            ReadAction.run(() -> {
                List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes;
                if (finalProject.isDisposed()) {
                    return;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(finalProject);
                if (documentManager.isCommitted(finalDocument)) {
                    return;
                }
                CharSequence lastCommittedText = documentManager.getLastCommittedText(finalDocument);
                PsiFile file = documentManager.getPsiFile(finalDocument);
                List<Pair<PsiFileImpl, FileASTNode>> list = oldFileNodes = file == null ? null : DocumentCommitThread.getAllFileNodes(file);
                if (oldFileNodes != null) {
                    this.doQueue(finalProject, finalDocument, oldFileNodes, "re-added on failure: " + finalFailureReason, finalTask.myCreationContext, lastCommittedText);
                }
            });
        }
        Object object = this.lock;
        synchronized (object) {
            this.currentTask = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        CommitTask task;
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(26);
        }
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(27);
        }
        if (psiFile == null) {
            DocumentCommitThread.$$$reportNull$$$0(28);
        }
        assert (!this.isDisposed);
        if (!project.isInitialized() && !project.isDefault()) {
            String s = project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            try {
                Disposer.dispose(project);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        List<Pair<PsiFileImpl, FileASTNode>> allFileNodes = DocumentCommitThread.getAllFileNodes(psiFile);
        Lock documentLock = DocumentCommitThread.getDocumentLock(document);
        Object object = this.lock;
        synchronized (object) {
            task = this.createNewTaskAndCancelSimilar(project, document, allFileNodes, SYNC_COMMIT_REASON, TransactionGuard.getInstance().getContextTransaction(), PsiDocumentManager.getInstance(project).getLastCommittedText(document));
            documentLock.lock();
        }
        try {
            assert (!task.indicator.isCanceled());
            Pair<Runnable, Object> result = this.commitUnderProgress(task, true);
            Runnable finish = (Runnable)result.first;
            this.log(project, "Committed sync", task, finish, task.indicator);
            assert (finish != null);
            finish.run();
        }
        finally {
            documentLock.unlock();
        }
    }

    @NotNull
    private static List<Pair<PsiFileImpl, FileASTNode>> getAllFileNodes(@NotNull PsiFile file) {
        if (file == null) {
            DocumentCommitThread.$$$reportNull$$$0(29);
        }
        if (!file.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)file, "File " + file + " is invalid, can't commit");
        }
        if (file instanceof PsiCompiledFile) {
            throw new IllegalArgumentException("Can't commit ClsFile: " + file);
        }
        List<Pair<PsiFileImpl, FileASTNode>> list = ContainerUtil.map(file.getViewProvider().getAllFiles(), root -> Pair.create((PsiFileImpl)root, root.getNode()));
        if (list == null) {
            DocumentCommitThread.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StandardProgressIndicatorBase standardProgressIndicatorBase = new StandardProgressIndicatorBase();
        if (standardProgressIndicatorBase == null) {
            DocumentCommitThread.$$$reportNull$$$0(31);
        }
        return standardProgressIndicatorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(@Nullable CommitTask task, @NotNull Object reason) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(32);
        }
        Object object = this.lock;
        synchronized (object) {
            CommitTask cur = this.currentTask;
            if (cur != null) {
                cur.cancel(reason, this);
            }
            this.currentTask = task;
        }
    }

    @NotNull
    private Pair<Runnable, Object> commitUnderProgress(@NotNull CommitTask task, boolean synchronously) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(33);
        }
        if (synchronously) assert (!task.indicator.isCanceled());
        Document document = task.getDocument();
        Project project = task.project;
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        SmartList<Processor<Document>> finishProcessors = new SmartList<Processor<Document>>();
        Runnable runnable = () -> {
            if (task == null) {
                DocumentCommitThread.$$$reportNull$$$0(71);
            }
            this.myApplication.assertReadAccessAllowed();
            if (project.isDisposed()) {
                return;
            }
            Lock lock = DocumentCommitThread.getDocumentLock(document);
            if (!lock.tryLock()) {
                task.cancel("Can't obtain document lock", this);
                return;
            }
            boolean canceled = false;
            try {
                if (documentManager.isCommitted(document)) {
                    return;
                }
                if (!task.isStillValid()) {
                    canceled = true;
                    return;
                }
                FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
                if (viewProvider == null) {
                    finishProcessors.add(this.handleCommitWithoutPsi(documentManager, task));
                    return;
                }
                for (Pair<PsiFileImpl, FileASTNode> pair : task.myOldFileNodes) {
                    PsiFileImpl file = (PsiFileImpl)pair.first;
                    if (file.isValid()) {
                        FileASTNode oldFileNode = (FileASTNode)pair.second;
                        Processor<Document> finishProcessor = this.doCommit(task, file, oldFileNode);
                        if (finishProcessor == null) continue;
                        finishProcessors.add(finishProcessor);
                        continue;
                    }
                    if (task.reason.equals(SYNC_COMMIT_REASON)) {
                        throw new PsiInvalidElementAccessException((PsiElement)file, "File " + file + " invalidated during sync commit");
                    }
                    this.commitAsynchronously(project, document, "File " + file + " invalidated during background commit; task: " + task, task.myCreationContext);
                }
            }
            finally {
                lock.unlock();
                if (canceled) {
                    task.cancel("Task invalidated", this);
                }
            }
        };
        if (synchronously) {
            runnable.run();
        } else if (!this.myApplication.tryRunReadAction(runnable)) {
            this.log(project, "Could not start read action", task, this.myApplication.isReadAccessAllowed(), Thread.currentThread());
            Pair<Object, String> pair = new Pair<Object, String>(null, "Could not start read action");
            if (pair == null) {
                DocumentCommitThread.$$$reportNull$$$0(34);
            }
            return pair;
        }
        boolean canceled = task.indicator.isCanceled();
        assert (!synchronously || !canceled);
        if (canceled) {
            Pair<Object, String> pair = new Pair<Object, String>(null, "Indicator was canceled");
            if (pair == null) {
                DocumentCommitThread.$$$reportNull$$$0(35);
            }
            return pair;
        }
        Runnable result = this.createEdtRunnable(task, synchronously, finishProcessors);
        Pair<Runnable, Object> pair = Pair.create(result, null);
        if (pair == null) {
            DocumentCommitThread.$$$reportNull$$$0(36);
        }
        return pair;
    }

    @NotNull
    private Runnable createEdtRunnable(@NotNull CommitTask task, boolean synchronously, @NotNull List<Processor<Document>> finishProcessors) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(37);
        }
        if (finishProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(38);
        }
        Runnable runnable = () -> {
            boolean success;
            if (task == null) {
                DocumentCommitThread.$$$reportNull$$$0(69);
            }
            if (finishProcessors == null) {
                DocumentCommitThread.$$$reportNull$$$0(70);
            }
            this.myApplication.assertIsDispatchThread();
            Document document = task.getDocument();
            Project project = task.project;
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
            boolean committed = project.isDisposed() || documentManager.isCommitted(document);
            Object object = this.lock;
            synchronized (object) {
                this.documentsToApplyInEDT.remove(task);
                if (committed) {
                    this.log(project, "Marked as already committed in EDT apply queue, return", task, new Object[0]);
                    return;
                }
            }
            boolean changeStillValid = task.isStillValid();
            boolean bl = success = changeStillValid && documentManager.finishCommit(document, finishProcessors, synchronously, task.reason);
            if (synchronously) assert (success);
            if (!changeStillValid) {
                this.log(project, "document changed; ignore", task, new Object[0]);
                return;
            }
            if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
            if (success) {
                this.log(project, "Commit finished", task, new Object[0]);
            } else {
                this.commitAsynchronously(project, document, "Re-added back", task.myCreationContext);
            }
        };
        if (runnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(39);
        }
        return runnable;
    }

    @NotNull
    private Processor<Document> handleCommitWithoutPsi(@NotNull PsiDocumentManagerBase documentManager, @NotNull CommitTask task) {
        if (documentManager == null) {
            DocumentCommitThread.$$$reportNull$$$0(40);
        }
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(41);
        }
        Processor<Document> processor = document -> {
            if (task == null) {
                DocumentCommitThread.$$$reportNull$$$0(67);
            }
            if (documentManager == null) {
                DocumentCommitThread.$$$reportNull$$$0(68);
            }
            this.log(task.project, "Finishing without PSI", task, new Object[0]);
            if (!task.isStillValid() || documentManager.getCachedViewProvider((Document)document) != null) {
                return false;
            }
            documentManager.handleCommitWithoutPsi((Document)document);
            return true;
        };
        if (processor == null) {
            DocumentCommitThread.$$$reportNull$$$0(42);
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.myEnabled;
        }
    }

    public String toString() {
        return "Document commit thread; application: " + this.myApplication + "; isDisposed: " + this.isDisposed + "; myEnabled: " + this.isEnabled();
    }

    public void waitForAllCommits() throws ExecutionException, InterruptedException, TimeoutException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(100L, TimeUnit.SECONDS);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Nullable(value="returns runnable to execute under write action in AWT to finish the commit")
    public Processor<Document> doCommit(@NotNull CommitTask task, @NotNull PsiFile file, @NotNull FileASTNode oldFileNode) {
        Document document;
        CharSequence newDocumentText;
        TextRange changedPsiRange;
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(43);
        }
        if (file == null) {
            DocumentCommitThread.$$$reportNull$$$0(44);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(45);
        }
        if ((changedPsiRange = DocumentCommitThread.getChangedPsiRange(file, task, newDocumentText = (document = task.getDocument()).getImmutableCharSequence())) == null) {
            return null;
        }
        Boolean data = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data);
        }
        BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
        DiffLog diffLog = blockSupport.reparseRange(file, oldFileNode, changedPsiRange, newDocumentText, task.indicator, task.myLastCommittedText);
        return document1 -> {
            if (file == null) {
                DocumentCommitThread.$$$reportNull$$$0(64);
            }
            if (task == null) {
                DocumentCommitThread.$$$reportNull$$$0(65);
            }
            if (oldFileNode == null) {
                DocumentCommitThread.$$$reportNull$$$0(66);
            }
            FileViewProvider viewProvider = file.getViewProvider();
            if (!task.isStillValid() || ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject())).getCachedViewProvider((Document)document1) != viewProvider) {
                return false;
            }
            if (file.isPhysical() && !ApplicationManager.getApplication().isWriteAccessAllowed()) {
                VirtualFile vFile = viewProvider.getVirtualFile();
                LOG.error("Write action expected; document=" + document1 + "; file=" + file + " of " + file.getClass() + "; file.valid=" + file.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + file.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + AbstractFileViewProvider.isFreeThreaded(viewProvider));
            }
            DocumentCommitThread.doActualPsiChange(file, diffLog);
            this.assertAfterCommit((Document)document1, file, (FileElement)oldFileNode);
            return true;
        };
    }

    private static int getLeafMatchingLength(CharSequence leafText, CharSequence pattern, int patternIndex, int finalPatternIndex, int direction) {
        int leafIndex = direction == 1 ? 0 : leafText.length() - 1;
        int finalLeafIndex = direction == 1 ? leafText.length() - 1 : 0;
        int result = 0;
        while (leafText.charAt(leafIndex) == pattern.charAt(patternIndex)) {
            ++result;
            if (leafIndex == finalLeafIndex || patternIndex == finalPatternIndex) break;
            leafIndex += direction;
            patternIndex += direction;
        }
        return result;
    }

    private static int getMatchingLength(@NotNull FileElement treeElement, @NotNull CharSequence text2, boolean fromStart) {
        if (treeElement == null) {
            DocumentCommitThread.$$$reportNull$$$0(46);
        }
        if (text2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(47);
        }
        int patternIndex = fromStart ? 0 : text2.length() - 1;
        int finalPatternIndex = fromStart ? text2.length() - 1 : 0;
        int direction = fromStart ? 1 : -1;
        ASTNode leaf = fromStart ? TreeUtil.findFirstLeaf(treeElement, false) : TreeUtil.findLastLeaf(treeElement, false);
        int result = 0;
        while (leaf != null && (fromStart ? patternIndex <= finalPatternIndex : patternIndex >= finalPatternIndex)) {
            CharSequence chars;
            if (!(leaf instanceof ForeignLeafPsiElement) && (chars = leaf.getChars()).length() > 0) {
                int matchingLength = DocumentCommitThread.getLeafMatchingLength(chars, text2, patternIndex, finalPatternIndex, direction);
                result += matchingLength;
                if (matchingLength != chars.length()) break;
                patternIndex += fromStart ? matchingLength : -matchingLength;
            }
            leaf = fromStart ? TreeUtil.nextLeaf(leaf, false) : TreeUtil.prevLeaf(leaf, false);
        }
        return result;
    }

    @Nullable
    public static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull FileElement treeElement, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            DocumentCommitThread.$$$reportNull$$$0(48);
        }
        if (treeElement == null) {
            DocumentCommitThread.$$$reportNull$$$0(49);
        }
        if (newDocumentText == null) {
            DocumentCommitThread.$$$reportNull$$$0(50);
        }
        int psiLength = treeElement.getTextLength();
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, true);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, false), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    @Nullable
    private static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull CommitTask task, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            DocumentCommitThread.$$$reportNull$$$0(51);
        }
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(52);
        }
        if (newDocumentText == null) {
            DocumentCommitThread.$$$reportNull$$$0(53);
        }
        CharSequence oldDocumentText = task.myLastCommittedText;
        int psiLength = oldDocumentText.length();
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        List<DocumentEvent> events = ((PsiDocumentManagerBase)PsiDocumentManagerBase.getInstance(file.getProject())).getEventsSinceCommit(task.document);
        int prefix = Integer.MAX_VALUE;
        int suffix = Integer.MAX_VALUE;
        int lengthBeforeEvent = psiLength;
        for (DocumentEvent event : events) {
            prefix = Math.min(prefix, event.getOffset());
            suffix = Math.min(suffix, lengthBeforeEvent - event.getOffset() - event.getOldLength());
            lengthBeforeEvent = lengthBeforeEvent - event.getOldLength() + event.getNewLength();
        }
        if ((prefix == psiLength || suffix == psiLength) && newDocumentText.length() == psiLength) {
            return null;
        }
        int shortestLength = Math.min(psiLength, newDocumentText.length());
        while (prefix < shortestLength && oldDocumentText.charAt(prefix) == newDocumentText.charAt(prefix)) {
            ++prefix;
        }
        while (suffix < shortestLength - prefix && oldDocumentText.charAt(psiLength - suffix - 1) == newDocumentText.charAt(newDocumentText.length() - suffix - 1)) {
            ++suffix;
        }
        TextRange changedPsiRange = TextRange.create(prefix, Math.max(prefix, psiLength - suffix));
        return changedPsiRange;
    }

    public static void doActualPsiChange(final @NotNull PsiFile file, final @NotNull DiffLog diffLog) {
        if (file == null) {
            DocumentCommitThread.$$$reportNull$$$0(54);
        }
        if (diffLog == null) {
            DocumentCommitThread.$$$reportNull$$$0(55);
        }
        CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(() -> {
            if (file == null) {
                DocumentCommitThread.$$$reportNull$$$0(62);
            }
            if (diffLog == null) {
                DocumentCommitThread.$$$reportNull$$$0(63);
            }
            FileViewProvider viewProvider = file.getViewProvider();
            PsiLock psiLock = ((AbstractFileViewProvider)viewProvider).getFilePsiLock();
            synchronized (psiLock) {
                viewProvider.beforeContentsSynchronized();
                Document document = viewProvider.getDocument();
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject());
                PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                if (transaction == null) {
                    final PomModel model = PomManager.getModel(file.getProject());
                    model.runTransaction(new PomTransactionBase(file, model.getModelAspect(TreeAspect.class)){

                        @Override
                        public PomModelEvent runInner() {
                            return new TreeAspectEvent(model, diffLog.performActualPsiChange(file));
                        }
                    });
                } else {
                    diffLog.performActualPsiChange(file);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file, @NotNull FileElement oldFileNode) {
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(56);
        }
        if (file == null) {
            DocumentCommitThread.$$$reportNull$$$0(57);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(58);
        }
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file.getText();
            boolean sameText = Comparing.equal(fileText, documentText);
            LOG.error("commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency(file, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + file.getName() + "; type:" + file.getFileType() + "; lang:" + file.getLanguage());
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file, file.getNode(), new TextRange(0, documentText.length()), documentText, this.createProgressIndicator(), oldFileNode.getText());
                DocumentCommitThread.doActualPsiChange(file, diffLog);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file);
                }
            }
            finally {
                file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static Lock getDocumentLock(Document document) {
        Lock lock = document.getUserData(DOCUMENT_LOCK);
        return lock != null ? lock : (Lock)((UserDataHolderEx)((Object)document)).putUserDataIfAbsent(DOCUMENT_LOCK, new ReentrantLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTasksOnProjectDispose(@NotNull Project project) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(59);
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancelTasksOnProjectDispose(project, this.documentsToCommit);
            this.cancelTasksOnProjectDispose(project, this.documentsToApplyInEDT);
        }
    }

    private void cancelTasksOnProjectDispose(@NotNull Project project, @NotNull HashSetQueue<CommitTask> queue) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(60);
        }
        if (queue == null) {
            DocumentCommitThread.$$$reportNull$$$0(61);
        }
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            CommitTask commitTask = (CommitTask)iterator.next();
            if (commitTask.project != project) continue;
            iterator.remove();
            commitTask.cancel("project is disposed", this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 27: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 26: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNodes";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommittedText";
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTask";
                break;
            }
            case 24: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 29: 
            case 44: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 52: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 38: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 40: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 45: 
            case 58: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDocumentText";
                break;
            }
            case 55: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTaskAndCancelSimilar";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNodes";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicator";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "commitUnderProgress";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdtRunnable";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCommitWithoutPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "disable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commitAsynchronously";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doQueue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNewTaskAndCancelSimilar";
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveCurrentTask";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveFromDocsToApplyInEDT";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveFromDocsToCommit";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveFromQueue";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "commitSynchronously";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAllFileNodes";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "startNewTask";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "commitUnderProgress";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createEdtRunnable";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingLength";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getChangedPsiRange";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "doActualPsiChange";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "assertAfterCommit";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "cancelTasksOnProjectDispose";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doActualPsiChange$8";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCommit$7";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleCommitWithoutPsi$6";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createEdtRunnable$5";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitUnderProgress$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CommitTask {
        @NotNull
        private final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        final ProgressIndicator indicator;
        @NotNull
        final Object reason;
        @Nullable
        final TransactionId myCreationContext;
        private final CharSequence myLastCommittedText;
        @NotNull
        final List<Pair<PsiFileImpl, FileASTNode>> myOldFileNodes;

        CommitTask(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull ProgressIndicator indicator, @Nullable Object reason, @NotNull TransactionId context, CharSequence lastCommittedText) {
            if (project == null) {
                CommitTask.$$$reportNull$$$0(0);
            }
            if (document == null) {
                CommitTask.$$$reportNull$$$0(1);
            }
            if (oldFileNodes == null) {
                CommitTask.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                CommitTask.$$$reportNull$$$0(3);
            }
            if (reason == null) {
                CommitTask.$$$reportNull$$$0(4);
            }
            if (lastCommittedText == null) {
                CommitTask.$$$reportNull$$$0(5);
            }
            this.document = document;
            this.project = project;
            this.indicator = indicator;
            this.reason = reason;
            this.myCreationContext = context;
            this.myLastCommittedText = lastCommittedText;
            this.myOldFileNodes = oldFileNodes;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NonNls
        public String toString() {
            Document document = this.getDocument();
            String docInfo = document + " (\"" + StringUtil.first(document.getImmutableCharSequence(), 40, true).toString().replaceAll("\n", " ") + "\")";
            String indicatorInfo = this.indicator.isCanceled() ? " (Canceled: " + ((UserDataHolder)((Object)this.indicator)).getUserData(CANCEL_REASON) + ")" : "";
            String reasonInfo = " Reason: " + this.reason + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)document).getModificationSequence());
            return "Doc: " + docInfo + indicatorInfo + reasonInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return Comparing.equal(this.getDocument(), task.getDocument()) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result = this.getDocument().hashCode();
            result = 31 * result + this.project.hashCode();
            return result;
        }

        boolean isStillValid() {
            Document document = this.getDocument();
            return ((DocumentEx)document).getModificationSequence() == this.modificationSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel(@NotNull Object reason, @NotNull DocumentCommitThread commitProcessor) {
            if (reason == null) {
                CommitTask.$$$reportNull$$$0(6);
            }
            if (commitProcessor == null) {
                CommitTask.$$$reportNull$$$0(7);
            }
            if (!this.indicator.isCanceled()) {
                commitProcessor.log(this.project, "indicator cancel", this, new Object[0]);
                this.indicator.cancel();
                ((UserDataHolder)((Object)this.indicator)).putUserData(CANCEL_REASON, reason);
                Object object = DocumentCommitThread.this.lock;
                synchronized (object) {
                    DocumentCommitThread.this.documentsToCommit.remove(this);
                    DocumentCommitThread.this.documentsToApplyInEDT.remove(this);
                }
            }
        }

        @NotNull
        Document getDocument() {
            Document document = this.document;
            if (document == null) {
                CommitTask.$$$reportNull$$$0(8);
            }
            return document;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldFileNodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastCommittedText";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitProcessor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/DocumentCommitThread$CommitTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/DocumentCommitThread$CommitTask";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "cancel";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

