/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeImpl
extends XmlElementImpl
implements XmlAttribute,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.xml.XmlAttributeImpl");
    private final int myHC = ourHC++;
    private volatile String myDisplayText;
    private volatile int[] myGapDisplayStarts;
    private volatile int[] myGapPhysicalStarts;
    private volatile TextRange myValueTextRange;

    public final int hashCode() {
        return this.myHC;
    }

    public XmlAttributeImpl() {
        super(XmlElementType.XML_ATTRIBUTE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == XmlTokenType.XML_NAME) {
            return 229;
        }
        if (i2 == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return 243;
        }
        return 0;
    }

    @Override
    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)((Object)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this));
    }

    @Override
    public void setValue(String valueText) throws IncorrectOperationException {
        final ASTNode value = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
        final PomModel model = PomManager.getModel(this.getProject());
        XmlAttribute attribute = XmlElementFactory.getInstance(this.getProject()).createAttribute("a", valueText, this);
        final ASTNode newValue = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild((ASTNode)((Object)attribute));
        XmlAspect aspect = model.getModelAspect(XmlAspect.class);
        model.runTransaction(new PomTransactionBase(this, aspect){

            @Override
            public PomModelEvent runInner() {
                XmlAttributeImpl att = XmlAttributeImpl.this;
                if (value != null) {
                    if (newValue != null) {
                        att.replaceChild(value, newValue.copyElement());
                    } else {
                        att.removeChild(value);
                    }
                } else if (newValue != null) {
                    att.addChild(newValue.getTreePrev().copyElement());
                    att.addChild(newValue.copyElement());
                }
                return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlAttributeImpl.this.getParent(), XmlAttributeImpl.this.getName(), newValue != null ? newValue.getText() : null);
            }
        });
    }

    @Override
    public XmlElement getNameElement() {
        return (XmlElement)((Object)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this));
    }

    @Override
    @NotNull
    public String getNamespace() {
        String name = this.getName();
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName(name);
        if (prefixByQualifiedName.isEmpty()) {
            if ("" == null) {
                XmlAttributeImpl.$$$reportNull$$$0(0);
            }
            return "";
        }
        String string = this.getParent().getNamespaceByPrefix(prefixByQualifiedName);
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        String string = XmlUtil.findPrefixByQualifiedName(this.getName());
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @Override
    @NotNull
    public String getLocalName() {
        String string = XmlUtil.findLocalNameByQualifiedName(this.getName());
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlAttributeImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    protected void appendChildToDisplayValue(StringBuilder buffer, ASTNode child) {
        buffer.append(child.getChars());
    }

    @Override
    public String getDisplayValue() {
        String displayText = this.myDisplayText;
        if (displayText != null) {
            return displayText;
        }
        XmlAttributeValue value = this.getValueElement();
        if (value == null) {
            return null;
        }
        PsiElement firstChild = value.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        ASTNode child = firstChild.getNode();
        TextRange valueTextRange = new TextRange(0, value.getTextLength());
        if (child != null && child.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            valueTextRange = new TextRange(child.getTextLength(), valueTextRange.getEndOffset());
            child = child.getTreeNext();
        }
        TIntArrayList gapsStarts = new TIntArrayList();
        TIntArrayList gapsShifts = new TIntArrayList();
        StringBuilder buffer = new StringBuilder(this.getTextLength());
        while (child != null) {
            int start = buffer.length();
            IElementType elementType = child.getElementType();
            if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                valueTextRange = new TextRange(valueTextRange.getStartOffset(), child.getTextRange().getStartOffset() - value.getTextRange().getStartOffset());
                break;
            }
            if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                buffer.append(XmlUtil.getCharFromEntityRef(child.getText()));
            } else if (elementType == XmlElementType.XML_ENTITY_REF) {
                buffer.append(XmlUtil.getEntityValue((XmlEntityRef)((Object)child)));
            } else {
                this.appendChildToDisplayValue(buffer, child);
            }
            int end = buffer.length();
            int originalLength = child.getTextLength();
            if (end - start != originalLength) {
                gapsStarts.add(start);
                gapsShifts.add(originalLength - (end - start));
            }
            child = child.getTreeNext();
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray(gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray(gapsShifts.size());
        int currentGapsSum = 0;
        for (int i2 = 0; i2 < gapDisplayStarts.length; ++i2) {
            gapDisplayStarts[i2] = gapsStarts.get(i2);
            gapPhysicalStarts[i2] = gapDisplayStarts[i2] + (currentGapsSum += gapsShifts.get(i2));
        }
        this.myGapDisplayStarts = gapDisplayStarts;
        this.myGapPhysicalStarts = gapPhysicalStarts;
        this.myValueTextRange = valueTextRange;
        this.myDisplayText = buffer.toString();
        return this.myDisplayText;
    }

    @Override
    public int physicalToDisplay(int physicalIndex) {
        this.getDisplayValue();
        if (physicalIndex < 0 || physicalIndex > this.myValueTextRange.getLength()) {
            return -1;
        }
        if (this.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapPhysicalStarts, physicalIndex);
        int gapIndex = bsResult > 0 ? bsResult : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return physicalIndex;
        }
        int shift = this.myGapPhysicalStarts[gapIndex] - this.myGapDisplayStarts[gapIndex];
        return Math.max(this.myGapDisplayStarts[gapIndex], physicalIndex - shift);
    }

    @Override
    public int displayToPhysical(int displayIndex) {
        String displayValue = this.getDisplayValue();
        if (displayValue == null || displayIndex < 0 || displayIndex > displayValue.length()) {
            return -1;
        }
        if (this.myGapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapDisplayStarts, displayIndex);
        int gapIndex = bsResult > 0 ? bsResult - 1 : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return displayIndex;
        }
        int shift = this.myGapPhysicalStarts[gapIndex] - this.myGapDisplayStarts[gapIndex];
        return displayIndex + shift;
    }

    @Override
    @NotNull
    public TextRange getValueTextRange() {
        this.getDisplayValue();
        TextRange textRange = this.myValueTextRange;
        if (textRange == null) {
            XmlAttributeImpl.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myDisplayText = null;
        this.myGapDisplayStarts = null;
        this.myGapPhysicalStarts = null;
        this.myValueTextRange = null;
    }

    @Override
    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        String string = element != null ? element.getText() : "";
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isNamespaceDeclaration() {
        String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    @Override
    public PsiElement setName(final @NotNull String nameText) throws IncorrectOperationException {
        if (nameText == null) {
            XmlAttributeImpl.$$$reportNull$$$0(7);
        }
        final ASTNode name = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
        final String oldName = name.getText();
        final String oldValue = ObjectUtils.notNull(this.getValue(), "");
        final PomModel model = PomManager.getModel(this.getProject());
        final XmlAttribute attribute = XmlElementFactory.getInstance(this.getProject()).createAttribute(nameText, oldValue, this);
        final ASTNode newName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild((ASTNode)((Object)attribute));
        XmlAspect aspect = model.getModelAspect(XmlAspect.class);
        final Ref<XmlAttributeImpl> replaced = Ref.create(this);
        model.runTransaction(new PomTransactionBase(this.getParent(), aspect){

            @Override
            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                PsiFile file = XmlAttributeImpl.this.getContainingFile();
                XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(model, file instanceof XmlFile ? (XmlFile)file : null);
                xmlAspectChangeSet.add(new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), oldName, null));
                xmlAspectChangeSet.add(new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), nameText, oldValue));
                event.registerChangeSet(model.getModelAspect(XmlAspect.class), xmlAspectChangeSet);
                if (!oldValue.isEmpty() && XmlAttributeImpl.this.getLanguage().isKindOf(HTMLLanguage.INSTANCE)) {
                    CodeEditUtil.replaceChild(XmlAttributeImpl.this.getTreeParent(), XmlAttributeImpl.this, attribute.getNode());
                    replaced.set(attribute);
                } else {
                    CodeEditUtil.replaceChild(XmlAttributeImpl.this, name, newName);
                }
                return event;
            }
        });
        return replaced.get();
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    @Override
    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlAttributeImpl.$$$reportNull$$$0(8);
        }
        return false;
    }

    @Override
    @Deprecated
    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            XmlAttributeImpl.$$$reportNull$$$0(9);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull PsiReferenceService.Hints hints) {
        PsiReference[] refs;
        XmlElement nameElement;
        if (hints == null) {
            XmlAttributeImpl.$$$reportNull$$$0(10);
        }
        if (hints.offsetInElement != null && ((nameElement = this.getNameElement()) == null || hints.offsetInElement > nameElement.getStartOffsetInParent() + nameElement.getTextLength())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                XmlAttributeImpl.$$$reportNull$$$0(11);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] referencesFromProviders = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        if (this.isNamespaceDeclaration()) {
            refs = new PsiReference[referencesFromProviders.length + 1];
            String localName = this.getLocalName();
            String prefix = XmlUtil.findPrefixByQualifiedName(this.getName());
            TextRange range = prefix.isEmpty() ? TextRange.from(this.getName().length(), 0) : TextRange.from(prefix.length() + 1, localName.length());
            refs[0] = new SchemaPrefixReference(this, range, localName, null);
        } else {
            String prefix = this.getNamespacePrefix();
            if (!prefix.isEmpty() && !this.getLocalName().isEmpty()) {
                refs = new PsiReference[referencesFromProviders.length + 2];
                refs[0] = new SchemaPrefixReference(this, TextRange.from(0, prefix.length()), prefix, null);
                refs[1] = new XmlAttributeReference(this);
            } else {
                refs = new PsiReference[referencesFromProviders.length + 1];
                refs[0] = new XmlAttributeReference(this);
            }
        }
        System.arraycopy(referencesFromProviders, 0, refs, refs.length - referencesFromProviders.length, referencesFromProviders.length);
        if (refs == null) {
            XmlAttributeImpl.$$$reportNull$$$0(12);
        }
        return refs;
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        XmlTag parentElement = this.getParent();
        if (parentElement == null) {
            return null;
        }
        XmlTag tag = parentElement;
        XmlElementDescriptor descr = tag.getDescriptor();
        if (descr == null) {
            return null;
        }
        XmlAttributeDescriptor attributeDescr = descr.getAttributeDescriptor(this);
        return attributeDescr == null ? descr.getAttributeDescriptor(this.getName(), tag) : attributeDescr;
    }

    public String getRealLocalName() {
        String name = this.getLocalName();
        return name.endsWith("IntellijIdeaRulezzz") ? name.substring(0, name.length() - "IntellijIdeaRulezzz".length()) : name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameText";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePrefix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalName";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

