/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import org.jetbrains.annotations.NotNull;

public class DoubleArrayList
implements Cloneable {
    private double[] myData;
    private int mySize;

    public DoubleArrayList(int initialCapacity) {
        this.myData = new double[initialCapacity];
    }

    public DoubleArrayList(@NotNull DoubleArrayList init) {
        if (init == null) {
            DoubleArrayList.$$$reportNull$$$0(0);
        }
        this.myData = new double[init.myData.length];
        System.arraycopy(init.myData, 0, this.myData, 0, init.myData.length);
        this.mySize = init.mySize;
    }

    public DoubleArrayList() {
        this(10);
    }

    public void trimToSize() {
        int oldCapacity = this.myData.length;
        if (this.mySize < oldCapacity) {
            double[] oldData = this.myData;
            this.myData = new double[this.mySize];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            double[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new double[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(double elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(double elem) {
        for (int i2 = 0; i2 < this.mySize; ++i2) {
            if (elem != this.myData[i2]) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(double elem) {
        for (int i2 = this.mySize - 1; i2 >= 0; --i2) {
            if (elem != this.myData[i2]) continue;
            return i2;
        }
        return -1;
    }

    public Object clone() {
        try {
            DoubleArrayList v = (DoubleArrayList)super.clone();
            v.myData = new double[this.mySize];
            System.arraycopy(this.myData, 0, v.myData, 0, this.mySize);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public double[] toArray() {
        double[] result = new double[this.mySize];
        System.arraycopy(this.myData, 0, result, 0, this.mySize);
        return result;
    }

    public double[] toArray(double[] a) {
        if (a.length < this.mySize) {
            a = new double[this.mySize];
        }
        System.arraycopy(this.myData, 0, a, 0, this.mySize);
        return a;
    }

    public double get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public double set(int index, double element) {
        this.checkRange(index);
        double oldValue = this.myData[index];
        this.myData[index] = element;
        return oldValue;
    }

    public void add(double o) {
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = o;
    }

    public void add(int index, double element) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.myData[index] = element;
        ++this.mySize;
    }

    public double remove(int index) {
        this.checkRange(index);
        double oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "init", "com/intellij/util/containers/DoubleArrayList", "<init>"));
    }
}

