/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.DefaultXmlNamespaceHelper;
import com.intellij.xml.XmlBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlNamespaceHelper {
    private static final ExtensionPointName<XmlNamespaceHelper> EP_NAME = new ExtensionPointName("com.intellij.xml.namespaceHelper");
    public static final XmlNamespaceHelper DEFAULT_EXTENSION = new DefaultXmlNamespaceHelper();

    public static XmlNamespaceHelper getHelper(PsiFile file) {
        for (XmlNamespaceHelper extension : Extensions.getExtensions(EP_NAME)) {
            if (!extension.isAvailable(file)) continue;
            return extension;
        }
        return DEFAULT_EXTENSION;
    }

    protected abstract boolean isAvailable(PsiFile var1);

    @Nullable
    public String getNamespacePrefix(PsiElement element) {
        PsiElement tag;
        XmlAttribute attribute;
        String prefix;
        if (element instanceof XmlAttribute && !StringUtil.isEmpty(prefix = (attribute = (XmlAttribute)element).getNamespacePrefix())) {
            return prefix;
        }
        PsiElement psiElement = tag = element instanceof XmlTag ? element : element.getParent();
        if (tag instanceof XmlTag) {
            return ((XmlTag)tag).getNamespacePrefix();
        }
        return null;
    }

    public abstract void insertNamespaceDeclaration(@NotNull XmlFile var1, @Nullable Editor var2, @NonNls @NotNull Set<String> var3, @NonNls @Nullable String var4, @Nullable Runner<String, IncorrectOperationException> var5) throws IncorrectOperationException;

    public boolean qualifyWithPrefix(String namespacePrefix, PsiElement element, Document document) throws IncorrectOperationException {
        PsiElement tag;
        PsiElement psiElement = tag = element instanceof XmlTag ? element : element.getParent();
        if (tag instanceof XmlTag) {
            String prefix = ((XmlTag)tag).getNamespacePrefix();
            if (!prefix.equals(namespacePrefix)) {
                String name = namespacePrefix + ":" + ((XmlTag)tag).getLocalName();
                ((XmlTag)tag).setName(name);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public abstract Set<String> guessUnboundNamespaces(@NotNull PsiElement var1, XmlFile var2);

    @NotNull
    public abstract Set<String> getNamespacesByTagName(@NotNull String var1, @NotNull XmlFile var2);

    public String getNamespaceAlias(@NotNull XmlFile file) {
        if (file == null) {
            XmlNamespaceHelper.$$$reportNull$$$0(0);
        }
        return XmlBundle.message("namespace.alias", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlNamespaceHelper", "getNamespaceAlias"));
    }

    public static interface Runner<P, T extends Throwable> {
        public void run(P var1) throws T;
    }
}

