/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class StringEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.comparison.display.name", new Object[0]);
        if (string == null) {
            StringEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            StringEqualityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualityVisitor();
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = EqualityToEqualsFix.buildEqualityFixes((PsiBinaryExpression)infos[0]);
        if (inspectionGadgetsFixArray == null) {
            StringEqualityInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/StringEqualityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ObjectEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualityVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ObjectEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!ExpressionUtils.hasStringType(lhs)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (!ExpressionUtils.hasStringType(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/StringEqualityInspection$ObjectEqualityVisitor", "visitBinaryExpression"));
        }
    }
}

