/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarargParameterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("VariableArgumentMethod" == null) {
            VarargParameterInspection.$$$reportNull$$$0(0);
        }
        return "VariableArgumentMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("variable.argument.method.display.name", new Object[0]);
        if (string == null) {
            VarargParameterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("variable.argument.method.problem.descriptor", new Object[0]);
        if (string == null) {
            VarargParameterInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new VarargParameterFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VarargParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/jdk/VarargParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class VarargParameterVisitor
    extends BaseInspectionVisitor {
        private VarargParameterVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameter[] parameters;
            if (method == null) {
                VarargParameterVisitor.$$$reportNull$$$0(0);
            }
            if ((parameters = method.getParameterList().getParameters()).length == 0) {
                return;
            }
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (lastParameter.isVarArgs()) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterVisitor", "visitMethod"));
        }
    }

    private static class VarargParameterFix
    extends InspectionGadgetsFix {
        private VarargParameterFix() {
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("variable.argument.method.quickfix", new Object[0]);
            if (string == null) {
                VarargParameterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)element.getParent();
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return;
            }
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiTypeElement typeElement = lastParameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            Collection<PsiReference> references = ReferencesSearch.search(method).findAll();
            ArrayList<PsiElement> prepare = new ArrayList<PsiElement>();
            prepare.add(parameterList);
            for (PsiReference reference : references) {
                prepare.add(reference.getElement());
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(prepare)) {
                return;
            }
            WriteAction.run(() -> {
                String typeText;
                PsiEllipsisType type = (PsiEllipsisType)lastParameter.getType();
                PsiType componentType = type.getComponentType();
                if (componentType instanceof PsiClassType) {
                    PsiClassType classType = (PsiClassType)componentType;
                    typeText = classType.rawType().getCanonicalText();
                } else {
                    typeText = componentType.getCanonicalText();
                }
                for (PsiReference reference : references) {
                    VarargParameterFix.modifyCall(reference, typeText, parameters.length - 1);
                }
                PsiType arrayType = type.toArrayType();
                PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory(lastParameter.getProject()).createTypeElement(arrayType);
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, "java.lang.SafeVarargs");
                if (annotation != null) {
                    annotation.delete();
                }
                typeElement.replace(newTypeElement);
            });
        }

        public static void modifyCall(PsiReference reference, String arrayTypeText, int indexOfFirstVarargArgument) {
            PsiElement element = reference.getElement();
            PsiCall call = (PsiCall)(element instanceof PsiCall ? element : element.getParent());
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > indexOfFirstVarargArgument && ExpressionUtils.isNullLiteral(arguments[indexOfFirstVarargArgument]) && indexOfFirstVarargArgument + 1 == arguments.length) {
                return;
            }
            StringBuilder builder = new StringBuilder("new ").append(arrayTypeText).append("[]{");
            if (arguments.length > indexOfFirstVarargArgument) {
                PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
                builder.append(firstArgument.getText());
                for (int i2 = indexOfFirstVarargArgument + 1; i2 < arguments.length; ++i2) {
                    builder.append(',').append(arguments[i2].getText());
                }
            }
            builder.append('}');
            Project project = element.getProject();
            PsiExpression arrayExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(builder.toString(), element);
            if (arguments.length > indexOfFirstVarargArgument) {
                PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
                argumentList.deleteChildRange(firstArgument, arguments[arguments.length - 1]);
                argumentList.add(arrayExpression);
            } else {
                argumentList.add(arrayExpression);
            }
            JavaCodeStyleManager.getInstance(project).shortenClassReferences(argumentList);
            CodeStyleManager.getInstance(project).reformat(argumentList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/VarargParameterInspection$VarargParameterFix", "getFamilyName"));
        }
    }
}

