/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TailRecursionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("tail.recursion.display.name", new Object[0]);
        if (string == null) {
            TailRecursionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("tail.recursion.problem.descriptor", new Object[0]);
        if (string == null) {
            TailRecursionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod containingMethod = (PsiMethod)infos[0];
        if (!TailRecursionInspection.mayBeReplacedByIterativeMethod(containingMethod)) {
            return null;
        }
        return new RemoveTailRecursionFix();
    }

    private static boolean mayBeReplacedByIterativeMethod(PsiMethod containingMethod) {
        PsiParameter[] parameters;
        if (containingMethod.isVarArgs()) {
            return false;
        }
        for (PsiParameter parameter : parameters = containingMethod.getParameterList().getParameters()) {
            if (!parameter.hasModifierProperty("final")) continue;
            return false;
        }
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TailRecursionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/TailRecursionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TailRecursionVisitor
    extends BaseInspectionVisitor {
        private TailRecursionVisitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                TailRecursionVisitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(statement);
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(statement.getReturnValue());
            if (!(returnValue instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression returnCall = (PsiMethodCallExpression)returnValue;
            PsiReferenceExpression methodExpression = returnCall.getMethodExpression();
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, true, PsiClass.class, PsiLambdaExpression.class);
            if (containingMethod == null) {
                return;
            }
            JavaResolveResult resolveResult = returnCall.resolveMethodGenerics();
            if (!resolveResult.isValidResult() || !containingMethod.equals(resolveResult.getElement())) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && MethodUtils.isOverridden(containingMethod)) {
                return;
            }
            this.registerMethodCallError(returnCall, containingMethod);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/performance/TailRecursionInspection$TailRecursionVisitor", "visitReturnStatement"));
        }
    }

    private static class RemoveTailRecursionFix
    extends InspectionGadgetsFix {
        private RemoveTailRecursionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("tail.recursion.replace.quickfix", new Object[0]);
            if (string == null) {
                RemoveTailRecursionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            boolean tailCallIsContainedInLoop;
            String thisVariableName;
            PsiElement tailCallToken = descriptor.getPsiElement();
            PsiMethod method = PsiTreeUtil.getParentOfType(tailCallToken, PsiMethod.class, true, PsiClass.class, PsiLambdaExpression.class);
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(project);
            if (RemoveTailRecursionFix.methodReturnsContainingClassType(method, containingClass)) {
                builder.append(containingClass.getName());
                thisVariableName = styleManager.suggestUniqueVariableName("result", (PsiElement)method, false);
                builder.append(' ').append(thisVariableName).append(" = this;");
            } else if (RemoveTailRecursionFix.methodContainsCallOnOtherInstance(method)) {
                builder.append(containingClass.getName());
                thisVariableName = styleManager.suggestUniqueVariableName("other", (PsiElement)method, false);
                builder.append(' ').append(thisVariableName).append(" = this;");
            } else {
                thisVariableName = null;
            }
            if (ControlFlowUtils.isInLoop(tailCallToken)) {
                tailCallIsContainedInLoop = true;
                builder.append(method.getName()).append(':');
            } else {
                tailCallIsContainedInLoop = false;
            }
            builder.append("while(true)");
            RemoveTailRecursionFix.replaceTailCalls(body, method, thisVariableName, tailCallIsContainedInLoop, builder);
            builder.append('}');
            PsiCodeBlock block = JavaPsiFacade.getElementFactory(project).createCodeBlockFromText(builder.toString(), method);
            body.replace(block);
            CodeStyleManager.getInstance(project).reformat(method);
        }

        private static boolean methodReturnsContainingClassType(PsiMethod method, PsiClass containingClass) {
            if (containingClass == null) {
                return false;
            }
            if (method.hasModifierProperty("static")) {
                return false;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(method.getReturnType());
            return containingClass.equals(aClass);
        }

        private static boolean methodContainsCallOnOtherInstance(PsiMethod method) {
            if (method.hasModifierProperty("static")) {
                return false;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            MethodContainsCallOnOtherInstanceVisitor visitor = new MethodContainsCallOnOtherInstanceVisitor(aClass);
            body.accept(visitor);
            return visitor.containsCallOnOtherInstance();
        }

        private static void replaceTailCalls(PsiElement element, PsiMethod method, @Nullable String thisVariableName, boolean tailCallIsContainedInLoop, @NonNls StringBuilder out) {
            if (RemoveTailRecursionFix.isImplicitCallOnThis(element, method)) {
                if (thisVariableName != null) {
                    out.append(thisVariableName).append('.');
                }
                out.append(element.getText());
            } else if (element instanceof PsiThisExpression || element instanceof PsiSuperExpression) {
                if (thisVariableName == null) {
                    out.append(element.getText());
                } else {
                    out.append(thisVariableName);
                }
            } else if (RemoveTailRecursionFix.isTailCallReturn(element, method)) {
                PsiReferenceExpression methodExpression;
                PsiExpression qualifier;
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                PsiMethodCallExpression call = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                assert (call != null);
                PsiExpression[] arguments = call.getArgumentList().getExpressions();
                PsiParameter[] parameters = method.getParameterList().getParameters();
                boolean isInBlock = returnStatement.getParent() instanceof PsiCodeBlock;
                if (!isInBlock) {
                    out.append('{');
                }
                Graph<Integer> graph = RemoveTailRecursionFix.buildGraph(parameters, arguments);
                DFSTBuilder<Integer> builder = new DFSTBuilder<Integer>(graph);
                List<Integer> sortedNodes = builder.getSortedNodes();
                HashSet<Integer> seen = new HashSet<Integer>();
                HashMap<PsiElement, String> replacements = new HashMap<PsiElement, String>();
                for (Integer index : sortedNodes) {
                    PsiReferenceExpression referenceExpression;
                    PsiParameter parameter = parameters[index];
                    String parameterName = parameter.getName();
                    assert (parameterName != null);
                    PsiExpression argument = ParenthesesUtils.stripParentheses(arguments[index]);
                    assert (argument != null);
                    if (argument instanceof PsiReferenceExpression && parameter.equals((referenceExpression = (PsiReferenceExpression)argument).resolve())) continue;
                    Iterator<Integer> dependants = graph.getIn(index);
                    boolean copy = false;
                    while (dependants.hasNext()) {
                        if (seen.contains(dependants.next())) continue;
                        copy = true;
                        break;
                    }
                    if (copy) {
                        String variableName = JavaCodeStyleManager.getInstance(method.getProject()).suggestUniqueVariableName(parameterName, element, false);
                        out.append(parameter.getType().getCanonicalText()).append(' ').append(variableName).append('=');
                        out.append(parameterName).append(';');
                        replacements.put(parameter, variableName);
                    }
                    out.append(parameterName).append('=');
                    RemoveTailRecursionFix.buildText(argument, replacements, out);
                    out.append(';');
                    seen.add(index);
                }
                if (thisVariableName != null && (qualifier = (methodExpression = call.getMethodExpression()).getQualifierExpression()) != null) {
                    out.append(thisVariableName).append('=');
                    RemoveTailRecursionFix.replaceTailCalls(qualifier, method, thisVariableName, tailCallIsContainedInLoop, out);
                    out.append(';');
                }
                PsiCodeBlock body = method.getBody();
                assert (body != null);
                if (!ControlFlowUtils.blockCompletesWithStatement(body, returnStatement)) {
                    if (tailCallIsContainedInLoop) {
                        out.append("continue ").append(method.getName()).append(';');
                    } else {
                        out.append("continue;");
                    }
                }
                if (!isInBlock) {
                    out.append('}');
                }
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    out.append(element.getText());
                } else {
                    for (PsiElement child : children) {
                        RemoveTailRecursionFix.replaceTailCalls(child, method, thisVariableName, tailCallIsContainedInLoop, out);
                    }
                }
            }
        }

        private static void buildText(PsiElement element, Map<PsiElement, String> replacements, StringBuilder out) {
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                String replacement = replacements.get(target);
                out.append(replacement != null ? replacement : element.getText());
                return;
            }
            PsiElement[] children = element.getChildren();
            if (children.length > 0) {
                for (PsiElement child : children) {
                    RemoveTailRecursionFix.buildText(child, replacements, out);
                }
            } else {
                out.append(element.getText());
            }
        }

        private static Graph<Integer> buildGraph(final PsiParameter[] parameters, final PsiExpression[] arguments) {
            InboundSemiGraph<Integer> graph = new InboundSemiGraph<Integer>(){

                @Override
                public Collection<Integer> getNodes() {
                    ArrayList<Integer> result = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < parameters.length; ++i2) {
                        result.add(i2);
                    }
                    return result;
                }

                @Override
                public Iterator<Integer> getIn(Integer n) {
                    ArrayList<Integer> result = new ArrayList<Integer>();
                    PsiParameter target = parameters[n];
                    int length = arguments.length;
                    for (int i2 = 0; i2 < length; ++i2) {
                        if (i2 == n || !VariableAccessUtils.variableIsUsed(target, arguments[i2])) continue;
                        result.add(i2);
                    }
                    return result.iterator();
                }
            };
            return GraphGenerator.generate(CachingSemiGraph.cache(graph));
        }

        private static boolean isImplicitCallOnThis(PsiElement element, PsiMethod containingMethod) {
            if (containingMethod.hasModifierProperty("static")) {
                return false;
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                return qualifierExpression == null;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    return false;
                }
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                if (qualifier != null) {
                    return false;
                }
                PsiElement target = referenceExpression.resolve();
                return target instanceof PsiField;
            }
            return false;
        }

        private static boolean isTailCallReturn(PsiElement element, PsiMethod containingMethod) {
            if (!(element instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)element;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            if (!(returnValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)returnValue;
            PsiMethod method = call.resolveMethod();
            return containingMethod.equals(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/TailRecursionInspection$RemoveTailRecursionFix", "getFamilyName"));
        }

        private static class MethodContainsCallOnOtherInstanceVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private boolean containsCallOnOtherInstance;
            private final PsiClass aClass;

            MethodContainsCallOnOtherInstanceVisitor(PsiClass aClass) {
                this.aClass = aClass;
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                if (this.containsCallOnOtherInstance) {
                    return;
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null || qualifier instanceof PsiThisExpression) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (this.aClass.equals(containingClass)) {
                    this.containsCallOnOtherInstance = true;
                }
            }

            boolean containsCallOnOtherInstance() {
                return this.containsCallOnOtherInstance;
            }
        }
    }
}

