/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.VfsUtilCore");
    private static final String MAILTO = "mailto";
    public static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    private static final String PROTOCOL_DELIMITER = ":";

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(1);
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file, @Nullable Set<VirtualFile> roots) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(2);
        }
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(@NotNull String url, @Nullable Collection<String> rootUrls) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(3);
        }
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(@NotNull String ancestorUrl, @NotNull String fileUrl) {
        if (ancestorUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(4);
        }
        if (fileUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(5);
        }
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar(ancestorUrl, '/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation(fileUrl, ancestorUrl, "/");
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(6);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(7);
        }
        return FileUtil.isAncestor(ancestor, file, strict);
    }

    @Nullable
    public static String getRelativeLocation(@Nullable VirtualFile file, @NotNull VirtualFile root) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(8);
        }
        if (file == null) {
            return null;
        }
        String path = VfsUtilCore.getRelativePath(file, root);
        return path != null ? path : file.getPresentableUrl();
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(9);
        }
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(10);
        }
        return VfsUtilCore.getRelativePath(file, ancestor, '/');
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(11);
        }
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(12);
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return StringFactory.createShared(chars);
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(13);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(14);
        }
        VirtualFile virtualFile = VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
        if (virtualFile == null) {
            VfsUtilCore.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String newName) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(16);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(17);
        }
        if (newName == null) {
            VfsUtilCore.$$$reportNull$$$0(18);
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray(), -1L, -1L, requestor);
        VirtualFile virtualFile = newChild;
        if (virtualFile == null) {
            VfsUtilCore.$$$reportNull$$$0(19);
        }
        return virtualFile;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(@NotNull byte[] buf, @NotNull VirtualFile file) throws IOException {
        if (buf == null) {
            VfsUtilCore.$$$reportNull$$$0(20);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(21);
        }
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM(stream, file);
        if (inputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(22);
        }
        return inputStream;
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file) throws IOException {
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(23);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(24);
        }
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM(stream);
        if (inputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(25);
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        byte[] bom;
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(26);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(27);
        }
        if ((bom = file.getBOM()) != null) {
            stream.write(bom);
        }
        OutputStream outputStream = stream;
        if (outputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(28);
        }
        return outputStream;
    }

    public static boolean iterateChildrenRecursively(final @NotNull VirtualFile root, final @Nullable VirtualFileFilter filter, final @NotNull ContentIterator iterator) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(29);
        }
        if (iterator == null) {
            VfsUtilCore.$$$reportNull$$$0(30);
        }
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (filter != null && !filter.accept(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (!iterator.processFile(file)) {
                    VirtualFileVisitor.Result result = 1.skipTo(root);
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(3);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return !Comparing.equal(result.skipToParent, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        VirtualFileVisitor.Result result;
        block22: {
            Object object;
            boolean visited;
            boolean pushed;
            block25: {
                int n;
                block26: {
                    block24: {
                        VirtualFile[] children;
                        block23: {
                            if (file == null) {
                                VfsUtilCore.$$$reportNull$$$0(31);
                            }
                            if (visitor == null) {
                                VfsUtilCore.$$$reportNull$$$0(32);
                            }
                            pushed = false;
                            visited = visitor.allowVisitFile(file);
                            if (visited) {
                                VirtualFileVisitor.Result result2 = visitor.visitFileEx(file);
                                if (result2.skipChildren) {
                                    VirtualFileVisitor.Result result3 = result2;
                                    VirtualFileVisitor.Result result4 = result3;
                                    if (result4 == null) {
                                        VfsUtilCore.$$$reportNull$$$0(33);
                                    }
                                    return result4;
                                }
                            }
                            Iterable<VirtualFile> childrenIterable = null;
                            children = null;
                            try {
                                if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                                    children = file.getChildren();
                                }
                            }
                            catch (InvalidVirtualFileAccessException e) {
                                LOG.info("Ignoring: " + e.getMessage());
                                VirtualFileVisitor.Result result5 = VirtualFileVisitor.CONTINUE;
                                visitor.restoreValue(pushed);
                                VirtualFileVisitor.Result result6 = result5;
                                if (result6 == null) {
                                    VfsUtilCore.$$$reportNull$$$0(34);
                                }
                                return result6;
                            }
                            if (childrenIterable == null) break block23;
                            visitor.saveValue();
                            pushed = true;
                            object = childrenIterable.iterator();
                            break block24;
                        }
                        if (children == null || children.length == 0) break block25;
                        visitor.saveValue();
                        pushed = true;
                        object = children;
                        n = ((Object)object).length;
                        break block26;
                    }
                    while (object.hasNext()) {
                        VirtualFile child = (VirtualFile)object.next();
                        VirtualFileVisitor.Result result7 = VfsUtilCore.visitChildrenRecursively(child, visitor);
                        if (result7.skipToParent == null || Comparing.equal(result7.skipToParent, child)) continue;
                        VirtualFileVisitor.Result result8 = result7;
                        VirtualFileVisitor.Result result9 = result8;
                        if (result9 == null) {
                            VfsUtilCore.$$$reportNull$$$0(35);
                        }
                        return result9;
                    }
                    break block25;
                }
                for (int i = 0; i < n; ++i) {
                    Object child = object[i];
                    VirtualFileVisitor.Result result10 = VfsUtilCore.visitChildrenRecursively((VirtualFile)child, visitor);
                    if (result10.skipToParent == null || Comparing.equal(result10.skipToParent, child)) continue;
                    VirtualFileVisitor.Result result11 = result10;
                    result = result11;
                    break block22;
                }
            }
            if (visited) {
                visitor.afterChildrenVisited(file);
            }
            object = VirtualFileVisitor.CONTINUE;
            Object object2 = object;
            if (object2 == null) {
                VfsUtilCore.$$$reportNull$$$0(37);
            }
            return object2;
            finally {
                visitor.restoreValue(pushed);
            }
        }
        if (result == null) {
            VfsUtilCore.$$$reportNull$$$0(36);
        }
        return result;
    }

    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor visitor, @NotNull Class<E> eClass) throws E {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(38);
        }
        if (visitor == null) {
            VfsUtilCore.$$$reportNull$$$0(39);
        }
        if (eClass == null) {
            VfsUtilCore.$$$reportNull$$$0(40);
        }
        try {
            return VfsUtilCore.visitChildrenRecursively(file, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(41);
        }
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        VirtualFile target;
        if (link == null) {
            VfsUtilCore.$$$reportNull$$$0(42);
        }
        return (target = link.getCanonicalFile()) == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(43);
        }
        String string = VfsUtilCore.loadText(file, (int)file.getLength());
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(44);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadText(@NotNull VirtualFile file, int length) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(45);
        }
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        String string = StringFactory.createShared(FileUtil.loadText(reader, length));
        String string2 = string;
        if (string2 == null) {
            VfsUtilCore.$$$reportNull$$$0(46);
        }
        return string2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static byte[] loadBytes(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(47);
        }
        byte[] byArray = FileUtilRt.isTooLarge(file.getLength()) ? FileUtil.loadFirstAndClose(file.getInputStream(), FileUtilRt.LARGE_FILE_PREVIEW_SIZE) : file.contentsToByteArray();
        if (byArray == null) {
            VfsUtilCore.$$$reportNull$$$0(48);
        }
        return byArray;
    }

    @NotNull
    public static VirtualFile[] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        int size;
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(49);
        }
        if ((size = files.size()) == 0) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                VfsUtilCore.$$$reportNull$$$0(50);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = files.toArray(new VirtualFile[size]);
        if (virtualFileArray == null) {
            VfsUtilCore.$$$reportNull$$$0(51);
        }
        return virtualFileArray;
    }

    @NotNull
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            if ("" == null) {
                VfsUtilCore.$$$reportNull$$$0(52);
            }
            return "";
        }
        String string = VirtualFileManager.extractPath(url);
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(54);
        }
        File file2 = new File(PathUtil.toPresentableUrl(file.getUrl()));
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(55);
        }
        return file2;
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        if (path == null) {
            VfsUtilCore.$$$reportNull$$$0(56);
        }
        String string = VirtualFileManager.constructUrl("file", path);
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(57);
        }
        return string;
    }

    public static List<File> virtualToIoFiles(@NotNull Collection<VirtualFile> scope) {
        if (scope == null) {
            VfsUtilCore.$$$reportNull$$$0(58);
        }
        return ContainerUtil.map2List(scope, file -> VfsUtilCore.virtualToIoFile(file));
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(59);
        }
        String string = VfsUtilCore.toIdeaUrl(url, true);
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url, boolean removeLocalhostPrefix) {
        int index;
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(61);
        }
        if ((index = url.indexOf(":/")) < 0 || index + 2 >= url.length()) {
            String string = url;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(62);
            }
            return string;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfoRt.isWindows) {
                String string = prefix + "://" + suffix;
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(63);
                }
                return string;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                String string = prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(64);
                }
                return string;
            }
            String string = prefix + ":///" + suffix;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(65);
            }
            return string;
        }
        if (SystemInfoRt.isWindows && index + 3 < url.length() && url.charAt(index + 3) == '/' && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i = index + 4; i < url.length() && (c = url.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                String string = "file://" + url.substring(index + 4);
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(66);
                }
                return string;
            }
            String string = url;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(67);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(69);
        }
        String string = VfsUtilCore.toIdeaUrl(url, false);
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(70);
        }
        return string;
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(71);
        }
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation(path, "file", PROTOCOL_DELIMITER)) {
                try {
                    URL subURL = new URL(path);
                    path = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(VfsBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(VfsBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfo.isWindows) {
            while (!path.isEmpty() && path.charAt(0) == '/') {
                path = path.substring(1, path.length());
            }
        }
        path = URLUtil.unescapePercentSequences(path);
        String string = protocol + "://" + path;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(72);
        }
        return string;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(73);
        }
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path = split[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path);
            }
            return UrlClassLoader.internProtocol(new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        if (ideaUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(74);
        }
        String ideaProtocolMarker = "://";
        int idx = ideaUrl.indexOf("://");
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            String urlWithoutProtocol = ideaUrl.substring(idx + "://".length());
            ideaUrl = s + PROTOCOL_DELIMITER + (urlWithoutProtocol.startsWith("/") ? "" : "/") + urlWithoutProtocol;
        }
        String string = ideaUrl;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(75);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull String uri, @Nullable VirtualFile base) {
        if (uri == null) {
            VfsUtilCore.$$$reportNull$$$0(76);
        }
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else {
            uri = StringUtil.trimStart(uri, "file:");
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfo.isWindows && StringUtil.startsWithChar(uri, '/') || SystemInfo.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + "/" + uri);
            if (file == null) {
                return null;
            }
        }
        return file;
    }

    public static boolean processFilesRecursively(final @NotNull VirtualFile root, final @NotNull Processor<VirtualFile> processor) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(77);
        }
        if (processor == null) {
            VfsUtilCore.$$$reportNull$$$0(78);
        }
        final Ref<Boolean> result = Ref.create(true);
        VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!processor.process(file)) {
                    result.set(Boolean.FALSE);
                    VirtualFileVisitor.Result result2 = 2.skipTo(root);
                    if (result2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return result.get();
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            VfsUtilCore.$$$reportNull$$$0(79);
        }
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(80);
        }
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        VirtualFile[] path1 = VfsUtilCore.getPathComponents(file1);
        VirtualFile[] path2 = VfsUtilCore.getPathComponents(file2);
        int lastEqualIdx = -1;
        int i = 0;
        while (i < path1.length && i < path2.length && path1[i].equals(path2[i])) {
            lastEqualIdx = i++;
        }
        return lastEqualIdx == -1 ? null : path1[lastEqualIdx];
    }

    @NotNull
    static VirtualFile[] getPathComponents(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(81);
        }
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        if (components == null) {
            VfsUtilCore.$$$reportNull$$$0(82);
        }
        return components;
    }

    public static boolean hasInvalidFiles(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(83);
        }
        for (VirtualFile file : files) {
            if (file.isValid()) continue;
            return true;
        }
        return false;
    }

    public static void processFilesRecursively(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor, @NotNull Convertor<VirtualFile, Boolean> directoryFilter) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(84);
        }
        if (processor == null) {
            VfsUtilCore.$$$reportNull$$$0(85);
        }
        if (directoryFilter == null) {
            VfsUtilCore.$$$reportNull$$$0(86);
        }
        if (!processor.process(root)) {
            return;
        }
        if (root.isDirectory() && directoryFilter.convert(root).booleanValue()) {
            LinkedList<VirtualFile[]> queue = new LinkedList<VirtualFile[]>();
            queue.add(root.getChildren());
            do {
                VirtualFile[] files;
                for (VirtualFile file : files = (VirtualFile[])queue.removeFirst()) {
                    if (!processor.process(file)) {
                        return;
                    }
                    if (!file.isDirectory() || !directoryFilter.convert(file).booleanValue()) continue;
                    queue.add(file.getChildren());
                }
            } while (!queue.isEmpty());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 54: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 59: 
            case 61: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 8: 
            case 29: 
            case 77: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eClass";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 49: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfsUrl";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaUrl";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 78: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "byteStreamSkippingBOM";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "inputStreamSkippingBOM";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "outputStreamAddingBOM";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "visitChildrenRecursively";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "toVirtualFileArray";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToPath";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "virtualToIoFile";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToUrl";
                break;
            }
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "toIdeaUrl";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "fixURLforIDEA";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromUrl";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "fixIDEAUrl";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualOrAncestor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeLocation";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 82: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "byteStreamSkippingBOM";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamSkippingBOM";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "outputStreamAddingBOM";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "iterateChildrenRecursively";
                break;
            }
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitChildrenRecursively";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenLink";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidLink";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "toVirtualFileArray";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFile";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "pathToUrl";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFiles";
                break;
            }
            case 59: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "toIdeaUrl";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "fixURLforIDEA";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "convertFromUrl";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "convertToURL";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "fixIDEAUrl";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestor";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getPathComponents";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection() {
        }

        public DistinctVFilesRootsCollection(Collection<VirtualFile> virtualFiles) {
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile[] collection) {
            super(collection);
        }

        @Override
        protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile) {
            if (ancestor == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(1);
            }
            return VfsUtilCore.isAncestor(ancestor, virtualFile, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ancestor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/VfsUtilCore$DistinctVFilesRootsCollection";
            objectArray[2] = "isAncestor";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

