/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    private static final Logger LOG = Logger.getInstance(ClassFileDecompiler.class);

    @Override
    @NotNull
    public CharSequence decompile(@NotNull VirtualFile file) {
        ClassFileDecompilers.Decompiler decompiler;
        if (file == null) {
            ClassFileDecompiler.$$$reportNull$$$0(0);
        }
        if ((decompiler = ClassFileDecompilers.find(file)) instanceof ClassFileDecompilers.Full) {
            PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
            CharSequence charSequence = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file, manager, true).getContents();
            if (charSequence == null) {
                ClassFileDecompiler.$$$reportNull$$$0(1);
            }
            return charSequence;
        }
        if (decompiler instanceof ClassFileDecompilers.Light) {
            CharSequence charSequence;
            try {
                charSequence = ((ClassFileDecompilers.Light)decompiler).getText(file);
            }
            catch (ClassFileDecompilers.Light.CannotDecompileException e) {
                LOG.warn("decompiler: " + decompiler.getClass(), e);
            }
            if (charSequence == null) {
                ClassFileDecompiler.$$$reportNull$$$0(2);
            }
            return charSequence;
        }
        CharSequence charSequence = ClsFileImpl.decompile(file);
        if (charSequence == null) {
            ClassFileDecompiler.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClassFileDecompiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClassFileDecompiler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "decompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decompile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

