/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.impl.source.tree.java.FieldElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiArrayInitializerExpressionImpl
extends ExpressionPsiElement
implements PsiArrayInitializerExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiArrayInitializerExpressionImpl");

    public PsiArrayInitializerExpressionImpl() {
        super(JavaElementType.ARRAY_INITIALIZER_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression[] getInitializers() {
        PsiExpression[] psiExpressionArray = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        if (psiExpressionArray == null) {
            PsiArrayInitializerExpressionImpl.$$$reportNull$$$0(0);
        }
        return psiExpressionArray;
    }

    @Override
    public PsiType getType() {
        if (this.getTreeParent() instanceof PsiNewExpression) {
            if (this.getTreeParent().getChildRole(this) == 77) {
                return ((PsiNewExpression)((Object)this.getTreeParent())).getType();
            }
        } else {
            if (this.getTreeParent() instanceof PsiVariable) {
                return ((PsiVariable)((Object)this.getTreeParent())).getType();
            }
            if (this.getTreeParent() instanceof PsiArrayInitializerExpression) {
                PsiType parentType = ((PsiArrayInitializerExpression)((Object)this.getTreeParent())).getType();
                if (!(parentType instanceof PsiArrayType)) {
                    return null;
                }
                PsiType componentType = ((PsiArrayType)parentType).getComponentType();
                return componentType instanceof PsiArrayType ? componentType : null;
            }
            if (this.getTreeParent() instanceof FieldElement) {
                return ((PsiField)this.getParent()).getType();
            }
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return this.findChildByType(JavaTokenType.RBRACE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LBRACE) {
            return 18;
        }
        if (i == JavaTokenType.RBRACE) {
            return 19;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiArrayInitializerExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitArrayInitializerExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiArrayInitializerExpression:" + this.getText();
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(19);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(18);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (ElementType.EXPRESSION_BIT_SET.contains(first.getElementType())) {
            LeafElement comma;
            ASTNode child;
            CharTable charTab = SharedImplUtil.findCharTableByTree(this);
            for (child = first.getTreeNext(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreeNext()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, charTab, this.getManager());
                super.addInternal(comma, comma, first, Boolean.FALSE);
                break;
            }
            for (child = first.getTreePrev(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreePrev()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, charTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        return firstAdded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

